/*
 * Decompiled with CFR 0.152.
 */
package dev.arbjerg.lavalink.client;

import dev.arbjerg.lavalink.client.LavalinkNode;
import dev.arbjerg.lavalink.client.Link;
import dev.arbjerg.lavalink.client.LinkState;
import dev.arbjerg.lavalink.client.NodeOptions;
import dev.arbjerg.lavalink.client.event.ClientEvent;
import dev.arbjerg.lavalink.client.loadbalancing.ILoadBalancer;
import dev.arbjerg.lavalink.client.loadbalancing.VoiceRegion;
import dev.arbjerg.lavalink.client.loadbalancing.builtin.DefaultLoadBalancer;
import dev.arbjerg.lavalink.client.player.LavalinkPlayer;
import dev.arbjerg.lavalink.internal.ReconnectTask;
import dev.arbjerg.lavalink.protocol.v4.Session;
import dev.arbjerg.lavalink.protocol.v4.VoiceState;
import java.io.Closeable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020+J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020-H\u0016J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u0014H\u0002J\u0010\u00101\u001a\u0004\u0018\u00010\u00122\u0006\u00102\u001a\u00020\u0004J\u001d\u00103\u001a\u00020\u00122\u0006\u00102\u001a\u00020\u00042\u0006\u00104\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b5J\u001c\u00103\u001a\u00020\u00122\u0006\u00102\u001a\u00020\u00042\n\b\u0002\u00106\u001a\u0004\u0018\u000107H\u0007J\u0010\u00108\u001a\u00020-2\u0006\u00104\u001a\u00020\u000fH\u0002J\u001b\u00109\u001a\b\u0012\u0004\u0012\u0002H:0\t\"\n\b\u0000\u0010:\u0018\u0001*\u00020\nH\u0086\bJ$\u00109\u001a\b\u0012\u0004\u0012\u0002H:0\t\"\b\b\u0000\u0010:*\u00020\n2\f\u0010;\u001a\b\u0012\u0004\u0012\u0002H:0<J\u0015\u0010=\u001a\u00020-2\u0006\u00104\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b>J\u0015\u0010?\u001a\u00020-2\u0006\u00104\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b@J\u0015\u0010A\u001a\u00020-2\u0006\u00102\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\bBJ\u000e\u0010C\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u000fJ\u000e\u0010C\u001a\u00020\u00072\u0006\u0010D\u001a\u00020EJ\u0015\u0010F\u001a\u00020-2\u0006\u00104\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\bGJ\u0015\u0010H\u001a\u00020-2\u0006\u00104\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\bIJ\u000e\u0010J\u001a\u00020\u0007*\u0004\u0018\u00010KH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R \u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00148F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0016R\u0016\u0010!\u001a\n #*\u0004\u0018\u00010\"0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u0006L"}, d2={"Ldev/arbjerg/lavalink/client/LavalinkClient;", "Ljava/io/Closeable;", "Lreactor/core/Disposable;", "userId", "", "(J)V", "clientOpen", "", "flux", "Lreactor/core/publisher/Flux;", "Ldev/arbjerg/lavalink/client/event/ClientEvent;", "getFlux", "()Lreactor/core/publisher/Flux;", "internalNodes", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Ldev/arbjerg/lavalink/client/LavalinkNode;", "linkMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Ldev/arbjerg/lavalink/client/Link;", "links", "", "getLinks", "()Ljava/util/List;", "loadBalancer", "Ldev/arbjerg/lavalink/client/loadbalancing/ILoadBalancer;", "getLoadBalancer$annotations", "()V", "getLoadBalancer", "()Ldev/arbjerg/lavalink/client/loadbalancing/ILoadBalancer;", "setLoadBalancer", "(Ldev/arbjerg/lavalink/client/loadbalancing/ILoadBalancer;)V", "nodes", "getNodes", "reconnectService", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "reference", "sink", "Lreactor/core/publisher/Sinks$Many;", "getUserId", "()J", "addNode", "nodeOptions", "Ldev/arbjerg/lavalink/client/NodeOptions;", "close", "", "dispose", "findOrphanedPlayers", "Ldev/arbjerg/lavalink/client/player/LavalinkPlayer;", "getLinkIfCached", "guildId", "getOrCreateLink", "node", "getOrCreateLink$lavalink_client", "region", "Ldev/arbjerg/lavalink/client/loadbalancing/VoiceRegion;", "listenForNodeEvent", "on", "T", "type", "Ljava/lang/Class;", "onNodeDisconnected", "onNodeDisconnected$lavalink_client", "onResumeReconnectFailed", "onResumeReconnectFailed$lavalink_client", "removeDestroyedLink", "removeDestroyedLink$lavalink_client", "removeNode", "name", "", "transferNodes", "transferNodes$lavalink_client", "transferOrphansTo", "transferOrphansTo$lavalink_client", "isEmpty", "Ldev/arbjerg/lavalink/protocol/v4/VoiceState;", "lavalink-client"})
@SourceDebugExtension(value={"SMAP\nLavalinkClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LavalinkClient.kt\ndev/arbjerg/lavalink/client/LavalinkClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 7 LavalinkNode.kt\ndev/arbjerg/lavalink/client/LavalinkNode\n*L\n1#1,265:1\n1747#2,3:266\n288#2,2:269\n1603#2,9:277\n1855#2:286\n1856#2:288\n1612#2:289\n766#2:290\n857#2,2:291\n1855#2,2:293\n766#2:295\n857#2,2:296\n1360#2:298\n1446#2,5:299\n1726#2,3:306\n1855#2,2:320\n72#3,2:271\n72#3,2:274\n1#4:273\n1#4:276\n1#4:287\n1#4:323\n215#5,2:304\n215#5,2:316\n215#5,2:318\n526#6:309\n511#6,6:310\n112#7:322\n*S KotlinDebug\n*F\n+ 1 LavalinkClient.kt\ndev/arbjerg/lavalink/client/LavalinkClient\n*L\n61#1:266,3\n77#1:269,2\n144#1:277,9\n144#1:286\n144#1:288\n144#1:289\n145#1:290\n145#1:291,2\n146#1:293,2\n155#1:295\n155#1:296,2\n157#1:298\n157#1:299,5\n177#1:306,3\n234#1:320,2\n109#1:271,2\n122#1:274,2\n109#1:273\n122#1:276\n144#1:287\n170#1:304,2\n179#1:316,2\n200#1:318,2\n178#1:309\n178#1:310,6\n247#1:322\n*E\n"})
public final class LavalinkClient
implements Closeable,
Disposable {
    private final long userId;
    @NotNull
    private final CopyOnWriteArrayList<LavalinkNode> internalNodes;
    @NotNull
    private final ConcurrentHashMap<Long, Link> linkMap;
    private boolean clientOpen;
    @NotNull
    private final Sinks.Many<ClientEvent> sink;
    @NotNull
    private final Flux<ClientEvent> flux;
    @NotNull
    private final Disposable reference;
    @NotNull
    private ILoadBalancer loadBalancer;
    private final ScheduledExecutorService reconnectService;

    public LavalinkClient(long userId) {
        this.userId = userId;
        this.internalNodes = new CopyOnWriteArrayList();
        this.linkMap = new ConcurrentHashMap();
        this.clientOpen = true;
        Sinks.Many many = Sinks.many().multicast().onBackpressureBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)many, (String)"onBackpressureBuffer(...)");
        this.sink = many;
        Flux flux = this.sink.asFlux();
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"asFlux(...)");
        this.flux = flux;
        Disposable disposable = this.flux.subscribe();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        this.reference = disposable;
        this.loadBalancer = new DefaultLoadBalancer(this);
        this.reconnectService = Executors.newSingleThreadScheduledExecutor(LavalinkClient::reconnectService$lambda$1);
        this.reconnectService.scheduleWithFixedDelay(new ReconnectTask(this), 0L, 500L, TimeUnit.MILLISECONDS);
    }

    public final long getUserId() {
        return this.userId;
    }

    @NotNull
    public final List<LavalinkNode> getNodes() {
        return CollectionsKt.toList((Iterable)this.internalNodes);
    }

    @NotNull
    public final List<Link> getLinks() {
        Collection<Link> collection = this.linkMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.toList((Iterable)collection);
    }

    @NotNull
    public final Flux<ClientEvent> getFlux() {
        return this.flux;
    }

    @NotNull
    public final ILoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public final void setLoadBalancer(@NotNull ILoadBalancer iLoadBalancer) {
        Intrinsics.checkNotNullParameter((Object)iLoadBalancer, (String)"<set-?>");
        this.loadBalancer = iLoadBalancer;
    }

    public static /* synthetic */ void getLoadBalancer$annotations() {
    }

    @NotNull
    public final LavalinkNode addNode(@NotNull NodeOptions nodeOptions) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)nodeOptions, (String)"nodeOptions");
            Iterable $this$any$iv = this.getNodes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LavalinkNode it = (LavalinkNode)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)nodeOptions.getName())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new IllegalStateException("Node with name '" + nodeOptions.getName() + "' already exists");
        }
        LavalinkNode node = new LavalinkNode(nodeOptions, this);
        this.internalNodes.add(node);
        this.listenForNodeEvent(node);
        return node;
    }

    public final boolean removeNode(@NotNull String name) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable $this$firstOrNull$iv = this.getNodes();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                LavalinkNode it = (LavalinkNode)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        LavalinkNode node = v0;
        if (node == null) {
            throw new IllegalStateException("Node with name '" + name + "' does not exist");
        }
        return this.removeNode(node);
    }

    public final boolean removeNode(@NotNull LavalinkNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!this.internalNodes.contains(node)) {
            return false;
        }
        node.close();
        this.internalNodes.remove(node);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final Link getOrCreateLink(long guildId, @Nullable VoiceRegion region) {
        void $this$getOrPut$iv;
        ConcurrentMap concurrentMap = this.linkMap;
        Long key$iv = guildId;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            Link default$iv = new Link(guildId, this.loadBalancer.selectNode(region, guildId));
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
        return (Link)object;
    }

    public static /* synthetic */ Link getOrCreateLink$default(LavalinkClient lavalinkClient, long l, VoiceRegion voiceRegion, int n, Object object) {
        if ((n & 2) != 0) {
            voiceRegion = null;
        }
        return lavalinkClient.getOrCreateLink(l, voiceRegion);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Link getOrCreateLink$lavalink_client(long guildId, @NotNull LavalinkNode node) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        ConcurrentMap concurrentMap = this.linkMap;
        Long key$iv = guildId;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            Link default$iv = new Link(guildId, node);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
        return (Link)object;
    }

    @Nullable
    public final Link getLinkIfCached(long guildId) {
        return this.linkMap.get(guildId);
    }

    /*
     * WARNING - void declaration
     */
    public final void transferOrphansTo$lavalink_client(@NotNull LavalinkNode node) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!node.getAvailable()) {
            return;
        }
        List<LavalinkPlayer> orphans = this.findOrphanedPlayers();
        Iterable $this$mapNotNull$iv = orphans;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Link it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            LavalinkPlayer it = (LavalinkPlayer)element$iv$iv;
            boolean bl2 = false;
            if (this.linkMap.get(it.getGuildId()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Link it = (Link)element$iv$iv;
            boolean bl = false;
            LavalinkPlayer lavalinkPlayer = it.getCachedPlayer();
            if (!(!this.isEmpty((VoiceState)(lavalinkPlayer != null ? lavalinkPlayer.getVoiceState() : null)))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Link link = (Link)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)link);
            Link.transferNode$lavalink_client$default(link, node, null, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<LavalinkPlayer> findOrphanedPlayers() {
        void $this$flatMapTo$iv$iv;
        LavalinkNode it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getNodes();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (LavalinkNode)element$iv$iv;
            boolean bl = false;
            if (!(!it.getAvailable())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unavailableNodes = (List)destination$iv$iv;
        Iterable $this$flatMap$iv = unavailableNodes;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (LavalinkNode)element$iv$iv;
            boolean bl = false;
            Collection<LavalinkPlayer> collection = it.getPlayerCache$lavalink_client().values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable list$iv$iv = collection;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final void onNodeDisconnected$lavalink_client(@NotNull LavalinkNode node) {
        boolean canResume;
        boolean bl;
        block11: {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (!this.clientOpen) {
                return;
            }
            if (this.getNodes().size() == 1 && Intrinsics.areEqual((Object)CollectionsKt.first(this.getNodes()), (Object)node)) {
                Map $this$forEach$iv = this.linkMap;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    Link link = (Link)entry.getValue();
                    link.setState$lavalink_client(LinkState.DISCONNECTED);
                }
                return;
            }
            Iterable $this$all$iv = this.getNodes();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    LavalinkNode it = (LavalinkNode)element$iv;
                    boolean bl3 = false;
                    if (!it.getAvailable()) continue;
                    bl = false;
                    break block11;
                }
                bl = true;
            }
        }
        if (bl) {
            void $this$filterTo$iv$iv;
            Map $this$filter$iv = this.linkMap;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator bl3 = $this$filterTo$iv$iv.entrySet().iterator();
            while (bl3.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry entry = element$iv$iv = bl3.next();
                boolean bl4 = false;
                Link link = (Link)entry.getValue();
                if (!Intrinsics.areEqual((Object)link.getNode(), (Object)node)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map $this$forEach$iv = destination$iv$iv;
            boolean $i$f$forEach = false;
            iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object object = element$iv = iterator.next();
                boolean bl5 = false;
                Link link = (Link)object.getValue();
                link.setState$lavalink_client(LinkState.DISCONNECTED);
            }
            return;
        }
        Session session = node.getCachedSession$lavalink_client();
        boolean bl6 = canResume = session != null && session.getResuming() && session.getTimeoutSeconds() > 0L;
        if (canResume) {
            node.getWs().onResumableConnectionDisconnected$lavalink_client();
        } else {
            this.transferNodes$lavalink_client(node);
        }
    }

    public final void onResumeReconnectFailed$lavalink_client(@NotNull LavalinkNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.transferNodes$lavalink_client(node);
    }

    public final void transferNodes$lavalink_client(@NotNull LavalinkNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Map $this$forEach$iv = this.linkMap;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            Link link = (Link)entry.getValue();
            if (!Intrinsics.areEqual((Object)link.getNode(), (Object)node)) continue;
            LavalinkPlayer lavalinkPlayer = link.getCachedPlayer();
            VoiceRegion voiceRegion = lavalinkPlayer != null ? lavalinkPlayer.getVoiceRegion() : null;
            LavalinkNode lavalinkNode = this.loadBalancer.selectNode(voiceRegion, link.getGuildId());
            Duration duration = Duration.ofMillis(1000L);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
            link.transferNode$lavalink_client(lavalinkNode, duration);
        }
    }

    @NotNull
    public final <T extends ClientEvent> Flux<T> on(@NotNull Class<T> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Flux flux = this.flux.ofType(type);
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"ofType(...)");
        return flux;
    }

    public final /* synthetic */ <T extends ClientEvent> Flux<T> on() {
        boolean $i$f$on = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.on(ClientEvent.class);
    }

    @Override
    public void close() {
        this.clientOpen = false;
        this.reconnectService.shutdownNow();
        Iterable $this$forEach$iv = this.getNodes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LavalinkNode it = (LavalinkNode)element$iv;
            boolean bl = false;
            it.close();
        }
        this.reference.dispose();
    }

    public void dispose() {
        this.close();
    }

    public final void removeDestroyedLink$lavalink_client(long guildId) {
        this.linkMap.remove(guildId);
    }

    private final void listenForNodeEvent(LavalinkNode node) {
        LavalinkNode this_$iv = node;
        boolean $i$f$on = false;
        this_$iv.on(ClientEvent.class).subscribe(arg_0 -> LavalinkClient.listenForNodeEvent$lambda$17((Function1)new Function1<ClientEvent, Unit>(this){
            final /* synthetic */ LavalinkClient this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(ClientEvent it) {
                try {
                    LavalinkClient.access$getSink$p(this.this$0).tryEmitNext((Object)it);
                }
                catch (Exception e) {
                    LavalinkClient.access$getSink$p(this.this$0).emitError((Throwable)e, Sinks.EmitFailureHandler.FAIL_FAST);
                }
            }
        }, arg_0));
    }

    private final boolean isEmpty(VoiceState $this$isEmpty) {
        if ($this$isEmpty == null) {
            return true;
        }
        return StringsKt.isBlank((CharSequence)$this$isEmpty.getToken()) || StringsKt.isBlank((CharSequence)$this$isEmpty.getEndpoint()) || StringsKt.isBlank((CharSequence)$this$isEmpty.getSessionId());
    }

    @JvmOverloads
    @NotNull
    public final Link getOrCreateLink(long guildId) {
        return LavalinkClient.getOrCreateLink$default(this, guildId, null, 2, null);
    }

    private static final Thread reconnectService$lambda$1(Runnable it) {
        Thread thread;
        Thread $this$reconnectService_u24lambda_u241_u24lambda_u240 = thread = new Thread(it, "lavalink-reconnect-thread");
        boolean bl = false;
        $this$reconnectService_u24lambda_u241_u24lambda_u240.setDaemon(true);
        return thread;
    }

    private static final void listenForNodeEvent$lambda$17(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Sinks.Many access$getSink$p(LavalinkClient $this) {
        return $this.sink;
    }
}

