/*
 * Decompiled with CFR 0.152.
 */
package dev.arbjerg.lavalink.client;

import dev.arbjerg.lavalink.client.LavalinkClient;
import dev.arbjerg.lavalink.client.LavalinkNode;
import dev.arbjerg.lavalink.client.Link;
import dev.arbjerg.lavalink.client.LinkState;
import dev.arbjerg.lavalink.client.NodeOptions;
import dev.arbjerg.lavalink.client.event.ClientEvent;
import dev.arbjerg.lavalink.client.event.ResumeSynchronizationEvent;
import dev.arbjerg.lavalink.client.http.HttpBuilder;
import dev.arbjerg.lavalink.client.loadbalancing.IRegionFilter;
import dev.arbjerg.lavalink.client.player.LavalinkLoadResult;
import dev.arbjerg.lavalink.client.player.LavalinkPlayer;
import dev.arbjerg.lavalink.client.player.PlayerUpdateBuilder;
import dev.arbjerg.lavalink.client.player.Track;
import dev.arbjerg.lavalink.internal.HelpersKt;
import dev.arbjerg.lavalink.internal.JsonParserKt;
import dev.arbjerg.lavalink.internal.LavalinkRestClient;
import dev.arbjerg.lavalink.internal.LavalinkSocket;
import dev.arbjerg.lavalink.internal.error.RestException;
import dev.arbjerg.lavalink.internal.loadbalancing.Penalties;
import dev.arbjerg.lavalink.protocol.v4.Error;
import dev.arbjerg.lavalink.protocol.v4.Info;
import dev.arbjerg.lavalink.protocol.v4.Mapper;
import dev.arbjerg.lavalink.protocol.v4.Player;
import dev.arbjerg.lavalink.protocol.v4.Players;
import dev.arbjerg.lavalink.protocol.v4.Session;
import dev.arbjerg.lavalink.protocol.v4.Stats;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JvmStreamsKt;
import kotlinx.serialization.modules.SerializersModule;
import okhttp3.Cache;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.publisher.Sinks;
import reactor.kotlin.core.publisher.MonoExtensionsKt;
import reactor.util.retry.Retry;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010S\u001a\u00020TH\u0016J\u000e\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u000201J.\u0010X\u001a\b\u0012\u0004\u0012\u0002HZ0Y\"\u0004\b\u0000\u0010Z2\f\u0010[\u001a\b\u0012\u0004\u0012\u0002HZ0\\2\f\u0010]\u001a\b\u0012\u0004\u0012\u00020_0^J%\u0010X\u001a\b\u0012\u0004\u0012\u0002HZ0Y\"\u0006\b\u0000\u0010Z\u0018\u00012\f\u0010]\u001a\b\u0012\u0004\u0012\u00020_0^H\u0086\bJ.\u0010X\u001a\b\u0012\u0004\u0012\u0002HZ0Y\"\u0004\b\u0000\u0010Z2\f\u0010`\u001a\b\u0012\u0004\u0012\u0002HZ0a2\f\u0010]\u001a\b\u0012\u0004\u0012\u00020_0^J\u001a\u0010b\u001a\b\u0012\u0004\u0012\u00020c0Y2\f\u0010]\u001a\b\u0012\u0004\u0012\u00020_0^J\u0014\u0010d\u001a\b\u0012\u0004\u0012\u00020e0Y2\u0006\u0010f\u001a\u00020\u0010J \u0010g\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020e0h0Y2\f\u0010f\u001a\b\u0012\u0004\u0012\u00020\u00100hJ\u0014\u0010i\u001a\b\u0012\u0004\u0012\u00020T0Y2\u0006\u0010W\u001a\u000201J\f\u0010j\u001a\b\u0012\u0004\u0012\u00020\u00140YJ\b\u0010k\u001a\u00020TH\u0016J\u0014\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00140Y2\u0006\u0010m\u001a\u00020nJ\u0013\u0010o\u001a\u00020\t2\b\u0010p\u001a\u0004\u0018\u00010qH\u0096\u0002J\u0017\u0010r\u001a\u0004\u0018\u0001022\u0006\u0010W\u001a\u000201H\u0000\u00a2\u0006\u0002\bsJ\u0010\u0010t\u001a\u0004\u0018\u0001022\u0006\u0010W\u001a\u000201J\u0012\u0010u\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u0002020vJ\f\u0010w\u001a\b\u0012\u0004\u0012\u00020x0YJ\u0014\u0010y\u001a\b\u0012\u0004\u0012\u0002020Y2\u0006\u0010W\u001a\u000201J\u0012\u0010z\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002020h0YJ\b\u0010{\u001a\u00020|H\u0016J\u0014\u0010}\u001a\b\u0012\u0004\u0012\u00020~0Y2\u0006\u0010\u007f\u001a\u00020\u0010J\u001c\u0010\u0080\u0001\u001a\b\u0012\u0004\u0012\u0002HZ0\u001a\"\n\b\u0000\u0010Z\u0018\u0001*\u00020\u001bH\u0086\bJ&\u0010\u0080\u0001\u001a\b\u0012\u0004\u0012\u0002HZ0\u001a\"\b\b\u0000\u0010Z*\u00020\u001b2\r\u0010\u0081\u0001\u001a\b\u0012\u0004\u0012\u0002HZ0\\J\u0017\u0010\u0082\u0001\u001a\u00020T2\u0006\u0010W\u001a\u000201H\u0000\u00a2\u0006\u0003\b\u0083\u0001J\u000f\u0010\u0084\u0001\u001a\u00020TH\u0000\u00a2\u0006\u0003\b\u0085\u0001J\t\u0010\u0086\u0001\u001a\u00020\u0010H\u0016J\u0007\u0010\u0087\u0001\u001a\u00020TJ\u000f\u0010\u0088\u0001\u001a\u00020TH\u0000\u00a2\u0006\u0003\b\u0089\u0001J\u0007\u0010\u008a\u0001\u001a\u00020TJ%\u0010\u008b\u0001\u001a\b\u0012\u0004\u0012\u0002020Y2\u0006\u0010W\u001a\u0002012\u000e\u0010\u008c\u0001\u001a\t\u0012\u0004\u0012\u00020V0\u008d\u0001R$\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0016\u0010$\u001a\n &*\u0004\u0018\u00010%0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010'\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010)\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0012R\u0011\u0010+\u001a\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R \u0010/\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020200X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u000e\u00105\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u00106\u001a\u0004\u0018\u000107\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0014\u0010:\u001a\u00020;X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R(\u0010>\u001a\u0004\u0018\u00010\u00102\b\u0010\b\u001a\u0004\u0018\u00010\u0010@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010\u0012\"\u0004\b@\u0010AR\u001a\u0010B\u001a\b\u0012\u0004\u0012\u00020\u001b0CX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010ER(\u0010G\u001a\u0004\u0018\u00010F2\b\u0010\b\u001a\u0004\u0018\u00010F@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010KR$\u0010L\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010\f\"\u0004\bN\u0010\u000eR\u0011\u0010O\u001a\u00020P\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010R\u00a8\u0006\u008e\u0001"}, d2={"Ldev/arbjerg/lavalink/client/LavalinkNode;", "Lreactor/core/Disposable;", "Ljava/io/Closeable;", "nodeOptions", "Ldev/arbjerg/lavalink/client/NodeOptions;", "lavalink", "Ldev/arbjerg/lavalink/client/LavalinkClient;", "(Ldev/arbjerg/lavalink/client/NodeOptions;Ldev/arbjerg/lavalink/client/LavalinkClient;)V", "<set-?>", "", "available", "getAvailable", "()Z", "setAvailable$lavalink_client", "(Z)V", "baseUri", "", "getBaseUri", "()Ljava/lang/String;", "cachedSession", "Ldev/arbjerg/lavalink/protocol/v4/Session;", "getCachedSession$lavalink_client", "()Ldev/arbjerg/lavalink/protocol/v4/Session;", "setCachedSession$lavalink_client", "(Ldev/arbjerg/lavalink/protocol/v4/Session;)V", "flux", "Lreactor/core/publisher/Flux;", "Ldev/arbjerg/lavalink/client/event/ClientEvent;", "getFlux", "()Lreactor/core/publisher/Flux;", "httpClient", "Lokhttp3/OkHttpClient;", "getHttpClient$lavalink_client", "()Lokhttp3/OkHttpClient;", "getLavalink", "()Ldev/arbjerg/lavalink/client/LavalinkClient;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "name", "getName", "password", "getPassword", "penalties", "Ldev/arbjerg/lavalink/internal/loadbalancing/Penalties;", "getPenalties", "()Ldev/arbjerg/lavalink/internal/loadbalancing/Penalties;", "playerCache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ldev/arbjerg/lavalink/client/player/LavalinkPlayer;", "getPlayerCache$lavalink_client", "()Ljava/util/concurrent/ConcurrentHashMap;", "reference", "regionFilter", "Ldev/arbjerg/lavalink/client/loadbalancing/IRegionFilter;", "getRegionFilter", "()Ldev/arbjerg/lavalink/client/loadbalancing/IRegionFilter;", "rest", "Ldev/arbjerg/lavalink/internal/LavalinkRestClient;", "getRest$lavalink_client", "()Ldev/arbjerg/lavalink/internal/LavalinkRestClient;", "sessionId", "getSessionId", "setSessionId$lavalink_client", "(Ljava/lang/String;)V", "sink", "Lreactor/core/publisher/Sinks$Many;", "getSink$lavalink_client", "()Lreactor/core/publisher/Sinks$Many;", "Ldev/arbjerg/lavalink/protocol/v4/Stats;", "stats", "getStats", "()Ldev/arbjerg/lavalink/protocol/v4/Stats;", "setStats$lavalink_client", "(Ldev/arbjerg/lavalink/protocol/v4/Stats;)V", "transferring", "getTransferring", "setTransferring$lavalink_client", "ws", "Ldev/arbjerg/lavalink/internal/LavalinkSocket;", "getWs", "()Ldev/arbjerg/lavalink/internal/LavalinkSocket;", "close", "", "createOrUpdatePlayer", "Ldev/arbjerg/lavalink/client/player/PlayerUpdateBuilder;", "guildId", "customJsonRequest", "Lreactor/core/publisher/Mono;", "T", "decodeTo", "Ljava/lang/Class;", "builderFn", "Ljava/util/function/UnaryOperator;", "Ldev/arbjerg/lavalink/client/http/HttpBuilder;", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "customRequest", "Lokhttp3/Response;", "decodeTrack", "Ldev/arbjerg/lavalink/client/player/Track;", "encoded", "decodeTracks", "", "destroyPlayerAndLink", "disableResuming", "dispose", "enableResuming", "timeout", "Ljava/time/Duration;", "equals", "other", "", "getAndRemoveCachedPlayer", "getAndRemoveCachedPlayer$lavalink_client", "getCachedPlayer", "getCachedPlayers", "", "getNodeInfo", "Ldev/arbjerg/lavalink/protocol/v4/Info;", "getPlayer", "getPlayers", "hashCode", "", "loadItem", "Ldev/arbjerg/lavalink/client/player/LavalinkLoadResult;", "identifier", "on", "type", "removeCachedPlayer", "removeCachedPlayer$lavalink_client", "synchronizeAfterResume", "synchronizeAfterResume$lavalink_client", "toString", "transferComplete", "transferOrphansToSelf", "transferOrphansToSelf$lavalink_client", "transferPlayersToOtherNodes", "updatePlayer", "updateConsumer", "Ljava/util/function/Consumer;", "lavalink-client"})
public final class LavalinkNode
implements Disposable,
Closeable {
    @NotNull
    private final NodeOptions nodeOptions;
    @NotNull
    private final LavalinkClient lavalink;
    private final Logger logger;
    @NotNull
    private final String baseUri;
    @NotNull
    private final String name;
    @Nullable
    private final IRegionFilter regionFilter;
    @NotNull
    private final String password;
    @Nullable
    private Session cachedSession;
    @Nullable
    private String sessionId;
    @NotNull
    private final OkHttpClient httpClient;
    @NotNull
    private final Sinks.Many<ClientEvent> sink;
    @NotNull
    private final Flux<ClientEvent> flux;
    @NotNull
    private final Disposable reference;
    @NotNull
    private final LavalinkRestClient rest;
    @NotNull
    private final LavalinkSocket ws;
    @NotNull
    private final Penalties penalties;
    @Nullable
    private Stats stats;
    private boolean available;
    private boolean transferring;
    @NotNull
    private final ConcurrentHashMap<Long, LavalinkPlayer> playerCache;

    public LavalinkNode(@NotNull NodeOptions nodeOptions, @NotNull LavalinkClient lavalink) {
        Intrinsics.checkNotNullParameter((Object)nodeOptions, (String)"nodeOptions");
        Intrinsics.checkNotNullParameter((Object)lavalink, (String)"lavalink");
        this.nodeOptions = nodeOptions;
        this.lavalink = lavalink;
        this.logger = LoggerFactory.getLogger(LavalinkNode.class);
        this.baseUri = this.nodeOptions.getServerUri().getScheme() + "://" + this.nodeOptions.getServerUri().getHost() + ":" + this.nodeOptions.getServerUri().getPort();
        this.name = this.nodeOptions.getName();
        this.regionFilter = this.nodeOptions.getRegionFilter();
        this.password = this.nodeOptions.getPassword();
        this.sessionId = this.nodeOptions.getSessionId();
        this.httpClient = new OkHttpClient.Builder().callTimeout(this.nodeOptions.getHttpTimeout(), TimeUnit.MILLISECONDS).build();
        Sinks.Many many = Sinks.many().multicast().onBackpressureBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)many, (String)"onBackpressureBuffer(...)");
        this.sink = many;
        Flux flux = this.sink.asFlux();
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"asFlux(...)");
        this.flux = flux;
        Disposable disposable = this.flux.subscribe();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        this.reference = disposable;
        this.rest = new LavalinkRestClient(this);
        this.ws = new LavalinkSocket(this);
        this.penalties = new Penalties(this);
        this.playerCache = new ConcurrentHashMap();
    }

    @NotNull
    public final LavalinkClient getLavalink() {
        return this.lavalink;
    }

    @NotNull
    public final String getBaseUri() {
        return this.baseUri;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final IRegionFilter getRegionFilter() {
        return this.regionFilter;
    }

    @NotNull
    public final String getPassword() {
        return this.password;
    }

    @Nullable
    public final Session getCachedSession$lavalink_client() {
        return this.cachedSession;
    }

    public final void setCachedSession$lavalink_client(@Nullable Session session) {
        this.cachedSession = session;
    }

    @Nullable
    public final String getSessionId() {
        return this.sessionId;
    }

    public final void setSessionId$lavalink_client(@Nullable String string) {
        this.sessionId = string;
    }

    @NotNull
    public final OkHttpClient getHttpClient$lavalink_client() {
        return this.httpClient;
    }

    @NotNull
    public final Sinks.Many<ClientEvent> getSink$lavalink_client() {
        return this.sink;
    }

    @NotNull
    public final Flux<ClientEvent> getFlux() {
        return this.flux;
    }

    @NotNull
    public final LavalinkRestClient getRest$lavalink_client() {
        return this.rest;
    }

    @NotNull
    public final LavalinkSocket getWs() {
        return this.ws;
    }

    @NotNull
    public final Penalties getPenalties() {
        return this.penalties;
    }

    @Nullable
    public final Stats getStats() {
        return this.stats;
    }

    public final void setStats$lavalink_client(@Nullable Stats stats) {
        this.stats = stats;
    }

    public final boolean getAvailable() {
        return this.available;
    }

    public final void setAvailable$lavalink_client(boolean bl) {
        this.available = bl;
    }

    public final boolean getTransferring() {
        return this.transferring;
    }

    public final void setTransferring$lavalink_client(boolean bl) {
        this.transferring = bl;
    }

    @NotNull
    public final ConcurrentHashMap<Long, LavalinkPlayer> getPlayerCache$lavalink_client() {
        return this.playerCache;
    }

    public void dispose() {
        this.close();
    }

    @Override
    public void close() {
        this.available = false;
        this.ws.close();
        this.httpClient.dispatcher().executorService().shutdown();
        this.httpClient.connectionPool().evictAll();
        Cache cache = this.httpClient.cache();
        if (cache != null) {
            cache.close();
        }
        this.reference.dispose();
    }

    @NotNull
    public final <T extends ClientEvent> Flux<T> on(@NotNull Class<T> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Flux flux = this.flux.ofType(type);
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"ofType(...)");
        return flux;
    }

    public final /* synthetic */ <T extends ClientEvent> Flux<T> on() {
        boolean $i$f$on = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.on(ClientEvent.class);
    }

    @NotNull
    public final Mono<List<LavalinkPlayer>> getPlayers() {
        if (!this.available) {
            Mono mono = Mono.error((Throwable)new IllegalStateException("Node is not available"));
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"error(...)");
            return mono;
        }
        Mono mono = this.rest.getPlayers().map(arg_0 -> LavalinkNode.getPlayers$lambda$0((Function1)new Function1<Players, List<? extends LavalinkPlayer>>(this){
            final /* synthetic */ LavalinkNode this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final List<LavalinkPlayer> invoke-k96aCsM(List<? extends Player> it) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                List<? extends Player> list = it;
                Intrinsics.checkNotNull((Object)(list != null ? Players.box-impl(list) : null));
                Iterable iterable = it;
                LavalinkNode lavalinkNode = this.this$0;
                boolean $i$f$map = false;
                void var5_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void pl;
                    Player player = (Player)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(HelpersKt.toLavalinkPlayer((Player)pl, lavalinkNode));
                }
                return (List)destination$iv$iv;
            }
        }, arg_0)).doOnSuccess(arg_0 -> LavalinkNode.getPlayers$lambda$1((Function1)new Function1<List<? extends LavalinkPlayer>, Unit>(this){
            final /* synthetic */ LavalinkNode this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(List<LavalinkPlayer> it) {
                void $this$forEach$iv;
                Intrinsics.checkNotNull(it);
                Iterable iterable = it;
                LavalinkNode lavalinkNode = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    LavalinkPlayer player = (LavalinkPlayer)element$iv;
                    boolean bl = false;
                    ((Map)lavalinkNode.getPlayerCache$lavalink_client()).put(player.getGuildId(), player);
                }
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doOnSuccess(...)");
        return mono;
    }

    @NotNull
    public final Mono<LavalinkPlayer> getPlayer(long guildId) {
        if (!this.available) {
            Mono mono = Mono.error((Throwable)new IllegalStateException("Node is not available"));
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"error(...)");
            return mono;
        }
        if (this.playerCache.containsKey(guildId)) {
            return MonoExtensionsKt.toMono((Object)this.playerCache.get(guildId));
        }
        Mono mono = this.rest.getPlayer(guildId).map(arg_0 -> LavalinkNode.getPlayer$lambda$2((Function1)new Function1<Player, LavalinkPlayer>(this){
            final /* synthetic */ LavalinkNode this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final LavalinkPlayer invoke(Player it) {
                Intrinsics.checkNotNull((Object)it);
                return HelpersKt.toLavalinkPlayer(it, this.this$0);
            }
        }, arg_0)).onErrorResume(arg_0 -> LavalinkNode.getPlayer$lambda$3((Function1)new Function1<Throwable, Mono<? extends LavalinkPlayer>>(this, guildId){
            final /* synthetic */ LavalinkNode this$0;
            final /* synthetic */ long $guildId;
            {
                this.this$0 = $receiver;
                this.$guildId = $guildId;
                super(1);
            }

            public final Mono<? extends LavalinkPlayer> invoke(Throwable it) {
                Mono mono;
                if (it instanceof RestException && ((RestException)it).getCode() == 404) {
                    mono = this.this$0.createOrUpdatePlayer(this.$guildId);
                } else {
                    Intrinsics.checkNotNull((Object)it);
                    mono = MonoExtensionsKt.toMono((Throwable)it);
                }
                return mono;
            }
        }, arg_0)).doOnSuccess(arg_0 -> LavalinkNode.getPlayer$lambda$4((Function1)new Function1<LavalinkPlayer, Unit>(this){
            final /* synthetic */ LavalinkNode this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(LavalinkPlayer it) {
                Map map = this.this$0.getPlayerCache$lavalink_client();
                Long l = it.getGuildId();
                Intrinsics.checkNotNull((Object)it);
                map.put(l, it);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doOnSuccess(...)");
        return mono;
    }

    @NotNull
    public final Mono<LavalinkPlayer> updatePlayer(long guildId, @NotNull Consumer<PlayerUpdateBuilder> updateConsumer) {
        Intrinsics.checkNotNullParameter(updateConsumer, (String)"updateConsumer");
        PlayerUpdateBuilder update = this.createOrUpdatePlayer(guildId);
        updateConsumer.accept(update);
        return update;
    }

    @NotNull
    public final PlayerUpdateBuilder createOrUpdatePlayer(long guildId) {
        return new PlayerUpdateBuilder(this, guildId);
    }

    @NotNull
    public final Mono<Unit> destroyPlayerAndLink(long guildId) {
        if (!this.available) {
            Mono mono = Mono.error((Throwable)new IllegalStateException("Node is not available"));
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"error(...)");
            return mono;
        }
        Mono mono = this.rest.destroyPlayer(guildId).doOnSuccess(arg_0 -> LavalinkNode.destroyPlayerAndLink$lambda$5((Function1)new Function1<Unit, Unit>(this, guildId){
            final /* synthetic */ LavalinkNode this$0;
            final /* synthetic */ long $guildId;
            {
                this.this$0 = $receiver;
                this.$guildId = $guildId;
                super(1);
            }

            public final void invoke(Unit it) {
                this.this$0.removeCachedPlayer$lavalink_client(this.$guildId);
                if (!this.this$0.getTransferring()) {
                    this.this$0.getLavalink().removeDestroyedLink$lavalink_client(this.$guildId);
                }
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doOnSuccess(...)");
        return mono;
    }

    public final void removeCachedPlayer$lavalink_client(long guildId) {
        this.playerCache.remove(guildId);
    }

    @NotNull
    public final Mono<LavalinkLoadResult> loadItem(@NotNull String identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        if (!this.available) {
            Mono mono = Mono.error((Throwable)new IllegalStateException("Node is not available"));
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"error(...)");
            return mono;
        }
        Mono mono = this.rest.loadItem(identifier).map(arg_0 -> LavalinkNode.loadItem$lambda$6(loadItem.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"map(...)");
        return mono;
    }

    @NotNull
    public final Mono<Track> decodeTrack(@NotNull String encoded) {
        Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
        if (!this.available) {
            Mono mono = Mono.error((Throwable)new IllegalStateException("Node is not available"));
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"error(...)");
            return mono;
        }
        Mono mono = this.rest.decodeTrack(encoded).map(arg_0 -> LavalinkNode.decodeTrack$lambda$7(decodeTrack.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"map(...)");
        return mono;
    }

    @NotNull
    public final Mono<List<Track>> decodeTracks(@NotNull List<String> encoded) {
        Intrinsics.checkNotNullParameter(encoded, (String)"encoded");
        if (!this.available) {
            Mono mono = Mono.error((Throwable)new IllegalStateException("Node is not available"));
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"error(...)");
            return mono;
        }
        Mono mono = this.rest.decodeTracks(encoded).map(arg_0 -> LavalinkNode.decodeTracks$lambda$8(decodeTracks.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"map(...)");
        return mono;
    }

    @NotNull
    public final Mono<Info> getNodeInfo() {
        if (!this.available) {
            Mono mono = Mono.error((Throwable)new IllegalStateException("Node is not available"));
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"error(...)");
            return mono;
        }
        return this.rest.getNodeInfo();
    }

    @NotNull
    public final Mono<Session> enableResuming(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Mono mono = this.rest.patchSession(new Session(true, timeout.getSeconds())).doOnSuccess(arg_0 -> LavalinkNode.enableResuming$lambda$9((Function1)new Function1<Session, Unit>(this){
            final /* synthetic */ LavalinkNode this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Session it) {
                this.this$0.setCachedSession$lavalink_client(it);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doOnSuccess(...)");
        return mono;
    }

    @NotNull
    public final Mono<Session> disableResuming() {
        Mono mono = this.rest.patchSession(new Session(false, 0L)).doOnSuccess(arg_0 -> LavalinkNode.disableResuming$lambda$10((Function1)new Function1<Session, Unit>(this){
            final /* synthetic */ LavalinkNode this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Session it) {
                this.this$0.setCachedSession$lavalink_client(it);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doOnSuccess(...)");
        return mono;
    }

    @NotNull
    public final Mono<Response> customRequest(@NotNull UnaryOperator<HttpBuilder> builderFn) {
        Intrinsics.checkNotNullParameter(builderFn, (String)"builderFn");
        if (!this.available) {
            Mono mono = Mono.error((Throwable)new IllegalStateException("Node is not available"));
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"error(...)");
            return mono;
        }
        Call call2 = this.rest.newRequest$lavalink_client((Function1<? super HttpBuilder, HttpBuilder>)((Function1)new Function1<HttpBuilder, HttpBuilder>(builderFn){
            final /* synthetic */ UnaryOperator<HttpBuilder> $builderFn;
            {
                this.$builderFn = $builderFn;
                super(1);
            }

            @NotNull
            public final HttpBuilder invoke(@NotNull HttpBuilder $this$newRequest) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$newRequest), (String)"$this$newRequest");
                R r = this.$builderFn.apply($this$newRequest);
                Intrinsics.checkNotNullExpressionValue(r, (String)"apply(...)");
                return (HttpBuilder)((Object)r);
            }
        }));
        Mono mono = Mono.create(arg_0 -> LavalinkNode.customRequest$lambda$12(call2, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"create(...)");
        return mono;
    }

    public final /* synthetic */ <T> Mono<T> customJsonRequest(UnaryOperator<HttpBuilder> builderFn) {
        Intrinsics.checkNotNullParameter(builderFn, (String)"builderFn");
        boolean $i$f$customJsonRequest = false;
        SerializersModule serializersModule = Mapper.getJson().getSerializersModule();
        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        return this.customJsonRequest((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, null), builderFn);
    }

    @NotNull
    public final <T> Mono<T> customJsonRequest(@NotNull DeserializationStrategy<? extends T> deserializer, @NotNull UnaryOperator<HttpBuilder> builderFn) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        Intrinsics.checkNotNullParameter(builderFn, (String)"builderFn");
        Mono mono = this.customRequest(builderFn).flatMap(arg_0 -> LavalinkNode.customJsonRequest$lambda$13((Function1)new Function1<Response, Mono<? extends T>>(deserializer){
            final /* synthetic */ DeserializationStrategy<T> $deserializer;
            {
                this.$deserializer = $deserializer;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Mono<? extends T> invoke(Response response) {
                Closeable closeable = (Closeable)response;
                DeserializationStrategy<T> deserializationStrategy = this.$deserializer;
                Throwable throwable = null;
                try {
                    Response it = (Response)closeable;
                    boolean bl = false;
                    if (!response.isSuccessful()) {
                        ResponseBody responseBody = response.body();
                        Intrinsics.checkNotNull((Object)responseBody);
                        String body = responseBody.string();
                        if (((CharSequence)body).length() == 0) {
                            Mono mono = Mono.error((Throwable)new IllegalStateException("Request failed with code " + response.code()));
                            return mono;
                        }
                        Json this_$iv = Mapper.getJson();
                        boolean $i$f$decodeFromString = false;
                        this_$iv.getSerializersModule();
                        Error error = (Error)this_$iv.decodeFromString((DeserializationStrategy)Error.Companion.serializer(), body);
                        boolean bl2 = false;
                        Mono mono = Mono.error((Throwable)new IllegalStateException("Request failed with code " + response.code() + " and message " + error.getMessage()));
                        return mono;
                    }
                    if (response.code() == 204) {
                        Mono mono = Mono.empty();
                        return mono;
                    }
                    Json json = Mapper.getJson();
                    ResponseBody responseBody = response.body();
                    Intrinsics.checkNotNull((Object)responseBody);
                    Object object = JvmStreamsKt.decodeFromStream((Json)json, deserializationStrategy, (InputStream)responseBody.byteStream());
                    Intrinsics.checkNotNull((Object)object);
                    Mono mono = MonoExtensionsKt.toMono((Object)object);
                    return mono;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"flatMap(...)");
        return mono;
    }

    @NotNull
    public final <T> Mono<T> customJsonRequest(@NotNull Class<T> decodeTo, @NotNull UnaryOperator<HttpBuilder> builderFn) {
        Intrinsics.checkNotNullParameter(decodeTo, (String)"decodeTo");
        Intrinsics.checkNotNullParameter(builderFn, (String)"builderFn");
        Mono mono = this.customRequest(builderFn).flatMap(arg_0 -> LavalinkNode.customJsonRequest$lambda$14((Function1)new Function1<Response, Mono<? extends T>>(decodeTo){
            final /* synthetic */ Class<T> $decodeTo;
            {
                this.$decodeTo = $decodeTo;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Mono<? extends T> invoke(Response response) {
                Closeable closeable = (Closeable)response;
                Class<T> clazz = this.$decodeTo;
                Throwable throwable = null;
                try {
                    Response it = (Response)closeable;
                    boolean bl = false;
                    if (!response.isSuccessful()) {
                        ResponseBody responseBody = response.body();
                        Intrinsics.checkNotNull((Object)responseBody);
                        String body = responseBody.string();
                        if (((CharSequence)body).length() == 0) {
                            Mono mono = Mono.error((Throwable)new IllegalStateException("Request failed with code " + response.code()));
                            return mono;
                        }
                        Json this_$iv = Mapper.getJson();
                        boolean $i$f$decodeFromString = false;
                        this_$iv.getSerializersModule();
                        Error error = (Error)this_$iv.decodeFromString((DeserializationStrategy)Error.Companion.serializer(), body);
                        boolean bl2 = false;
                        Mono mono = Mono.error((Throwable)new IllegalStateException("Request failed with code " + response.code() + " and message " + error.getMessage()));
                        return mono;
                    }
                    if (response.code() == 204) {
                        Mono mono = Mono.empty();
                        return mono;
                    }
                    ResponseBody responseBody = response.body();
                    Intrinsics.checkNotNull((Object)responseBody);
                    T t = JsonParserKt.fromRawJson(responseBody.byteStream(), clazz);
                    Intrinsics.checkNotNull(t);
                    Mono mono = MonoExtensionsKt.toMono(t);
                    return mono;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"flatMap(...)");
        return mono;
    }

    @Nullable
    public final LavalinkPlayer getCachedPlayer(long guildId) {
        return this.playerCache.get(guildId);
    }

    @Nullable
    public final LavalinkPlayer getAndRemoveCachedPlayer$lavalink_client(long guildId) {
        return this.playerCache.remove(guildId);
    }

    @NotNull
    public final Map<Long, LavalinkPlayer> getCachedPlayers() {
        Map<Long, LavalinkPlayer> map = Collections.unmodifiableMap((Map)this.playerCache);
        Intrinsics.checkNotNullExpressionValue(map, (String)"unmodifiableMap(...)");
        return map;
    }

    public final void transferOrphansToSelf$lavalink_client() {
        this.lavalink.transferOrphansTo$lavalink_client(this);
    }

    public final void synchronizeAfterResume$lavalink_client() {
        this.getPlayers().retryWhen((Retry)Retry.fixedDelay((long)3L, (Duration)Duration.ofSeconds(1L))).map(arg_0 -> LavalinkNode.synchronizeAfterResume$lambda$15((Function1)new Function1<List<? extends LavalinkPlayer>, ResumeSynchronizationEvent>(this){
            final /* synthetic */ LavalinkNode this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final ResumeSynchronizationEvent invoke(List<LavalinkPlayer> players) {
                void $this$forEach$iv;
                void $this$forEach$iv2;
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNull(players);
                Iterable $this$map$iv = players;
                boolean $i$f$map22 = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    LavalinkPlayer lavalinkPlayer = (LavalinkPlayer)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getGuildId());
                }
                List remoteGuildIds = (List)destination$iv$iv;
                $this$map$iv = players;
                Object $i$f$map22 = this.this$0;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv2) {
                    LavalinkPlayer player = (LavalinkPlayer)element$iv;
                    boolean bl = false;
                    ((Map)((LavalinkNode)$i$f$map22).getPlayerCache$lavalink_client()).put(player.getGuildId(), player);
                    Link link = ((LavalinkNode)$i$f$map22).getLavalink().getOrCreateLink$lavalink_client(player.getGuildId(), (LavalinkNode)$i$f$map22);
                    if (!Intrinsics.areEqual((Object)link.getNode(), (Object)$i$f$map22)) continue;
                    link.setState$lavalink_client(player.getState().getConnected() ? LinkState.CONNECTED : LinkState.DISCONNECTED);
                }
                Enumeration<Long> enumeration = this.this$0.getPlayerCache$lavalink_client().keys();
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"keys(...)");
                ArrayList<Long> arrayList = Collections.list(enumeration);
                Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
                List missingIds = CollectionsKt.minus((Iterable)arrayList, (Iterable)CollectionsKt.toSet((Iterable)remoteGuildIds));
                $i$f$map22 = missingIds;
                LavalinkNode lavalinkNode = this.this$0;
                boolean $i$f$forEach2 = false;
                for (T element$iv : $this$forEach$iv) {
                    Link link;
                    Long guildId = (Long)element$iv;
                    boolean bl = false;
                    lavalinkNode.getPlayerCache$lavalink_client().remove(guildId);
                    LavalinkClient lavalinkClient = lavalinkNode.getLavalink();
                    Intrinsics.checkNotNull((Object)guildId);
                    if (lavalinkClient.getLinkIfCached(guildId) == null || !Intrinsics.areEqual((Object)link.getNode(), (Object)lavalinkNode)) continue;
                    link.setState$lavalink_client(LinkState.DISCONNECTED);
                }
                return new ResumeSynchronizationEvent(this.this$0, null);
            }
        }, arg_0)).doOnError(arg_0 -> LavalinkNode.synchronizeAfterResume$lambda$16((Function1)new Function1<Throwable, Unit>(this){
            final /* synthetic */ LavalinkNode this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Throwable it) {
                LavalinkNode.access$getLogger$p(this.this$0).error("Failure while attempting synchronization with " + this.this$0, it);
                this.this$0.getSink$lavalink_client().tryEmitNext((Object)new ResumeSynchronizationEvent(this.this$0, it));
            }
        }, arg_0)).subscribe(arg_0 -> LavalinkNode.synchronizeAfterResume$lambda$17((Function1)new Function1<ResumeSynchronizationEvent, Unit>(this){
            final /* synthetic */ LavalinkNode this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(ResumeSynchronizationEvent it) {
                this.this$0.getSink$lavalink_client().tryEmitNext((Object)it);
            }
        }, arg_0));
    }

    public final void transferPlayersToOtherNodes() {
        this.transferring = true;
        this.lavalink.transferNodes$lavalink_client(this);
    }

    public final void transferComplete() {
        this.transferring = false;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type dev.arbjerg.lavalink.client.LavalinkNode");
        LavalinkNode cfr_ignored_0 = (LavalinkNode)other;
        if (!Intrinsics.areEqual((Object)this.nodeOptions, (Object)((LavalinkNode)other).nodeOptions)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sessionId, (Object)((LavalinkNode)other).sessionId)) {
            return false;
        }
        return this.available == ((LavalinkNode)other).available;
    }

    public int hashCode() {
        int result = this.nodeOptions.hashCode();
        String string = this.sessionId;
        result = 31 * result + (string != null ? string.hashCode() : 0);
        result = 31 * result + Boolean.hashCode(this.available);
        return result;
    }

    @NotNull
    public String toString() {
        return "LavalinkNode(name=" + this.name + ", address=" + this.baseUri + ", sessionId=" + this.sessionId + ")";
    }

    private static final List getPlayers$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    private static final void getPlayers$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final LavalinkPlayer getPlayer$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (LavalinkPlayer)$tmp0.invoke(p0);
    }

    private static final Mono getPlayer$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final void getPlayer$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void destroyPlayerAndLink$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final LavalinkLoadResult loadItem$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (LavalinkLoadResult)$tmp0.invoke(p0);
    }

    private static final Track decodeTrack$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Track)$tmp0.invoke(p0);
    }

    private static final List decodeTracks$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    private static final void enableResuming$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void disableResuming$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void customRequest$lambda$12$lambda$11(Call $call) {
        Intrinsics.checkNotNullParameter((Object)$call, (String)"$call");
        $call.cancel();
    }

    private static final void customRequest$lambda$12(Call $call, MonoSink sink) {
        Intrinsics.checkNotNullParameter((Object)$call, (String)"$call");
        sink.onCancel(() -> LavalinkNode.customRequest$lambda$12$lambda$11($call));
        $call.enqueue(new Callback((MonoSink<Response>)sink){
            final /* synthetic */ MonoSink<Response> $sink;
            {
                this.$sink = $sink;
            }

            public void onFailure(@NotNull Call call2, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$sink.error((Throwable)e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(@NotNull Call call2, @NotNull Response response) {
                Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                Closeable closeable = (Closeable)response;
                MonoSink<Response> monoSink = this.$sink;
                Throwable throwable = null;
                try {
                    Response res = (Response)closeable;
                    boolean bl = false;
                    monoSink.success((Object)res);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        });
    }

    private static final Mono customJsonRequest$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Mono customJsonRequest$lambda$14(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final ResumeSynchronizationEvent synchronizeAfterResume$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ResumeSynchronizationEvent)$tmp0.invoke(p0);
    }

    private static final void synchronizeAfterResume$lambda$16(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void synchronizeAfterResume$lambda$17(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Logger access$getLogger$p(LavalinkNode $this) {
        return $this.logger;
    }
}

