/*
 * Decompiled with CFR 0.152.
 */
package dev.arbjerg.lavalink.client;

import dev.arbjerg.lavalink.client.LavalinkNode;
import dev.arbjerg.lavalink.client.LinkState;
import dev.arbjerg.lavalink.client.player.LavalinkLoadResult;
import dev.arbjerg.lavalink.client.player.LavalinkPlayer;
import dev.arbjerg.lavalink.client.player.PlayerUpdateBuilder;
import dev.arbjerg.lavalink.protocol.v4.VoiceState;
import java.time.Duration;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0019\u001a\u00020\u001aJ\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\u001cJ\b\u0010\"\u001a\u00020#H\u0016J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u001c2\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*J\u001f\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\u00052\b\b\u0002\u0010-\u001a\u00020.H\u0000\u00a2\u0006\u0002\b/J\u001a\u00100\u001a\b\u0012\u0004\u0012\u00020\b0\u001c2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u001a02R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R$\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0013@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u00063"}, d2={"Ldev/arbjerg/lavalink/client/Link;", "", "guildId", "", "node", "Ldev/arbjerg/lavalink/client/LavalinkNode;", "(JLdev/arbjerg/lavalink/client/LavalinkNode;)V", "cachedPlayer", "Ldev/arbjerg/lavalink/client/player/LavalinkPlayer;", "getCachedPlayer", "()Ldev/arbjerg/lavalink/client/player/LavalinkPlayer;", "getGuildId", "()J", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "<set-?>", "getNode", "()Ldev/arbjerg/lavalink/client/LavalinkNode;", "Ldev/arbjerg/lavalink/client/LinkState;", "state", "getState", "()Ldev/arbjerg/lavalink/client/LinkState;", "setState$lavalink_client", "(Ldev/arbjerg/lavalink/client/LinkState;)V", "createOrUpdatePlayer", "Ldev/arbjerg/lavalink/client/player/PlayerUpdateBuilder;", "destroy", "Lreactor/core/publisher/Mono;", "", "equals", "", "other", "getPlayer", "hashCode", "", "loadItem", "Ldev/arbjerg/lavalink/client/player/LavalinkLoadResult;", "identifier", "", "onVoiceServerUpdate", "newVoiceState", "Ldev/arbjerg/lavalink/protocol/v4/VoiceState;", "transferNode", "newNode", "delay", "Ljava/time/Duration;", "transferNode$lavalink_client", "updatePlayer", "updateConsumer", "Ljava/util/function/Consumer;", "lavalink-client"})
public final class Link {
    private final long guildId;
    private Logger logger;
    @NotNull
    private LavalinkNode node;
    @NotNull
    private LinkState state;

    public Link(long guildId, @NotNull LavalinkNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.guildId = guildId;
        this.logger = LoggerFactory.getLogger(Link.class);
        this.node = node;
        this.state = LinkState.DISCONNECTED;
    }

    public final long getGuildId() {
        return this.guildId;
    }

    @NotNull
    public final LavalinkNode getNode() {
        return this.node;
    }

    @NotNull
    public final LinkState getState() {
        return this.state;
    }

    public final void setState$lavalink_client(@NotNull LinkState linkState) {
        Intrinsics.checkNotNullParameter((Object)((Object)linkState), (String)"<set-?>");
        this.state = linkState;
    }

    @Nullable
    public final LavalinkPlayer getCachedPlayer() {
        return this.node.getCachedPlayer(this.guildId);
    }

    @NotNull
    public final Mono<LavalinkPlayer> getPlayer() {
        return this.node.getPlayer(this.guildId);
    }

    @NotNull
    public final Mono<Unit> destroy() {
        return this.node.destroyPlayerAndLink(this.guildId);
    }

    @NotNull
    public final Mono<LavalinkPlayer> updatePlayer(@NotNull Consumer<PlayerUpdateBuilder> updateConsumer) {
        Intrinsics.checkNotNullParameter(updateConsumer, (String)"updateConsumer");
        return this.node.updatePlayer(this.guildId, updateConsumer);
    }

    @NotNull
    public final PlayerUpdateBuilder createOrUpdatePlayer() {
        return this.node.createOrUpdatePlayer(this.guildId);
    }

    @NotNull
    public final Mono<LavalinkLoadResult> loadItem(@NotNull String identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        return this.node.loadItem(identifier);
    }

    public final void transferNode$lavalink_client(@NotNull LavalinkNode newNode, @NotNull Duration delay) {
        Intrinsics.checkNotNullParameter((Object)newNode, (String)"newNode");
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        LavalinkPlayer player = this.node.getAndRemoveCachedPlayer$lavalink_client(this.guildId);
        if (player != null) {
            this.state = LinkState.CONNECTING;
            newNode.createOrUpdatePlayer(this.guildId).applyBuilder$lavalink_client(player.stateToBuilder$lavalink_client()).delaySubscription(delay).doOnError(arg_0 -> Link.transferNode$lambda$0((Function1)new Function1<Throwable, Unit>(this, newNode){
                final /* synthetic */ Link this$0;
                final /* synthetic */ LavalinkNode $newNode;
                {
                    this.this$0 = $receiver;
                    this.$newNode = $newNode;
                    super(1);
                }

                public final void invoke(Throwable it) {
                    this.this$0.setState$lavalink_client(LinkState.DISCONNECTED);
                    Link.access$getLogger$p(this.this$0).error("Failed to transfer player to new node: " + this.$newNode.getName(), it);
                }
            }, arg_0)).subscribe();
        } else {
            this.state = LinkState.DISCONNECTED;
        }
        this.node = newNode;
    }

    public static /* synthetic */ void transferNode$lavalink_client$default(Link link, LavalinkNode lavalinkNode, Duration duration, int n, Object object) {
        if ((n & 2) != 0) {
            Duration duration2 = Duration.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ZERO");
            duration = duration2;
        }
        link.transferNode$lavalink_client(lavalinkNode, duration);
    }

    public final void onVoiceServerUpdate(@NotNull VoiceState newVoiceState) {
        Intrinsics.checkNotNullParameter((Object)newVoiceState, (String)"newVoiceState");
        if (this.node.getAvailable()) {
            this.state = LinkState.CONNECTING;
            this.node.createOrUpdatePlayer(this.guildId).setVoiceState(newVoiceState).subscribe(null, arg_0 -> Link.onVoiceServerUpdate$lambda$1((Function1)new Function1<Throwable, Unit>(this, newVoiceState){
                final /* synthetic */ Link this$0;
                final /* synthetic */ VoiceState $newVoiceState;
                {
                    this.this$0 = $receiver;
                    this.$newVoiceState = $newVoiceState;
                    super(1);
                }

                public final void invoke(Throwable it) {
                    this.this$0.setState$lavalink_client(LinkState.DISCONNECTED);
                    Link.access$getLogger$p(this.this$0).error("Failed to update voice state to " + this.$newVoiceState, it);
                }
            }, arg_0));
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type dev.arbjerg.lavalink.client.Link");
        Link cfr_ignored_0 = (Link)other;
        return this.guildId == ((Link)other).guildId;
    }

    public int hashCode() {
        return Long.hashCode(this.guildId);
    }

    private static final void transferNode$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void onVoiceServerUpdate$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Logger access$getLogger$p(Link $this) {
        return $this.logger;
    }
}

