/*
 * Decompiled with CFR 0.152.
 */
package dev.arbjerg.lavalink.client.loadbalancing;

import dev.arbjerg.lavalink.client.LavalinkNode;
import dev.arbjerg.lavalink.client.loadbalancing.IRegionFilter;
import dev.arbjerg.lavalink.client.loadbalancing.RegionFilterVerdict;
import dev.arbjerg.lavalink.client.loadbalancing.VoiceRegion;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fR\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ldev/arbjerg/lavalink/client/loadbalancing/RegionGroup;", "", "()V", "AFRICA", "Ldev/arbjerg/lavalink/client/loadbalancing/IRegionFilter;", "ASIA", "EUROPE", "MIDDLE_EAST", "SOUTH_AMERICA", "US", "valueOf", "region", "", "lavalink-client"})
public final class RegionGroup {
    @NotNull
    public static final RegionGroup INSTANCE = new RegionGroup();
    @JvmField
    @NotNull
    public static final IRegionFilter ASIA = new IRegionFilter(){
        @NotNull
        private final List<VoiceRegion> regions;
        {
            VoiceRegion[] voiceRegionArray = new VoiceRegion[]{VoiceRegion.SYDNEY, VoiceRegion.INDIA, VoiceRegion.JAPAN, VoiceRegion.HONGKONG, VoiceRegion.SINGAPORE, VoiceRegion.SOUTH_KOREA, VoiceRegion.ASIA, VoiceRegion.OCEANIA};
            this.regions = CollectionsKt.listOf((Object[])voiceRegionArray);
        }

        @NotNull
        public final List<VoiceRegion> getRegions() {
            return this.regions;
        }

        @NotNull
        public RegionFilterVerdict isRegionAllowed(@NotNull LavalinkNode node, @NotNull VoiceRegion region) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)((Object)region), (String)"region");
            return this.regions.contains((Object)((Object)region)) ? RegionFilterVerdict.PASS : RegionFilterVerdict.SOFT_BLOCK;
        }
    };
    @JvmField
    @NotNull
    public static final IRegionFilter EUROPE = new IRegionFilter(){
        @NotNull
        private final List<VoiceRegion> regions;
        {
            VoiceRegion[] voiceRegionArray = new VoiceRegion[]{VoiceRegion.ROTTERDAM, VoiceRegion.RUSSIA, VoiceRegion.AMSTERDAM, VoiceRegion.MADRID, VoiceRegion.MILAN, VoiceRegion.BUCHAREST, VoiceRegion.EUROPE, VoiceRegion.LONDON, VoiceRegion.FINLAND, VoiceRegion.FRANKFURT, VoiceRegion.STOCKHOLM, VoiceRegion.WARSAW, VoiceRegion.EUROPE};
            this.regions = CollectionsKt.listOf((Object[])voiceRegionArray);
        }

        @NotNull
        public final List<VoiceRegion> getRegions() {
            return this.regions;
        }

        @NotNull
        public RegionFilterVerdict isRegionAllowed(@NotNull LavalinkNode node, @NotNull VoiceRegion region) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)((Object)region), (String)"region");
            return this.regions.contains((Object)((Object)region)) ? RegionFilterVerdict.PASS : RegionFilterVerdict.SOFT_BLOCK;
        }
    };
    @JvmField
    @NotNull
    public static final IRegionFilter US = new IRegionFilter(){
        @NotNull
        private final List<VoiceRegion> regions;
        {
            VoiceRegion[] voiceRegionArray = new VoiceRegion[]{VoiceRegion.US_CENTRAL, VoiceRegion.US_EAST, VoiceRegion.US_SOUTH, VoiceRegion.US_WEST, VoiceRegion.ATLANTA, VoiceRegion.SEATTLE, VoiceRegion.SANTA_CLARA, VoiceRegion.NEWARK, VoiceRegion.MONTREAL, VoiceRegion.OREGON, VoiceRegion.ST_PETE, VoiceRegion.CENTRAL_AMERICA};
            this.regions = CollectionsKt.listOf((Object[])voiceRegionArray);
        }

        @NotNull
        public final List<VoiceRegion> getRegions() {
            return this.regions;
        }

        @NotNull
        public RegionFilterVerdict isRegionAllowed(@NotNull LavalinkNode node, @NotNull VoiceRegion region) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)((Object)region), (String)"region");
            return this.regions.contains((Object)((Object)region)) ? RegionFilterVerdict.PASS : RegionFilterVerdict.SOFT_BLOCK;
        }
    };
    @JvmField
    @NotNull
    public static final IRegionFilter SOUTH_AMERICA = new IRegionFilter(){
        @NotNull
        private final List<VoiceRegion> regions;
        {
            VoiceRegion[] voiceRegionArray = new VoiceRegion[]{VoiceRegion.BRAZIL, VoiceRegion.SANTIAGO, VoiceRegion.BUENOS_AIRES, VoiceRegion.SOUTH_AMERICA};
            this.regions = CollectionsKt.listOf((Object[])voiceRegionArray);
        }

        @NotNull
        public final List<VoiceRegion> getRegions() {
            return this.regions;
        }

        @NotNull
        public RegionFilterVerdict isRegionAllowed(@NotNull LavalinkNode node, @NotNull VoiceRegion region) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)((Object)region), (String)"region");
            return this.regions.contains((Object)((Object)region)) ? RegionFilterVerdict.PASS : RegionFilterVerdict.SOFT_BLOCK;
        }
    };
    @JvmField
    @NotNull
    public static final IRegionFilter AFRICA = new IRegionFilter(){
        @NotNull
        private final List<VoiceRegion> regions;
        {
            VoiceRegion[] voiceRegionArray = new VoiceRegion[]{VoiceRegion.SOUTH_AFRICA, VoiceRegion.AFRICA};
            this.regions = CollectionsKt.listOf((Object[])voiceRegionArray);
        }

        @NotNull
        public final List<VoiceRegion> getRegions() {
            return this.regions;
        }

        @NotNull
        public RegionFilterVerdict isRegionAllowed(@NotNull LavalinkNode node, @NotNull VoiceRegion region) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)((Object)region), (String)"region");
            return this.regions.contains((Object)((Object)region)) ? RegionFilterVerdict.PASS : RegionFilterVerdict.SOFT_BLOCK;
        }
    };
    @JvmField
    @NotNull
    public static final IRegionFilter MIDDLE_EAST = new IRegionFilter(){
        @NotNull
        private final List<VoiceRegion> regions;
        {
            VoiceRegion[] voiceRegionArray = new VoiceRegion[]{VoiceRegion.TEL_AVIV, VoiceRegion.DUBAI, VoiceRegion.MIDDLE_EAST};
            this.regions = CollectionsKt.listOf((Object[])voiceRegionArray);
        }

        @NotNull
        public final List<VoiceRegion> getRegions() {
            return this.regions;
        }

        @NotNull
        public RegionFilterVerdict isRegionAllowed(@NotNull LavalinkNode node, @NotNull VoiceRegion region) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)((Object)region), (String)"region");
            return this.regions.contains((Object)((Object)region)) ? RegionFilterVerdict.PASS : RegionFilterVerdict.SOFT_BLOCK;
        }
    };

    private RegionGroup() {
    }

    @NotNull
    public final IRegionFilter valueOf(@NotNull String region) {
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        String string = region.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return switch (string) {
            case "AFRICA" -> AFRICA;
            case "ASIA" -> ASIA;
            case "EUROPE" -> EUROPE;
            case "MIDDLE_EAST" -> MIDDLE_EAST;
            case "SOUTH_AMERICA" -> SOUTH_AMERICA;
            case "US" -> US;
            default -> throw new IllegalArgumentException("No region constant: " + region);
        };
    }
}

