/*
 * Decompiled with CFR 0.152.
 */
package dev.arbjerg.lavalink.client.player;

import com.fasterxml.jackson.databind.JsonNode;
import dev.arbjerg.lavalink.client.LavalinkNode;
import dev.arbjerg.lavalink.client.exception.VoiceStateException;
import dev.arbjerg.lavalink.client.player.IUpdatablePlayer;
import dev.arbjerg.lavalink.client.player.LavalinkPlayer;
import dev.arbjerg.lavalink.client.player.Track;
import dev.arbjerg.lavalink.internal.HelpersKt;
import dev.arbjerg.lavalink.internal.JsonParserKt;
import dev.arbjerg.lavalink.protocol.v4.Filters;
import dev.arbjerg.lavalink.protocol.v4.Omissible;
import dev.arbjerg.lavalink.protocol.v4.OmissibleKt;
import dev.arbjerg.lavalink.protocol.v4.Player;
import dev.arbjerg.lavalink.protocol.v4.PlayerUpdate;
import dev.arbjerg.lavalink.protocol.v4.PlayerUpdateTrack;
import dev.arbjerg.lavalink.protocol.v4.VoiceState;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0017\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b\u0019J\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u0000H\u0016J\u0017\u0010\u001d\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010!\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0017\u0010\"\u001a\u00020\u00002\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0012\u0010#\u001a\u00020\u00002\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u0010\u0010&\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010'\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010(\u001a\u00020\u0000H\u0016J\u0018\u0010)\u001a\u00020*2\u000e\u0010+\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0014H\u0016R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Ldev/arbjerg/lavalink/client/player/PlayerUpdateBuilder;", "Lreactor/core/publisher/Mono;", "Ldev/arbjerg/lavalink/client/player/LavalinkPlayer;", "Ldev/arbjerg/lavalink/client/player/IUpdatablePlayer;", "node", "Ldev/arbjerg/lavalink/client/LavalinkNode;", "guildId", "", "(Ldev/arbjerg/lavalink/client/LavalinkNode;J)V", "endTime", "Ldev/arbjerg/lavalink/protocol/v4/Omissible;", "filters", "Ldev/arbjerg/lavalink/protocol/v4/Filters;", "noReplace", "", "paused", "position", "state", "Ldev/arbjerg/lavalink/protocol/v4/VoiceState;", "trackUpdate", "Ldev/arbjerg/lavalink/protocol/v4/PlayerUpdateTrack;", "volume", "", "applyBuilder", "builder", "applyBuilder$lavalink_client", "build", "Ldev/arbjerg/lavalink/protocol/v4/PlayerUpdate;", "omitEndTime", "setEndTime", "(Ljava/lang/Long;)Ldev/arbjerg/lavalink/client/player/PlayerUpdateBuilder;", "setFilters", "setNoReplace", "setPaused", "setPosition", "setTrack", "track", "Ldev/arbjerg/lavalink/client/player/Track;", "setVoiceState", "setVolume", "stopTrack", "subscribe", "", "actual", "Lreactor/core/CoreSubscriber;", "updateTrack", "update", "lavalink-client"})
public final class PlayerUpdateBuilder
extends Mono<LavalinkPlayer>
implements IUpdatablePlayer {
    @NotNull
    private final LavalinkNode node;
    private final long guildId;
    @NotNull
    private Omissible<PlayerUpdateTrack> trackUpdate;
    @NotNull
    private Omissible<Long> position;
    @NotNull
    private Omissible<Long> endTime;
    @NotNull
    private Omissible<Integer> volume;
    @NotNull
    private Omissible<Boolean> paused;
    @NotNull
    private Omissible<Filters> filters;
    @NotNull
    private Omissible<VoiceState> state;
    private boolean noReplace;

    public PlayerUpdateBuilder(@NotNull LavalinkNode node, long guildId) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.node = node;
        this.guildId = guildId;
        this.trackUpdate = (Omissible)Omissible.Companion.omitted();
        this.position = (Omissible)Omissible.Companion.omitted();
        this.endTime = (Omissible)Omissible.Companion.omitted();
        this.volume = (Omissible)Omissible.Companion.omitted();
        this.paused = (Omissible)Omissible.Companion.omitted();
        this.filters = (Omissible)Omissible.Companion.omitted();
        this.state = (Omissible)Omissible.Companion.omitted();
    }

    @Override
    @NotNull
    public PlayerUpdateBuilder setTrack(@Nullable Track track) {
        Track track2;
        Track track3 = track;
        this.trackUpdate = OmissibleKt.toOmissible((Object)new PlayerUpdateTrack((Omissible)Omissible.Present.box-impl((Object)Omissible.Companion.of-QruQRtQ((Object)(track3 != null ? track3.getEncoded() : null))), null, OmissibleKt.toOmissible((track2 = track) != null && (track2 = track2.getUserData()) != null ? JsonParserKt.toKotlin((JsonNode)track2) : null), 2, null));
        Track track4 = track;
        this.position = OmissibleKt.toOmissible(track4 != null && (track4 = track4.getInfo()) != null ? Long.valueOf(track4.getPosition()) : null);
        return this;
    }

    @Override
    @NotNull
    public PlayerUpdateBuilder updateTrack(@NotNull PlayerUpdateTrack update) {
        Intrinsics.checkNotNullParameter((Object)update, (String)"update");
        this.trackUpdate = OmissibleKt.toOmissible((Object)update);
        return this;
    }

    @Override
    @NotNull
    public PlayerUpdateBuilder stopTrack() {
        this.trackUpdate = OmissibleKt.toOmissible((Object)new PlayerUpdateTrack((Omissible)Omissible.Present.box-impl((Object)Omissible.Companion.of-QruQRtQ(null)), null, null, 6, null));
        return this;
    }

    @Override
    @NotNull
    public PlayerUpdateBuilder setPosition(@Nullable Long position) {
        this.position = OmissibleKt.toOmissible((Object)position);
        return this;
    }

    @Override
    @NotNull
    public PlayerUpdateBuilder setEndTime(@Nullable Long endTime) {
        this.endTime = (Omissible)Omissible.Present.box-impl((Object)Omissible.Companion.of-QruQRtQ((Object)endTime));
        return this;
    }

    @Override
    @NotNull
    public PlayerUpdateBuilder omitEndTime() {
        this.endTime = (Omissible)Omissible.Companion.omitted();
        return this;
    }

    @Override
    @NotNull
    public PlayerUpdateBuilder setVolume(int volume) {
        if (volume < 0 || volume > 1000) {
            throw new IllegalArgumentException("Volume must not be less than 0 or greater than 1000");
        }
        this.volume = OmissibleKt.toOmissible((Object)volume);
        return this;
    }

    @Override
    @NotNull
    public PlayerUpdateBuilder setPaused(boolean paused) {
        this.paused = OmissibleKt.toOmissible((Object)paused);
        return this;
    }

    @Override
    @NotNull
    public PlayerUpdateBuilder setFilters(@NotNull Filters filters) {
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        this.filters = OmissibleKt.toOmissible((Object)filters);
        return this;
    }

    @Override
    @NotNull
    public PlayerUpdateBuilder setVoiceState(@NotNull VoiceState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (((CharSequence)state.getSessionId()).length() == 0 || ((CharSequence)state.getEndpoint()).length() == 0 || ((CharSequence)state.getToken()).length() == 0) {
            throw new VoiceStateException("Voice state is missing sessionId, endpoint, or token: " + state);
        }
        this.state = OmissibleKt.toOmissible((Object)state);
        return this;
    }

    @NotNull
    public final PlayerUpdateBuilder setNoReplace(boolean noReplace) {
        this.noReplace = noReplace;
        return this;
    }

    @NotNull
    public final PlayerUpdateBuilder applyBuilder$lavalink_client(@NotNull PlayerUpdateBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.trackUpdate = builder.trackUpdate;
        this.position = builder.position;
        this.endTime = builder.endTime;
        this.volume = builder.volume;
        this.paused = builder.paused;
        this.filters = builder.filters;
        this.state = builder.state;
        this.noReplace = builder.noReplace;
        return this;
    }

    @NotNull
    public final PlayerUpdate build() {
        return new PlayerUpdate(null, null, this.trackUpdate, this.position, this.endTime, this.volume, this.paused, this.filters, this.state, 3, null);
    }

    public void subscribe(@NotNull CoreSubscriber<? super LavalinkPlayer> actual) {
        Intrinsics.checkNotNullParameter(actual, (String)"actual");
        this.node.getRest$lavalink_client().updatePlayer(this.build(), this.guildId, this.noReplace).map(arg_0 -> PlayerUpdateBuilder.subscribe$lambda$0((Function1)new Function1<Player, LavalinkPlayer>(this){
            final /* synthetic */ PlayerUpdateBuilder this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final LavalinkPlayer invoke(Player it) {
                Intrinsics.checkNotNull((Object)it);
                return HelpersKt.toLavalinkPlayer(it, PlayerUpdateBuilder.access$getNode$p(this.this$0));
            }
        }, arg_0)).doOnSuccess(arg_0 -> PlayerUpdateBuilder.subscribe$lambda$1((Function1)new Function1<LavalinkPlayer, Unit>(this){
            final /* synthetic */ PlayerUpdateBuilder this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(LavalinkPlayer it) {
                Map map = PlayerUpdateBuilder.access$getNode$p(this.this$0).getPlayerCache$lavalink_client();
                Long l = PlayerUpdateBuilder.access$getGuildId$p(this.this$0);
                Intrinsics.checkNotNull((Object)it);
                map.put(l, it);
            }
        }, arg_0)).subscribe(actual);
    }

    private static final LavalinkPlayer subscribe$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (LavalinkPlayer)$tmp0.invoke(p0);
    }

    private static final void subscribe$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ LavalinkNode access$getNode$p(PlayerUpdateBuilder $this) {
        return $this.node;
    }

    public static final /* synthetic */ long access$getGuildId$p(PlayerUpdateBuilder $this) {
        return $this.guildId;
    }
}

