/*
 * Decompiled with CFR 0.152.
 */
package dev.arbjerg.lavalink.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.arbjerg.lavalink.protocol.v4.Mapper;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a'\u0010\u0002\u001a\u0002H\u0003\"\u0004\b\u0000\u0010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0007\u00a2\u0006\u0002\u0010\b\u001a'\u0010\t\u001a\u0002H\u0003\"\u0004\b\u0000\u0010\u00032\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0007\u00a2\u0006\u0002\u0010\f\u001a\u0010\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0005\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\u0011\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "fromJsonElement", "T", "jsonElement", "Lkotlinx/serialization/json/JsonElement;", "klass", "Ljava/lang/Class;", "(Lkotlinx/serialization/json/JsonElement;Ljava/lang/Class;)Ljava/lang/Object;", "fromRawJson", "bytes", "Ljava/io/InputStream;", "(Ljava/io/InputStream;Ljava/lang/Class;)Ljava/lang/Object;", "toJsonElement", "obj", "", "toJackson", "Lcom/fasterxml/jackson/databind/JsonNode;", "toKotlin", "Lkotlinx/serialization/json/JsonObject;", "lavalink-client"})
public final class JsonParserKt {
    @NotNull
    private static final ObjectMapper objectMapper = new ObjectMapper();

    @NotNull
    public static final JsonNode toJackson(@NotNull JsonElement $this$toJackson) {
        Intrinsics.checkNotNullParameter((Object)$this$toJackson, (String)"<this>");
        JsonNode jsonNode = objectMapper.readTree($this$toJackson.toString());
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"readTree(...)");
        return jsonNode;
    }

    @NotNull
    public static final JsonObject toKotlin(@NotNull JsonNode $this$toKotlin) {
        Intrinsics.checkNotNullParameter((Object)$this$toKotlin, (String)"<this>");
        JsonElement jsonElement = JsonParserKt.toJsonElement($this$toKotlin);
        Intrinsics.checkNotNull((Object)jsonElement, (String)"null cannot be cast to non-null type kotlinx.serialization.json.JsonObject");
        return (JsonObject)jsonElement;
    }

    @NotNull
    public static final JsonElement toJsonElement(@Nullable Object obj) {
        if (obj == null) {
            return (JsonElement)new JsonObject(MapsKt.emptyMap());
        }
        String jsonString = objectMapper.writeValueAsString(obj);
        Json json = Mapper.getJson();
        Intrinsics.checkNotNull((Object)jsonString);
        return json.parseToJsonElement(jsonString);
    }

    public static final <T> T fromRawJson(@NotNull InputStream bytes, @NotNull Class<T> klass) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        return (T)objectMapper.readValue(bytes, klass);
    }

    public static final <T> T fromJsonElement(@NotNull JsonElement jsonElement, @NotNull Class<T> klass) {
        Intrinsics.checkNotNullParameter((Object)jsonElement, (String)"jsonElement");
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        String stringValue = jsonElement.toString();
        return (T)objectMapper.readValue(stringValue, klass);
    }
}

