/*
 * Decompiled with CFR 0.152.
 */
package dev.arbjerg.lavalink.internal;

import dev.arbjerg.lavalink.client.LavalinkNode;
import dev.arbjerg.lavalink.client.Link;
import dev.arbjerg.lavalink.client.LinkState;
import dev.arbjerg.lavalink.client.event.EventsKt;
import dev.arbjerg.lavalink.client.player.LavalinkPlayer;
import dev.arbjerg.lavalink.client.player.TrackKt;
import dev.arbjerg.lavalink.internal.LoggingKt;
import dev.arbjerg.lavalink.protocol.v4.Mapper;
import dev.arbjerg.lavalink.protocol.v4.Message;
import dev.arbjerg.lavalink.protocol.v4.Session;
import dev.arbjerg.lavalink.protocol.v4.Stats;
import dev.arbjerg.lavalink.protocol.v4.VoiceState;
import java.io.Closeable;
import java.io.EOFException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Sinks;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010&\u001a\u00020'J\b\u0010(\u001a\u00020'H\u0016J\b\u0010)\u001a\u00020'H\u0002J\u0010\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020,H\u0002J \u0010-\u001a\u00020'2\u0006\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u00020\u001c2\u0006\u00100\u001a\u000201H\u0016J \u00102\u001a\u00020'2\u0006\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u00020\u001c2\u0006\u00100\u001a\u000201H\u0016J\"\u00103\u001a\u00020'2\u0006\u0010.\u001a\u00020!2\u0006\u0010+\u001a\u00020,2\b\u00104\u001a\u0004\u0018\u000105H\u0016J\u0018\u00106\u001a\u00020'2\u0006\u0010.\u001a\u00020!2\u0006\u00107\u001a\u000201H\u0016J\u0018\u00108\u001a\u00020'2\u0006\u0010.\u001a\u00020!2\u0006\u00104\u001a\u000205H\u0016J\r\u00109\u001a\u00020'H\u0000\u00a2\u0006\u0002\b:R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0015R\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010 \u001a\u0004\u0018\u00010!X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u0006;"}, d2={"Ldev/arbjerg/lavalink/internal/LavalinkSocket;", "Lokhttp3/WebSocketListener;", "Ljava/io/Closeable;", "node", "Ldev/arbjerg/lavalink/client/LavalinkNode;", "(Ldev/arbjerg/lavalink/client/LavalinkNode;)V", "hasEverConnected", "", "isAttemptingResume", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lastReconnectAttempt", "", "getLastReconnectAttempt", "()J", "setLastReconnectAttempt", "(J)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "mayReconnect", "getMayReconnect", "()Z", "setMayReconnect", "(Z)V", "<set-?>", "open", "getOpen", "reconnectInterval", "", "getReconnectInterval", "()I", "reconnectsAttempted", "socket", "Lokhttp3/WebSocket;", "getSocket$lavalink_client", "()Lokhttp3/WebSocket;", "setSocket$lavalink_client", "(Lokhttp3/WebSocket;)V", "attemptReconnect", "", "close", "connect", "handleFailureThrowable", "t", "", "onClosed", "webSocket", "code", "reason", "", "onClosing", "onFailure", "response", "Lokhttp3/Response;", "onMessage", "text", "onOpen", "onResumableConnectionDisconnected", "onResumableConnectionDisconnected$lavalink_client", "lavalink-client"})
@SourceDebugExtension(value={"SMAP\nLavalinkSocket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LavalinkSocket.kt\ndev/arbjerg/lavalink/internal/LavalinkSocket\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,273:1\n96#2:274\n1855#3,2:275\n*S KotlinDebug\n*F\n+ 1 LavalinkSocket.kt\ndev/arbjerg/lavalink/internal/LavalinkSocket\n*L\n55#1:274\n72#1:275,2\n*E\n"})
public final class LavalinkSocket
extends WebSocketListener
implements Closeable {
    @NotNull
    private final LavalinkNode node;
    private final Logger logger;
    @Nullable
    private WebSocket socket;
    private boolean mayReconnect;
    private long lastReconnectAttempt;
    private volatile int reconnectsAttempted;
    private boolean open;
    private volatile boolean hasEverConnected;
    @NotNull
    private final AtomicBoolean isAttemptingResume;

    public LavalinkSocket(@NotNull LavalinkNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.node = node;
        this.logger = LoggerFactory.getLogger(LavalinkSocket.class);
        this.mayReconnect = true;
        this.isAttemptingResume = new AtomicBoolean(this.node.getSessionId() != null);
        this.connect();
    }

    @Nullable
    public final WebSocket getSocket$lavalink_client() {
        return this.socket;
    }

    public final void setSocket$lavalink_client(@Nullable WebSocket webSocket) {
        this.socket = webSocket;
    }

    public final boolean getMayReconnect() {
        return this.mayReconnect;
    }

    public final void setMayReconnect(boolean bl) {
        this.mayReconnect = bl;
    }

    public final long getLastReconnectAttempt() {
        return this.lastReconnectAttempt;
    }

    public final void setLastReconnectAttempt(long l) {
        this.lastReconnectAttempt = l;
    }

    public final int getReconnectInterval() {
        return this.reconnectsAttempted * 2000 - 2000;
    }

    public final boolean getOpen() {
        return this.open;
    }

    public void onOpen(@NotNull WebSocket webSocket, @NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.logger.info(this.node.getName() + " has been connected!");
        this.open = true;
        this.reconnectsAttempted = 0;
        this.hasEverConnected = true;
        this.isAttemptingResume.set(false);
    }

    public void onMessage(@NotNull WebSocket webSocket, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.logger.debug("-> {}", (Object)text);
        Json this_$iv = Mapper.getJson();
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        Message event = (Message)this_$iv.decodeFromString((DeserializationStrategy)Message.Serializer.serializer(), text);
        switch (WhenMappings.$EnumSwitchMapping$0[event.getOp().ordinal()]) {
            case 1: {
                Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type dev.arbjerg.lavalink.protocol.v4.Message.ReadyEvent");
                Message.ReadyEvent readyEvent = (Message.ReadyEvent)event;
                boolean resumed = readyEvent.component2();
                String sessionId = readyEvent.component3();
                if (!resumed) {
                    this.node.getPenalties().resetMetrics$lavalink_client();
                }
                this.node.setSessionId$lavalink_client(sessionId);
                this.node.setAvailable$lavalink_client(true);
                this.node.setTransferring$lavalink_client(false);
                this.logger.info(this.node.getName() + " is ready with session id " + sessionId);
                Collection<LavalinkPlayer> collection = this.node.getPlayerCache$lavalink_client().values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                Iterable $this$forEach$iv = collection;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    LavalinkPlayer player = (LavalinkPlayer)element$iv;
                    boolean bl = false;
                    VoiceState voiceState = player.getVoiceState();
                    String token = voiceState.component1();
                    String endpoint = voiceState.component2();
                    String stateSessionId = voiceState.component3();
                    if (StringsKt.isBlank((CharSequence)token) || StringsKt.isBlank((CharSequence)endpoint) || StringsKt.isBlank((CharSequence)stateSessionId)) continue;
                    player.stateToBuilder$lavalink_client().setNoReplace(false).subscribe();
                }
                if (!resumed) {
                    this.node.setCachedSession$lavalink_client(null);
                }
                if (this.node.getCachedSession$lavalink_client() == null) {
                    this.node.getRest$lavalink_client().getSession().subscribe(arg_0 -> LavalinkSocket.onMessage$lambda$1((Function1)new Function1<Session, Unit>(this){
                        final /* synthetic */ LavalinkSocket this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(Session it) {
                            LavalinkSocket.access$getNode$p(this.this$0).setCachedSession$lavalink_client(it);
                        }
                    }, arg_0));
                }
                if (resumed) {
                    this.node.synchronizeAfterResume$lavalink_client();
                }
                this.node.transferOrphansToSelf$lavalink_client();
                break;
            }
            case 2: {
                Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type dev.arbjerg.lavalink.protocol.v4.Message.StatsEvent");
                this.node.setStats$lavalink_client((Stats)((Message.StatsEvent)event));
                break;
            }
            case 3: {
                Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type dev.arbjerg.lavalink.protocol.v4.Message.PlayerUpdateEvent");
                Message.PlayerUpdateEvent update = (Message.PlayerUpdateEvent)event;
                long idLong = Long.parseLong(update.getGuildId());
                LavalinkPlayer lavalinkPlayer = this.node.getCachedPlayer(idLong);
                if (lavalinkPlayer != null) {
                    lavalinkPlayer.setState$lavalink_client(update.getState());
                }
                Link link = this.node.getLavalink().getLinkIfCached(idLong);
                if (link == null) break;
                link.setState$lavalink_client(update.getState().getConnected() ? LinkState.CONNECTED : LinkState.DISCONNECTED);
                break;
            }
            case 4: {
                Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type dev.arbjerg.lavalink.protocol.v4.Message.EmittedEvent");
                Message.EmittedEvent cfr_ignored_0 = (Message.EmittedEvent)event;
                Message.EmittedEvent emittedEvent = (Message.EmittedEvent)event;
                if (emittedEvent instanceof Message.EmittedEvent.TrackStartEvent) {
                    LavalinkPlayer lavalinkPlayer = this.node.getCachedPlayer(Long.parseLong(((Message.EmittedEvent)event).getGuildId()));
                    if (lavalinkPlayer != null) {
                        lavalinkPlayer.setTrack$lavalink_client(TrackKt.toCustom(((Message.EmittedEvent.TrackStartEvent)event).getTrack()));
                    }
                } else if (emittedEvent instanceof Message.EmittedEvent.TrackEndEvent) {
                    LavalinkPlayer lavalinkPlayer = this.node.getCachedPlayer(Long.parseLong(((Message.EmittedEvent)event).getGuildId()));
                    if (lavalinkPlayer != null) {
                        lavalinkPlayer.setTrack$lavalink_client(null);
                    }
                } else if (emittedEvent instanceof Message.EmittedEvent.WebSocketClosedEvent && (((Message.EmittedEvent.WebSocketClosedEvent)event).getCode() == 4004 || ((Message.EmittedEvent.WebSocketClosedEvent)event).getCode() == 4006 || ((Message.EmittedEvent.WebSocketClosedEvent)event).getCode() == 4009 || ((Message.EmittedEvent.WebSocketClosedEvent)event).getCode() == 4014)) {
                    Object[] objectArray = new Object[]{this.node.getName(), ((Message.EmittedEvent.WebSocketClosedEvent)event).getCode(), ((Message.EmittedEvent)event).getGuildId()};
                    this.logger.debug("Node '{}' received close code {} for guild {}", objectArray);
                    this.node.destroyPlayerAndLink(Long.parseLong(((Message.EmittedEvent)event).getGuildId())).subscribe();
                }
                this.node.getPenalties().handleTrackEvent((Message.EmittedEvent)event);
                break;
            }
            default: {
                this.logger.error("Unknown WS message on " + this.node.getName() + ", please report the following information to the devs: '" + text + "'");
            }
        }
        try {
            this.node.getSink$lavalink_client().tryEmitNext((Object)EventsKt.toClientEvent(event, this.node));
        }
        catch (Exception e) {
            this.node.getSink$lavalink_client().emitError((Throwable)e, Sinks.EmitFailureHandler.FAIL_FAST);
        }
    }

    public void onClosed(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        if (this.mayReconnect) {
            this.logger.info(this.node.getName() + " disconnected, reconnecting in " + this.getReconnectInterval() / 1000 + " seconds");
        }
    }

    public void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, @Nullable Response response) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.handleFailureThrowable(t);
        this.node.setAvailable$lavalink_client(false);
        this.open = false;
        this.node.getLavalink().onNodeDisconnected$lavalink_client(this.node);
    }

    private final void handleFailureThrowable(Throwable t) {
        Throwable throwable = t;
        if (throwable instanceof EOFException) {
            this.logger.debug("Got disconnected from " + this.node.getName() + ", trying to reconnect", t);
        } else if (throwable instanceof SocketTimeoutException) {
            this.logger.debug("Got disconnected from " + this.node.getName() + " (timeout), trying to reconnect", t);
        } else if (throwable instanceof ConnectException) {
            Logger logger = this.logger;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
            LoggingKt.warnOrTrace(logger, "Failed to connect to WS of " + this.node.getName() + " (" + this.node.getBaseUri() + "), retrying in " + this.getReconnectInterval() / 1000 + " seconds", t);
        } else if (throwable instanceof SocketException) {
            if (!this.open) {
                this.logger.debug("Got a socket exception on " + this.node.getName() + ", but the socket is closed. Ignoring it", t);
                return;
            }
            Logger logger = this.logger;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
            LoggingKt.warnOrTrace(logger, "Socket error on " + this.node.getName() + ", reconnecting in " + this.getReconnectInterval() / 1000 + " seconds", t);
        } else {
            this.logger.error("Unknown error on " + this.node.getName(), t);
        }
        if (this.hasEverConnected && this.isAttemptingResume.getAndSet(false)) {
            try {
                this.node.getLavalink().onResumeReconnectFailed$lavalink_client(this.node);
            }
            catch (Exception e) {
                this.logger.error("Exception after giving up on resuming", (Throwable)e);
            }
        }
    }

    public void onClosing(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.node.setAvailable$lavalink_client(false);
        this.open = false;
        this.node.getLavalink().onNodeDisconnected$lavalink_client(this.node);
        if (code == 1000) {
            this.mayReconnect = false;
            Object[] objectArray = new Object[]{this.node.getName(), webSocket.request().url(), reason};
            this.logger.info("Connection to {}({}) closed normally with reason {} (closed by server = true)", objectArray);
        } else {
            Object[] objectArray = new Object[]{this.node.getName(), webSocket.request().url(), code, reason};
            this.logger.info("Connection to {}({}) closed abnormally with reason {}:{} (closed by server = true)", objectArray);
        }
    }

    public final void attemptReconnect() {
        this.lastReconnectAttempt = System.currentTimeMillis();
        int n = this.reconnectsAttempted;
        this.reconnectsAttempted = n + 1;
        this.connect();
    }

    private final void connect() {
        Request.Builder builder;
        if (this.socket != null) {
            WebSocket webSocket = this.socket;
            if (webSocket != null) {
                webSocket.close(1000, "New connection requested");
            }
            WebSocket webSocket2 = this.socket;
            if (webSocket2 != null) {
                webSocket2.cancel();
            }
        }
        Request.Builder $this$connect_u24lambda_u242 = builder = new Request.Builder().url(this.node.getBaseUri() + "/v4/websocket").addHeader("Authorization", this.node.getPassword()).addHeader("Client-Name", "Lavalink-Client/3.3.0").addHeader("User-Id", String.valueOf(this.node.getLavalink().getUserId()));
        boolean bl = false;
        if (this.node.getSessionId() != null && this.isAttemptingResume.get()) {
            String string = this.node.getSessionId();
            Intrinsics.checkNotNull((Object)string);
            $this$connect_u24lambda_u242.addHeader("Session-Id", string);
        }
        Request request = builder.build();
        this.mayReconnect = true;
        this.socket = this.node.getHttpClient$lavalink_client().newWebSocket(request, (WebSocketListener)this);
    }

    @Override
    public void close() {
        block1: {
            this.mayReconnect = false;
            this.open = false;
            this.node.setAvailable$lavalink_client(false);
            WebSocket webSocket = this.socket;
            if (webSocket != null) {
                webSocket.close(1000, "Client shutdown");
            }
            WebSocket webSocket2 = this.socket;
            if (webSocket2 == null) break block1;
            webSocket2.cancel();
        }
    }

    public final void onResumableConnectionDisconnected$lavalink_client() {
        this.isAttemptingResume.set(true);
    }

    private static final void onMessage$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ LavalinkNode access$getNode$p(LavalinkSocket $this) {
        return $this.node;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Message.Op.values().length];
            try {
                nArray[Message.Op.Ready.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Message.Op.Stats.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Message.Op.PlayerUpdate.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Message.Op.Event.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

