/*
 * Decompiled with CFR 0.152.
 */
package dev.arbjerg.lavalink.internal.loadbalancing;

import dev.arbjerg.lavalink.internal.loadbalancing.LRUCache;
import dev.arbjerg.lavalink.internal.loadbalancing.MetricType;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\fJ\r\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/arbjerg/lavalink/internal/loadbalancing/MetricService;", "", "()V", "dateFormat", "Ljava/text/SimpleDateFormat;", "timeMap", "Ldev/arbjerg/lavalink/internal/loadbalancing/LRUCache;", "", "", "Ldev/arbjerg/lavalink/internal/loadbalancing/MetricType;", "", "getCurrentMetrics", "", "resetMetrics", "", "resetMetrics$lavalink_client", "trackMetric", "metric", "lavalink-client"})
@SourceDebugExtension(value={"SMAP\nMetricService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetricService.kt\ndev/arbjerg/lavalink/internal/loadbalancing/MetricService\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,41:1\n372#2,7:42\n1855#3:49\n1856#3:52\n215#4,2:50\n*S KotlinDebug\n*F\n+ 1 MetricService.kt\ndev/arbjerg/lavalink/internal/loadbalancing/MetricService\n*L\n15#1:42,7\n26#1:49\n26#1:52\n27#1:50,2\n*E\n"})
public final class MetricService {
    @NotNull
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    @NotNull
    private final LRUCache<String, Map<MetricType, Integer>> timeMap = new LRUCache(100);

    /*
     * WARNING - void declaration
     */
    public final void trackMetric(@NotNull MetricType metric) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        String timestamp = this.dateFormat.format(new Date());
        Map map = this.timeMap;
        Intrinsics.checkNotNull((Object)timestamp);
        String key$iv = timestamp;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Map answer$iv = new LinkedHashMap();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Map metricMap = (Map)object;
        Integer n = (Integer)metricMap.get((Object)metric);
        int currMetric = n != null ? n : 0;
        metricMap.put(metric, currMetric + 1);
    }

    @NotNull
    public final Map<MetricType, Integer> getCurrentMetrics() {
        Map metricMap = new LinkedHashMap();
        Collection<Map<MetricType, Integer>> collection = this.timeMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map it = (Map)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            Map $this$forEach$iv2 = it;
            boolean $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv2;
                Map.Entry entry = element$iv2 = iterator.next();
                boolean bl2 = false;
                MetricType metric = (MetricType)((Object)entry.getKey());
                int value = ((Number)entry.getValue()).intValue();
                Integer n = (Integer)metricMap.get((Object)metric);
                int currMetric = n != null ? n : 0;
                metricMap.put(metric, currMetric + value);
            }
        }
        return metricMap;
    }

    public final void resetMetrics$lavalink_client() {
        this.timeMap.clear();
    }
}

