/*
 * Decompiled with CFR 0.152.
 */
package dev.arbjerg.lavalink.internal.loadbalancing;

import dev.arbjerg.lavalink.client.LavalinkNode;
import dev.arbjerg.lavalink.client.player.LavalinkPlayer;
import dev.arbjerg.lavalink.internal.loadbalancing.MetricService;
import dev.arbjerg.lavalink.internal.loadbalancing.MetricType;
import dev.arbjerg.lavalink.protocol.v4.FrameStats;
import dev.arbjerg.lavalink.protocol.v4.Message;
import dev.arbjerg.lavalink.protocol.v4.Stats;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nJ\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\t\u0010\u0014\u001a\u00020\nH\u00d6\u0001J\r\u0010\u0015\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0016J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Ldev/arbjerg/lavalink/internal/loadbalancing/Penalties;", "", "node", "Ldev/arbjerg/lavalink/client/LavalinkNode;", "(Ldev/arbjerg/lavalink/client/LavalinkNode;)V", "metricService", "Ldev/arbjerg/lavalink/internal/loadbalancing/MetricService;", "getNode", "()Ldev/arbjerg/lavalink/client/LavalinkNode;", "calculateTotal", "", "component1", "copy", "equals", "", "other", "handleTrackEvent", "", "event", "Ldev/arbjerg/lavalink/protocol/v4/Message$EmittedEvent;", "hashCode", "resetMetrics", "resetMetrics$lavalink_client", "toString", "", "lavalink-client"})
@SourceDebugExtension(value={"SMAP\nPenalties.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Penalties.kt\ndev/arbjerg/lavalink/internal/loadbalancing/Penalties\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,97:1\n204#2,4:98\n*S KotlinDebug\n*F\n+ 1 Penalties.kt\ndev/arbjerg/lavalink/internal/loadbalancing/Penalties\n*L\n69#1:98,4\n*E\n"})
public final class Penalties {
    @NotNull
    private final LavalinkNode node;
    @NotNull
    private final MetricService metricService;

    public Penalties(@NotNull LavalinkNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.node = node;
        this.metricService = new MetricService();
    }

    @NotNull
    public final LavalinkNode getNode() {
        return this.node;
    }

    public final void resetMetrics$lavalink_client() {
        this.metricService.resetMetrics$lavalink_client();
    }

    public final void handleTrackEvent(@NotNull Message.EmittedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Message.EmittedEvent emittedEvent = event;
        if (emittedEvent instanceof Message.EmittedEvent.TrackStartEvent) {
            this.metricService.trackMetric(MetricType.LOAD_ATTEMPT);
        } else if (emittedEvent instanceof Message.EmittedEvent.TrackEndEvent) {
            if (((Message.EmittedEvent.TrackEndEvent)event).getReason() == Message.EmittedEvent.TrackEndEvent.AudioTrackEndReason.LOAD_FAILED) {
                this.metricService.trackMetric(MetricType.LOAD_FAILED);
            }
        } else if (emittedEvent instanceof Message.EmittedEvent.TrackExceptionEvent) {
            this.metricService.trackMetric(MetricType.TRACK_EXCEPTION);
        } else if (emittedEvent instanceof Message.EmittedEvent.TrackStuckEvent) {
            this.metricService.trackMetric(MetricType.TRACK_STUCK);
        }
    }

    public final int calculateTotal() {
        int n;
        int loadsFailed;
        Stats stats = this.node.getStats();
        if (!this.node.getAvailable() || stats == null) {
            return 10000000;
        }
        Map<MetricType, Integer> metrics = this.metricService.getCurrentMetrics();
        Integer n2 = metrics.get((Object)MetricType.LOAD_ATTEMPT);
        int loadsAttempted = n2 != null ? n2 : 0;
        Integer n3 = metrics.get((Object)MetricType.LOAD_FAILED);
        int n4 = loadsFailed = n3 != null ? n3 : 0;
        if (loadsAttempted > 0 && loadsAttempted == loadsFailed) {
            return 10000000;
        }
        Map $this$count$iv = this.node.getPlayerCache$lavalink_client();
        boolean $i$f$count = false;
        if ($this$count$iv.isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            Iterator iterator = $this$count$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator.next();
                boolean bl = false;
                if (!(((LavalinkPlayer)it.getValue()).getTrack() != null && !((LavalinkPlayer)it.getValue()).getPaused())) continue;
                ++count$iv;
            }
            n = count$iv;
        }
        int cachedPlayingPlayers = n;
        int playerPenalty = Math.max(cachedPlayingPlayers, stats.getPlayingPlayers());
        int cpuPenalty = (int)(Math.pow(1.05, (double)100 * stats.getCpu().getSystemLoad()) * (double)10 - (double)10);
        FrameStats frames = stats.getFrameStats();
        int deficitFramePenalty = 0;
        int nullFramePenalty = 0;
        if (frames != null && frames.getDeficit() != -1) {
            deficitFramePenalty = (int)((float)Math.pow(1.03f, 500.0f * ((float)frames.getDeficit() / 3000.0f)) * (float)600 - (float)600);
            nullFramePenalty = (int)((float)Math.pow(1.03f, 500.0f * ((float)frames.getNulled() / 3000.0f)) * (float)600 - (float)600);
            nullFramePenalty *= 2;
        }
        Integer n5 = metrics.get((Object)MetricType.TRACK_STUCK);
        int tracksStuck = n5 != null ? n5 : 0;
        Integer n6 = metrics.get((Object)MetricType.TRACK_EXCEPTION);
        int trackExceptions = n6 != null ? n6 : 0;
        int trackStuckPenalty = tracksStuck * 100 - 100;
        int trackExceptionPenalty = trackExceptions * 10 - 10;
        int loadFailedPenalty = loadsFailed > 0 ? loadsFailed / loadsAttempted : 0;
        return playerPenalty + cpuPenalty + deficitFramePenalty + nullFramePenalty + trackStuckPenalty + trackExceptionPenalty + loadFailedPenalty;
    }

    @NotNull
    public final LavalinkNode component1() {
        return this.node;
    }

    @NotNull
    public final Penalties copy(@NotNull LavalinkNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return new Penalties(node);
    }

    public static /* synthetic */ Penalties copy$default(Penalties penalties, LavalinkNode lavalinkNode, int n, Object object) {
        if ((n & 1) != 0) {
            lavalinkNode = penalties.node;
        }
        return penalties.copy(lavalinkNode);
    }

    @NotNull
    public String toString() {
        return "Penalties(node=" + this.node + ")";
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Penalties)) {
            return false;
        }
        Penalties penalties = (Penalties)other;
        return Intrinsics.areEqual((Object)this.node, (Object)penalties.node);
    }
}

