/*
 * Decompiled with CFR 0.152.
 */
package dev.arbjerg.lavalink.libraries.jda;

import dev.arbjerg.lavalink.client.LavalinkClient;
import dev.arbjerg.lavalink.client.Link;
import dev.arbjerg.lavalink.client.LinkState;
import dev.arbjerg.lavalink.client.loadbalancing.VoiceRegion;
import dev.arbjerg.lavalink.client.player.LavalinkPlayer;
import dev.arbjerg.lavalink.protocol.v4.PlayerState;
import dev.arbjerg.lavalink.protocol.v4.VoiceState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.dv8tion.jda.api.entities.channel.middleman.AudioChannel;
import net.dv8tion.jda.api.hooks.VoiceDispatchInterceptor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldev/arbjerg/lavalink/libraries/jda/JDAVoiceUpdateListener;", "Lnet/dv8tion/jda/api/hooks/VoiceDispatchInterceptor;", "lavalink", "Ldev/arbjerg/lavalink/client/LavalinkClient;", "(Ldev/arbjerg/lavalink/client/LavalinkClient;)V", "onVoiceServerUpdate", "", "update", "Lnet/dv8tion/jda/api/hooks/VoiceDispatchInterceptor$VoiceServerUpdate;", "onVoiceStateUpdate", "", "Lnet/dv8tion/jda/api/hooks/VoiceDispatchInterceptor$VoiceStateUpdate;", "lavalink-client"})
public final class JDAVoiceUpdateListener
implements VoiceDispatchInterceptor {
    @NotNull
    private final LavalinkClient lavalink;

    public JDAVoiceUpdateListener(@NotNull LavalinkClient lavalink) {
        Intrinsics.checkNotNullParameter((Object)lavalink, (String)"lavalink");
        this.lavalink = lavalink;
    }

    public void onVoiceServerUpdate(@NotNull VoiceDispatchInterceptor.VoiceServerUpdate update) {
        Intrinsics.checkNotNullParameter((Object)update, (String)"update");
        String string = update.getToken();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getToken(...)");
        String string2 = update.getEndpoint();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getEndpoint(...)");
        String string3 = update.getSessionId();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getSessionId(...)");
        VoiceState state = new VoiceState(string, string2, string3);
        String string4 = update.getEndpoint();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getEndpoint(...)");
        VoiceRegion region = VoiceRegion.Companion.fromEndpoint(string4);
        Link link = this.lavalink.getOrCreateLink(update.getGuildIdLong(), region);
        link.onVoiceServerUpdate(state);
    }

    public boolean onVoiceStateUpdate(@NotNull VoiceDispatchInterceptor.VoiceStateUpdate update) {
        Intrinsics.checkNotNullParameter((Object)update, (String)"update");
        AudioChannel channel = update.getChannel();
        Link link = this.lavalink.getLinkIfCached(update.getGuildIdLong());
        if (link == null) {
            return false;
        }
        Link link2 = link;
        LavalinkPlayer lavalinkPlayer = link2.getNode().getCachedPlayer(update.getGuildIdLong());
        if (lavalinkPlayer == null) {
            return false;
        }
        LavalinkPlayer player = lavalinkPlayer;
        PlayerState playerState = player.getState();
        if (channel == null) {
            if (playerState.getConnected()) {
                link2.setState$lavalink_client(LinkState.CONNECTED);
            } else {
                link2.setState$lavalink_client(LinkState.DISCONNECTED);
                link2.destroy().subscribe();
            }
        }
        return playerState.getConnected();
    }
}

