/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.bootstrap;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import lavalink.server.bootstrap.PluginDeclaration;
import lavalink.server.bootstrap.PluginManager;
import lavalink.server.bootstrap.PluginManifest;
import lavalink.server.bootstrap.PluginsConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@SpringBootApplication
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 !2\u00020\u0001:\u0001!B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0012J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0012J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u001bH\u0012J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0012J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001fH\u0012J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\r0\u001bH\u0012R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\""}, d2={"Llavalink/server/bootstrap/PluginManager;", "", "config", "Llavalink/server/bootstrap/PluginsConfig;", "(Llavalink/server/bootstrap/PluginsConfig;)V", "classLoader", "Ljava/lang/ClassLoader;", "getClassLoader", "()Ljava/lang/ClassLoader;", "setClassLoader", "(Ljava/lang/ClassLoader;)V", "pluginManifests", "", "Llavalink/server/bootstrap/PluginManifest;", "getPluginManifests", "()Ljava/util/List;", "downloadJar", "", "output", "Ljava/io/File;", "url", "", "loadJar", "file", "cl", "Ljava/net/URLClassLoader;", "loadJars", "", "manageDownloads", "parsePluginManifest", "stream", "Ljava/io/InputStream;", "readClasspathManifests", "Companion", "Lavalink-Server"})
public class PluginManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<PluginManifest> pluginManifests;
    @NotNull
    private ClassLoader classLoader;
    @NotNull
    private static final Logger log;

    public PluginManager(@NotNull PluginsConfig config) {
        List<PluginManifest> list;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.pluginManifests = new ArrayList();
        ClassLoader classLoader = PluginManager.class.getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"PluginManager::class.java.classLoader");
        this.classLoader = classLoader;
        this.manageDownloads(config);
        List<PluginManifest> $this$_init__u24lambda_u240 = list = this.pluginManifests;
        boolean bl = false;
        $this$_init__u24lambda_u240.addAll((Collection<PluginManifest>)this.readClasspathManifests());
        $this$_init__u24lambda_u240.addAll((Collection<PluginManifest>)this.loadJars());
    }

    @NotNull
    public final List<PluginManifest> getPluginManifests() {
        return this.pluginManifests;
    }

    @NotNull
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(@NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"<set-?>");
        this.classLoader = classLoader;
    }

    /*
     * WARNING - void declaration
     */
    private void manageDownloads(PluginsConfig config) {
        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000#\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J6\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0019"}, d2={"lavalink/server/bootstrap/PluginManager$manageDownloads$Declaration", "", "group", "", "name", "version", "repository", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getGroup", "()Ljava/lang/String;", "getName", "getRepository", "getVersion", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Llavalink/server/bootstrap/PluginManager$manageDownloads$Declaration;", "equals", "", "other", "hashCode", "", "toString", "Lavalink-Server"})
        public final class Declaration {
            @NotNull
            private final String group;
            @NotNull
            private final String name;
            @NotNull
            private final String version;
            @NotNull
            private final String repository;

            public Declaration(@NotNull String group, @NotNull String name, @NotNull String version, @NotNull String repository) {
                Intrinsics.checkNotNullParameter((Object)group, (String)"group");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
                this.group = group;
                this.name = name;
                this.version = version;
                this.repository = repository;
            }

            @NotNull
            public final String getGroup() {
                return this.group;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            @NotNull
            public final String getVersion() {
                return this.version;
            }

            @NotNull
            public final String getRepository() {
                return this.repository;
            }

            @NotNull
            public final String component1() {
                return this.group;
            }

            @NotNull
            public final String component2() {
                return this.name;
            }

            @NotNull
            public final String component3() {
                return this.version;
            }

            @NotNull
            public final String component4() {
                return this.repository;
            }

            @NotNull
            public final Declaration copy(@NotNull String group, @NotNull String name, @NotNull String version, @NotNull String repository) {
                Intrinsics.checkNotNullParameter((Object)group, (String)"group");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
                return new Declaration(group, name, version, repository);
            }

            public static /* synthetic */ Declaration copy$default(Declaration declaration, String string, String string2, String string3, String string4, int n, Object object) {
                if ((n & 1) != 0) {
                    string = declaration.group;
                }
                if ((n & 2) != 0) {
                    string2 = declaration.name;
                }
                if ((n & 4) != 0) {
                    string3 = declaration.version;
                }
                if ((n & 8) != 0) {
                    string4 = declaration.repository;
                }
                return declaration.copy(string, string2, string3, string4);
            }

            @NotNull
            public String toString() {
                return "Declaration(group=" + this.group + ", name=" + this.name + ", version=" + this.version + ", repository=" + this.repository + ")";
            }

            public int hashCode() {
                int result = this.group.hashCode();
                result = result * 31 + this.name.hashCode();
                result = result * 31 + this.version.hashCode();
                result = result * 31 + this.repository.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Declaration)) {
                    return false;
                }
                Declaration declaration = (Declaration)other;
                if (!Intrinsics.areEqual((Object)this.group, (Object)declaration.group)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.name, (Object)declaration.name)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.version, (Object)declaration.version)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.repository, (Object)declaration.repository);
            }
        }
        void $this$mapTo$iv$iv;
        String[] element$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        if (config.getPlugins().isEmpty()) {
            return;
        }
        File directory = new File("./plugins");
        directory.mkdir();
        Pattern pattern = Pattern.compile("(.+)-(.+)\\.jar$");
        File[] fileArray = directory.listFiles();
        Intrinsics.checkNotNull((Object)fileArray);
        File[] $this$mapNotNull$iv = fileArray;
        boolean $i$f$mapNotNull = false;
        File[] fileArray2 = $this$mapNotNull$iv;
        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000+\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J,\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0018"}, d2={"lavalink/server/bootstrap/PluginManager$manageDownloads$PluginJar", "", "name", "", "version", "file", "Ljava/io/File;", "(Ljava/lang/String;Ljava/lang/String;Ljava/io/File;)V", "getFile", "()Ljava/io/File;", "getName", "()Ljava/lang/String;", "getVersion", "component1", "component2", "component3", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/io/File;)Llavalink/server/bootstrap/PluginManager$manageDownloads$PluginJar;", "equals", "", "other", "hashCode", "", "toString", "Lavalink-Server"})
        public final class PluginJar {
            @NotNull
            private final String name;
            @NotNull
            private final String version;
            @NotNull
            private final File file;

            public PluginJar(@NotNull String name, @NotNull String version, @NotNull File file) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                this.name = name;
                this.version = version;
                this.file = file;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            @NotNull
            public final String getVersion() {
                return this.version;
            }

            @NotNull
            public final File getFile() {
                return this.file;
            }

            @NotNull
            public final String component1() {
                return this.name;
            }

            @NotNull
            public final String component2() {
                return this.version;
            }

            @NotNull
            public final File component3() {
                return this.file;
            }

            @NotNull
            public final PluginJar copy(@NotNull String name, @NotNull String version, @NotNull File file) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return new PluginJar(name, version, file);
            }

            public static /* synthetic */ PluginJar copy$default(PluginJar pluginJar, String string, String string2, File file, int n, Object object) {
                if ((n & 1) != 0) {
                    string = pluginJar.name;
                }
                if ((n & 2) != 0) {
                    string2 = pluginJar.version;
                }
                if ((n & 4) != 0) {
                    file = pluginJar.file;
                }
                return pluginJar.copy(string, string2, file);
            }

            @NotNull
            public String toString() {
                return "PluginJar(name=" + this.name + ", version=" + this.version + ", file=" + this.file + ")";
            }

            public int hashCode() {
                int result = this.name.hashCode();
                result = result * 31 + this.version.hashCode();
                result = result * 31 + this.file.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof PluginJar)) {
                    return false;
                }
                PluginJar pluginJar = (PluginJar)other;
                if (!Intrinsics.areEqual((Object)this.name, (Object)pluginJar.name)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.version, (Object)pluginJar.version)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.file, (Object)pluginJar.file);
            }
        }
        Iterable<PluginJar> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        for (void element$iv$iv$iv : $this$forEach$iv$iv$iv) {
            PluginJar pluginJar;
            element$iv$iv = element$iv$iv$iv;
            boolean bl = false;
            void f = element$iv$iv;
            boolean bl2 = false;
            Matcher matcher = pattern.matcher(f.getName());
            if (!matcher.find()) {
                pluginJar = null;
            } else {
                String string = matcher.group(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcher.group(1)");
                String string2 = matcher.group(2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"matcher.group(2)");
                Intrinsics.checkNotNullExpressionValue((Object)f, (String)"f");
                pluginJar = new PluginJar(string, string2, (File)f);
            }
            if (pluginJar == null) continue;
            PluginJar it$iv$iv = pluginJar;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List pluginJars = (List)destination$iv$iv;
        Iterable $this$map$iv = config.getPlugins();
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object;
            void declaration;
            PluginDeclaration pluginDeclaration = (PluginDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            if (declaration.getDependency() == null || declaration.getRepository() == null) {
                throw new RuntimeException("Illegal declaration " + (PluginDeclaration)declaration);
            }
            String string = declaration.getDependency();
            Intrinsics.checkNotNull((Object)string);
            element$iv$iv = new String[]{":"};
            List fragments = StringsKt.split$default((CharSequence)string, (String[])element$iv$iv, (boolean)false, (int)0, (int)6, null);
            if (fragments.size() != 3) {
                throw new RuntimeException("Invalid dependency \"" + declaration.getDependency() + "\"");
            }
            String string3 = declaration.getRepository();
            Intrinsics.checkNotNull((Object)string3);
            if (StringsKt.endsWith$default((String)string3, (String)"/", (boolean)false, (int)2, null)) {
                String string4 = declaration.getRepository();
                object = string4;
                Intrinsics.checkNotNull((Object)string4);
            } else {
                String string5 = declaration.getRepository();
                Intrinsics.checkNotNull((Object)string5);
                object = string5 + "/";
            }
            Object repository = object;
            collection.add(new Declaration((String)fragments.get(0), (String)fragments.get(1), (String)fragments.get(2), (String)repository));
        }
        List declarations = (List)destination$iv$iv2;
        Iterable $this$forEach$iv = declarations;
        boolean $i$f$forEach2 = false;
        block2: for (Object element$iv : $this$forEach$iv) {
            void $this$manageDownloads_u24lambda_u246_u24lambda_u245;
            Declaration declaration = (Declaration)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = pluginJars;
            boolean $i$f$forEach3 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                PluginJar jar = (PluginJar)element$iv2;
                boolean bl4 = false;
                if (!Intrinsics.areEqual((Object)declaration.getName(), (Object)jar.getName())) continue;
                if (Intrinsics.areEqual((Object)declaration.getVersion(), (Object)jar.getVersion())) continue block2;
                if (!jar.getFile().delete()) {
                    throw new RuntimeException("Failed to delete " + jar.getFile().getPath());
                }
                log.info("Deleted " + jar.getFile().getPath());
            }
            Declaration $this$manageDownloads_u24lambda_u246_u24lambda_u244 = declaration;
            boolean $i$a$-run-PluginManager$manageDownloads$1$url$22 = false;
            String url = $this$manageDownloads_u24lambda_u246_u24lambda_u244.getRepository() + StringsKt.replace$default((String)$this$manageDownloads_u24lambda_u246_u24lambda_u244.getGroup(), (String)".", (String)"/", (boolean)false, (int)4, null) + "/" + $this$manageDownloads_u24lambda_u246_u24lambda_u244.getName() + "/" + $this$manageDownloads_u24lambda_u246_u24lambda_u244.getVersion() + "/" + $this$manageDownloads_u24lambda_u246_u24lambda_u244.getName() + "-" + $this$manageDownloads_u24lambda_u246_u24lambda_u244.getVersion() + ".jar";
            Declaration $i$a$-run-PluginManager$manageDownloads$1$url$22 = declaration;
            File file = directory;
            boolean bl5 = false;
            String string = $this$manageDownloads_u24lambda_u246_u24lambda_u245.getName() + "-" + $this$manageDownloads_u24lambda_u246_u24lambda_u245.getVersion() + ".jar";
            File file2 = file;
            File file3 = new File(file2, string);
            this.downloadJar(file3, url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadJar(File output, String url) {
        log.info("Downloading " + url);
        Closeable closeable = Channels.newChannel(new URL(url).openStream());
        Throwable throwable = null;
        try {
            ReadableByteChannel it = (ReadableByteChannel)closeable;
            boolean bl = false;
            long l = new FileOutputStream(output).getChannel().transferFrom(it, 0L, Long.MAX_VALUE);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<PluginManifest> readClasspathManifests() {
        void $this$mapTo$iv$iv;
        Resource[] resourceArray = new PathMatchingResourcePatternResolver().getResources("classpath*:lavalink-plugins/*.properties");
        Intrinsics.checkNotNullExpressionValue((Object)resourceArray, (String)"PathMatchingResourcePatt\u2026nk-plugins/*.properties\")");
        Object[] $this$map$iv = resourceArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void r;
            Resource resource = (Resource)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            InputStream inputStream = r.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"r.inputStream");
            collection.add(this.parsePluginManifest(inputStream));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private List<PluginManifest> loadJars() {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        File directory = new File("./plugins");
        if (!directory.isDirectory()) {
            return CollectionsKt.emptyList();
        }
        List jarsToLoad = new ArrayList();
        Files.list(new File("./plugins").toPath()).forEach(arg_0 -> PluginManager.loadJars$lambda$9((Function1)new Function1<Path, Unit>((List<File>)jarsToLoad){
            final /* synthetic */ List<File> $jarsToLoad;
            {
                this.$jarsToLoad = $jarsToLoad;
                super(1);
            }

            public final void invoke(Path path) {
                File file = path.toFile();
                if (!file.isFile()) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"jar")) {
                    return;
                }
                this.$jarsToLoad.add(file);
            }
        }, arg_0));
        if (jarsToLoad.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = jarsToLoad;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new URL("jar:file:" + it.getAbsolutePath() + "!/"));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
        Intrinsics.checkNotNull((Object)uRLArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        URLClassLoader cl = URLClassLoader.newInstance(uRLArray, this.getClass().getClassLoader());
        Intrinsics.checkNotNullExpressionValue((Object)cl, (String)"cl");
        this.setClassLoader(cl);
        List manifests = new ArrayList();
        Iterable $this$forEach$iv = jarsToLoad;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file = (File)element$iv;
            boolean bl = false;
            try {
                manifests.addAll((Collection)this.loadJar(file, cl));
            }
            catch (Exception e) {
                throw new RuntimeException("Error loading " + file, e);
            }
        }
        return manifests;
    }

    /*
     * WARNING - void declaration
     */
    private List<PluginManifest> loadJar(File file, URLClassLoader cl) {
        void $this$mapTo$iv$iv;
        Object element$iv;
        int classCount = 0;
        JarFile jar = new JarFile(file);
        List manifests = new ArrayList();
        Iterator<JarEntry> iterator = jar.entries().asIterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"jar.entries().asIterator()");
        Iterator<JarEntry> $this$forEach$iv = iterator;
        boolean $i$f$forEach = false;
        Iterator<JarEntry> iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            JarEntry entry = element$iv;
            boolean bl = false;
            if (entry.isDirectory()) continue;
            String string = entry.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.name");
            if (!StringsKt.startsWith$default((String)string, (String)"lavalink-plugins/", (boolean)false, (int)2, null)) continue;
            String string2 = entry.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"entry.name");
            if (!StringsKt.endsWith$default((String)string2, (String)".properties", (boolean)false, (int)2, null)) continue;
            InputStream inputStream = jar.getInputStream(entry);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"jar.getInputStream(entry)");
            manifests.add(this.parsePluginManifest(inputStream));
        }
        if (manifests.isEmpty()) {
            throw new RuntimeException("No plugin manifest found in " + file.getPath());
        }
        Iterable $this$map$iv = manifests;
        boolean $i$f$map = false;
        element$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PluginManifest pluginManifest = (PluginManifest)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.replace$default((String)it.getPath(), (String)".", (String)"/", (boolean)false, (int)4, null));
        }
        List allowedPaths = (List)destination$iv$iv;
        Iterator<JarEntry> iterator3 = jar.entries().asIterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, (String)"jar.entries().asIterator()");
        Iterator<JarEntry> $this$forEach$iv2 = iterator3;
        boolean $i$f$forEach2 = false;
        Iterator<JarEntry> iterator4 = $this$forEach$iv2;
        while (iterator4.hasNext()) {
            boolean bl;
            JarEntry entry;
            block7: {
                JarEntry element$iv2;
                entry = element$iv2 = iterator4.next();
                boolean bl2 = false;
                if (entry.isDirectory()) continue;
                String string = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.name");
                if (!StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null)) continue;
                Iterable $this$any$iv = allowedPaths;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv3 : $this$any$iv) {
                        String it = (String)element$iv3;
                        boolean bl3 = false;
                        String string3 = entry.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"entry.name");
                        if (!StringsKt.startsWith$default((String)string3, (String)it, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            String string = entry.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.name");
            cl.loadClass(StringsKt.replace$default((String)StringsKt.dropLast((String)string, (int)6), (String)"/", (String)".", (boolean)false, (int)4, null));
            ++classCount;
        }
        log.info("Loaded " + file.getName() + " (" + classCount + " classes)");
        return manifests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginManifest parsePluginManifest(InputStream stream) {
        Closeable closeable = stream;
        Throwable throwable = null;
        try {
            Properties properties;
            Object it = (InputStream)closeable;
            boolean bl = false;
            Properties $this$parsePluginManifest_u24lambda_u2417_u24lambda_u2416 = properties = new Properties();
            boolean bl2 = false;
            $this$parsePluginManifest_u24lambda_u2417_u24lambda_u2416.load((InputStream)it);
            it = properties;
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Object props = it;
        String string = ((Properties)props).getProperty("name");
        if (string == null) {
            throw new RuntimeException("Manifest is missing 'name'");
        }
        String name = string;
        String string2 = ((Properties)props).getProperty("path");
        if (string2 == null) {
            throw new RuntimeException("Manifest is missing 'path'");
        }
        String path = string2;
        String string3 = ((Properties)props).getProperty("version");
        if (string3 == null) {
            throw new RuntimeException("Manifest is missing 'version'");
        }
        String version = string3;
        log.info("Found plugin '" + name + "' version " + version);
        return new PluginManifest(name, path, version);
    }

    private static final void loadJars$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    static {
        Logger logger = LoggerFactory.getLogger(PluginManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(PluginManager::class.java)");
        log = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llavalink/server/bootstrap/PluginManager$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "Lavalink-Server"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

