/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.config;

import com.sedmelluq.discord.lavaplayer.container.MediaContainerProbe;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerRegistry;
import com.sedmelluq.discord.lavaplayer.player.AudioConfiguration;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.player.DefaultAudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.bandcamp.BandcampAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.http.HttpAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.local.LocalAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.DefaultSoundCloudDataLoader;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.DefaultSoundCloudDataReader;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.DefaultSoundCloudFormatHandler;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.DefaultSoundCloudPlaylistLoader;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudDataLoader;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudDataReader;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudFormatHandler;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudPlaylistLoader;
import com.sedmelluq.discord.lavaplayer.source.twitch.TwitchStreamAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.vimeo.VimeoAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeAudioSourceManager;
import com.sedmelluq.lava.extensions.youtuberotator.YoutubeIpRotatorSetup;
import com.sedmelluq.lava.extensions.youtuberotator.planner.AbstractRoutePlanner;
import com.sedmelluq.lava.extensions.youtuberotator.planner.BalancingIpRoutePlanner;
import com.sedmelluq.lava.extensions.youtuberotator.planner.NanoIpRoutePlanner;
import com.sedmelluq.lava.extensions.youtuberotator.planner.RotatingIpRoutePlanner;
import com.sedmelluq.lava.extensions.youtuberotator.planner.RotatingNanoIpRoutePlanner;
import com.sedmelluq.lava.extensions.youtuberotator.tools.ip.IpBlock;
import com.sedmelluq.lava.extensions.youtuberotator.tools.ip.Ipv4Block;
import com.sedmelluq.lava.extensions.youtuberotator.tools.ip.Ipv6Block;
import dev.arbjerg.lavalink.api.AudioPlayerManagerConfiguration;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import lavalink.server.config.AudioSourcesConfig;
import lavalink.server.config.HttpConfig;
import lavalink.server.config.RateLimitConfig;
import lavalink.server.config.ServerConfig;
import lavalink.server.config.YoutubeConfig;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JL\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000fH\u0017J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0017R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Llavalink/server/config/AudioPlayerConfiguration;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "audioPlayerManagerSupplier", "Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;", "sources", "Llavalink/server/config/AudioSourcesConfig;", "serverConfig", "Llavalink/server/config/ServerConfig;", "routePlanner", "Lcom/sedmelluq/lava/extensions/youtuberotator/planner/AbstractRoutePlanner;", "audioSourceManagers", "", "Lcom/sedmelluq/discord/lavaplayer/source/AudioSourceManager;", "audioPlayerManagerConfigurations", "Ldev/arbjerg/lavalink/api/AudioPlayerManagerConfiguration;", "mediaContainerProbes", "Lcom/sedmelluq/discord/lavaplayer/container/MediaContainerProbe;", "Lavalink-Server"})
public class AudioPlayerConfiguration {
    private final Logger log = LoggerFactory.getLogger(AudioPlayerConfiguration.class);

    @Bean
    @NotNull
    public AudioPlayerManager audioPlayerManagerSupplier(@NotNull AudioSourcesConfig sources, @NotNull ServerConfig serverConfig, @Nullable AbstractRoutePlanner routePlanner, @NotNull Collection<? extends AudioSourceManager> audioSourceManagers, @NotNull Collection<? extends AudioPlayerManagerConfiguration> audioPlayerManagerConfigurations, @NotNull Collection<? extends MediaContainerProbe> mediaContainerProbes) {
        Intrinsics.checkNotNullParameter((Object)sources, (String)"sources");
        Intrinsics.checkNotNullParameter((Object)serverConfig, (String)"serverConfig");
        Intrinsics.checkNotNullParameter(audioSourceManagers, (String)"audioSourceManagers");
        Intrinsics.checkNotNullParameter(audioPlayerManagerConfigurations, (String)"audioPlayerManagerConfigurations");
        Intrinsics.checkNotNullParameter(mediaContainerProbes, (String)"mediaContainerProbes");
        DefaultAudioPlayerManager audioPlayerManager = new DefaultAudioPlayerManager();
        if (serverConfig.isGcWarnings()) {
            audioPlayerManager.enableGcMonitoring();
        }
        int defaultFrameBufferDuration = audioPlayerManager.getFrameBufferDuration();
        Integer n = serverConfig.getFrameBufferDurationMs();
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            if (it < 200) {
                this.log.warn("Buffer size of " + it + "ms is illegal. Defaulting to " + defaultFrameBufferDuration + "ms");
            }
            Integer n2 = it;
            int it2 = ((Number)n2).intValue();
            boolean bl2 = false;
            Integer n3 = it2 >= 200 ? n2 : null;
            int bufferDuration = n3 != null ? n3 : defaultFrameBufferDuration;
            this.log.debug("Setting frame buffer duration to " + bufferDuration + "ms");
            audioPlayerManager.setFrameBufferDuration(bufferDuration);
        }
        int defaultOpusEncodingQuality = 10;
        AudioConfiguration it = audioPlayerManager.getConfiguration();
        boolean bl = false;
        Integer n4 = serverConfig.getOpusEncodingQuality();
        if (n4 != null) {
            int opusQuality = ((Number)n4).intValue();
            boolean bl3 = false;
            if (!(0 <= opusQuality ? opusQuality < 11 : false)) {
                this.log.warn("Opus encoding quality " + opusQuality + " is not within the range of 0 to 10. Defaulting to " + defaultOpusEncodingQuality);
            }
            Integer bl2 = opusQuality;
            int it3 = ((Number)bl2).intValue();
            boolean bl4 = false;
            Integer n5 = (0 <= it3 ? it3 < 11 : false) ? bl2 : null;
            int qualitySetting = n5 != null ? n5 : defaultOpusEncodingQuality;
            this.log.debug("Setting opusEncodingQuality to " + qualitySetting);
            it.setOpusEncodingQuality(qualitySetting);
        }
        AudioConfiguration.ResamplingQuality resamplingQuality = serverConfig.getResamplingQuality();
        if (resamplingQuality != null) {
            AudioConfiguration.ResamplingQuality resamplingQuality2 = resamplingQuality;
            boolean bl5 = false;
            this.log.debug("Setting resamplingQuality to " + resamplingQuality2);
            it.setResamplingQuality(resamplingQuality2);
        }
        long defaultTrackStuckThresholdMs = TimeUnit.NANOSECONDS.toMillis(audioPlayerManager.getTrackStuckThresholdNanos());
        Long l = serverConfig.getTrackStuckThresholdMs();
        if (l != null) {
            long it4 = ((Number)l).longValue();
            boolean bl6 = false;
            if (it4 < 100L) {
                this.log.warn("Track Stuck Threshold of " + it4 + "ms is too small. Defaulting to " + defaultTrackStuckThresholdMs + "ms");
            }
            Long bl4 = it4;
            long it5 = ((Number)bl4).longValue();
            boolean bl7 = false;
            Long l2 = it5 >= 100L ? bl4 : null;
            long trackStuckThresholdMs = l2 != null ? l2 : defaultTrackStuckThresholdMs;
            this.log.debug("Setting Track Stuck Threshold to " + trackStuckThresholdMs + "ms");
            audioPlayerManager.setTrackStuckThreshold(trackStuckThresholdMs);
        }
        Boolean bl8 = serverConfig.getUseSeekGhosting();
        if (bl8 != null) {
            boolean seekGhosting = bl8;
            boolean bl9 = false;
            this.log.debug("Setting useSeekGhosting to " + seekGhosting);
            audioPlayerManager.setUseSeekGhosting(seekGhosting);
        }
        Collection<? extends MediaContainerProbe> $this$toTypedArray$iv = mediaContainerProbes;
        boolean $i$f$toTypedArray = false;
        Collection<? extends MediaContainerProbe> thisCollection$iv = $this$toTypedArray$iv;
        MediaContainerProbe[] mediaContainerProbeArray = thisCollection$iv.toArray(new MediaContainerProbe[0]);
        Intrinsics.checkNotNull((Object)mediaContainerProbeArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        MediaContainerProbe[] seekGhosting = mediaContainerProbeArray;
        MediaContainerRegistry mediaContainerRegistry = MediaContainerRegistry.extended((MediaContainerProbe[])Arrays.copyOf(seekGhosting, seekGhosting.length));
        Intrinsics.checkNotNullExpressionValue((Object)mediaContainerRegistry, (String)"extended(*mediaContainerProbes.toTypedArray())");
        MediaContainerRegistry mcr = mediaContainerRegistry;
        if (sources.isYoutube()) {
            Integer playlistLoadLimit;
            YoutubeConfig youtubeConfig = serverConfig.getYoutubeConfig();
            YoutubeAudioSourceManager youtube = null;
            if (youtubeConfig != null) {
                if (StringsKt.isBlank((CharSequence)youtubeConfig.getEmail()) && StringsKt.isBlank((CharSequence)youtubeConfig.getPassword())) {
                    this.log.info("Email and password fields are blank, some age restricted videos will throw exceptions");
                }
                youtube = new YoutubeAudioSourceManager(serverConfig.isYoutubeSearchEnabled(), youtubeConfig.getEmail(), youtubeConfig.getPassword());
            } else {
                youtube = new YoutubeAudioSourceManager(serverConfig.isYoutubeSearchEnabled(), "", "");
                this.log.debug("Youtube config block is not found");
            }
            if (routePlanner != null) {
                RateLimitConfig rateLimitConfig = serverConfig.getRatelimit();
                int retryLimit = rateLimitConfig != null ? rateLimitConfig.getRetryLimit() : -1;
                if (retryLimit < 0) {
                    new YoutubeIpRotatorSetup(routePlanner).forSource(youtube).setup();
                } else if (retryLimit == 0) {
                    new YoutubeIpRotatorSetup(routePlanner).forSource(youtube).withRetryLimit(Integer.MAX_VALUE).setup();
                } else {
                    new YoutubeIpRotatorSetup(routePlanner).forSource(youtube).withRetryLimit(retryLimit).setup();
                }
            }
            if ((playlistLoadLimit = serverConfig.getYoutubePlaylistLoadLimit()) != null) {
                youtube.setPlaylistPageCount(playlistLoadLimit.intValue());
            }
            audioPlayerManager.registerSourceManager((AudioSourceManager)youtube);
        }
        if (sources.isSoundcloud()) {
            DefaultSoundCloudDataReader dataReader = new DefaultSoundCloudDataReader();
            DefaultSoundCloudDataLoader dataLoader = new DefaultSoundCloudDataLoader();
            DefaultSoundCloudFormatHandler formatHandler = new DefaultSoundCloudFormatHandler();
            audioPlayerManager.registerSourceManager((AudioSourceManager)new SoundCloudAudioSourceManager(serverConfig.isSoundcloudSearchEnabled(), (SoundCloudDataReader)dataReader, (SoundCloudDataLoader)dataLoader, (SoundCloudFormatHandler)formatHandler, (SoundCloudPlaylistLoader)new DefaultSoundCloudPlaylistLoader((SoundCloudDataLoader)dataLoader, (SoundCloudDataReader)dataReader, (SoundCloudFormatHandler)formatHandler)));
        }
        if (sources.isBandcamp()) {
            audioPlayerManager.registerSourceManager((AudioSourceManager)new BandcampAudioSourceManager());
        }
        if (sources.isTwitch()) {
            audioPlayerManager.registerSourceManager((AudioSourceManager)new TwitchStreamAudioSourceManager());
        }
        if (sources.isVimeo()) {
            audioPlayerManager.registerSourceManager((AudioSourceManager)new VimeoAudioSourceManager());
        }
        if (sources.isLocal()) {
            audioPlayerManager.registerSourceManager((AudioSourceManager)new LocalAudioSourceManager(mcr));
        }
        Iterable $this$forEach$iv = audioSourceManagers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AudioSourceManager it6 = (AudioSourceManager)element$iv;
            boolean bl10 = false;
            audioPlayerManager.registerSourceManager(it6);
            this.log.info("Registered " + it6 + " provided from a plugin");
        }
        audioPlayerManager.getConfiguration().setFilterHotSwapEnabled(true);
        DefaultAudioPlayerManager am = null;
        am = audioPlayerManager;
        Iterable $this$forEach$iv2 = audioPlayerManagerConfigurations;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            AudioPlayerManagerConfiguration it7 = (AudioPlayerManagerConfiguration)element$iv;
            boolean bl11 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it7.configure((AudioPlayerManager)am), (String)"it.configure(am)");
        }
        if (sources.isHttp()) {
            HttpAudioSourceManager httpAudioSourceManager = new HttpAudioSourceManager(mcr);
            HttpConfig httpConfig = serverConfig.getHttpConfig();
            if (httpConfig != null) {
                HttpConfig httpConfig2 = httpConfig;
                boolean bl12 = false;
                httpAudioSourceManager.configureBuilder(arg_0 -> AudioPlayerConfiguration.audioPlayerManagerSupplier$lambda$12$lambda$11(httpConfig2, arg_0));
            }
            audioPlayerManager.registerSourceManager((AudioSourceManager)httpAudioSourceManager);
        }
        return (AudioPlayerManager)am;
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    @Nullable
    public AbstractRoutePlanner routePlanner(@NotNull ServerConfig serverConfig) {
        AbstractRoutePlanner abstractRoutePlanner;
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)serverConfig, (String)"serverConfig");
        RateLimitConfig rateLimitConfig = serverConfig.getRatelimit();
        if (rateLimitConfig == null) {
            this.log.debug("No rate limit config block found, skipping setup of route planner");
            return null;
        }
        List<String> ipBlockList = rateLimitConfig.getIpBlocks();
        if (ipBlockList.isEmpty()) {
            this.log.info("List of ip blocks is empty, skipping setup of route planner");
            return null;
        }
        Iterable $this$map$iv = rateLimitConfig.getExcludedIps();
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(InetAddress.getByName((String)it));
        }
        List blacklisted = (List)destination$iv$iv;
        Predicate<InetAddress> filter = arg_0 -> AudioPlayerConfiguration.routePlanner$lambda$14(blacklisted, arg_0);
        Iterable $this$map$iv2 = ipBlockList;
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IpBlock ipBlock;
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            if (Ipv4Block.isIpv4CidrBlock((String)it)) {
                ipBlock = (IpBlock)new Ipv4Block((String)it);
            } else if (Ipv6Block.isIpv6CidrBlock((String)it)) {
                ipBlock = (IpBlock)new Ipv6Block((String)it);
            } else {
                throw new RuntimeException("Invalid IP Block '" + (String)it + "', make sure to provide a valid CIDR notation");
            }
            collection.add(ipBlock);
        }
        List ipBlocks = (List)destination$iv$iv2;
        String string = rateLimitConfig.getStrategy();
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
        switch (((Object)StringsKt.trim((CharSequence)string2)).toString()) {
            case "rotateonban": {
                abstractRoutePlanner = (AbstractRoutePlanner)new RotatingIpRoutePlanner(ipBlocks, filter, rateLimitConfig.getSearchTriggersFail());
                break;
            }
            case "loadbalance": {
                abstractRoutePlanner = (AbstractRoutePlanner)new BalancingIpRoutePlanner(ipBlocks, filter, rateLimitConfig.getSearchTriggersFail());
                break;
            }
            case "nanoswitch": {
                abstractRoutePlanner = (AbstractRoutePlanner)new NanoIpRoutePlanner(ipBlocks, rateLimitConfig.getSearchTriggersFail());
                break;
            }
            case "rotatingnanoswitch": {
                abstractRoutePlanner = (AbstractRoutePlanner)new RotatingNanoIpRoutePlanner(ipBlocks, filter, rateLimitConfig.getSearchTriggersFail());
                break;
            }
            default: {
                throw new RuntimeException("Unknown strategy!");
            }
        }
        return abstractRoutePlanner;
    }

    private static final void audioPlayerManagerSupplier$lambda$12$lambda$11(HttpConfig $httpConfig, HttpClientBuilder it) {
        Intrinsics.checkNotNullParameter((Object)$httpConfig, (String)"$httpConfig");
        if (!StringsKt.isBlank((CharSequence)$httpConfig.getProxyHost())) {
            CredentialsProvider credsProvider = (CredentialsProvider)new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope($httpConfig.getProxyHost(), $httpConfig.getProxyPort()), (Credentials)new UsernamePasswordCredentials($httpConfig.getProxyUser(), $httpConfig.getProxyPassword()));
            it.setProxy(new HttpHost($httpConfig.getProxyHost(), $httpConfig.getProxyPort()));
            if (!StringsKt.isBlank((CharSequence)$httpConfig.getProxyUser())) {
                it.setDefaultCredentialsProvider(credsProvider);
            }
        }
    }

    private static final boolean routePlanner$lambda$14(List $blacklisted, InetAddress it) {
        Intrinsics.checkNotNullParameter((Object)$blacklisted, (String)"$blacklisted");
        return !$blacklisted.contains(it);
    }
}

