/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.config;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import lavalink.server.config.MetricsPrometheusConfigProperties;
import lavalink.server.config.ServerConfig;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0001\u0014B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Llavalink/server/config/RequestAuthorizationFilter;", "Lorg/springframework/web/servlet/HandlerInterceptor;", "Lorg/springframework/web/servlet/config/annotation/WebMvcConfigurer;", "serverConfig", "Llavalink/server/config/ServerConfig;", "metricsConfig", "Llavalink/server/config/MetricsPrometheusConfigProperties;", "(Llavalink/server/config/ServerConfig;Llavalink/server/config/MetricsPrometheusConfigProperties;)V", "addInterceptors", "", "registry", "Lorg/springframework/web/servlet/config/annotation/InterceptorRegistry;", "preHandle", "", "request", "Ljavax/servlet/http/HttpServletRequest;", "response", "Ljavax/servlet/http/HttpServletResponse;", "handler", "", "Companion", "Lavalink-Server"})
public class RequestAuthorizationFilter
implements HandlerInterceptor,
WebMvcConfigurer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ServerConfig serverConfig;
    @NotNull
    private final MetricsPrometheusConfigProperties metricsConfig;
    private static final Logger log = LoggerFactory.getLogger(RequestAuthorizationFilter.class);

    public RequestAuthorizationFilter(@NotNull ServerConfig serverConfig, @NotNull MetricsPrometheusConfigProperties metricsConfig) {
        Intrinsics.checkNotNullParameter((Object)serverConfig, (String)"serverConfig");
        Intrinsics.checkNotNullParameter((Object)metricsConfig, (String)"metricsConfig");
        this.serverConfig = serverConfig;
        this.metricsConfig = metricsConfig;
    }

    public boolean preHandle(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object handler) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        if (((CharSequence)this.metricsConfig.getEndpoint()).length() > 0 && Intrinsics.areEqual((Object)request.getServletPath(), (Object)this.metricsConfig.getEndpoint())) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)request.getServletPath(), (Object)"/error")) {
            bl = true;
        } else {
            String authorization = request.getHeader("Authorization");
            if (authorization == null || !Intrinsics.areEqual((Object)authorization, (Object)this.serverConfig.getPassword())) {
                String string = request.getRequestURI();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.requestURI");
                String string2 = string;
                int n = request.getContextPath().length();
                String string3 = string2.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                String path = string3;
                if (authorization == null) {
                    log.warn("Authorization missing for " + request.getRemoteAddr() + " on " + request.getMethod() + " " + path);
                    response.setStatus(HttpStatus.UNAUTHORIZED.value());
                    return false;
                }
                log.warn("Authorization failed for " + request.getRemoteAddr() + " on " + request.getMethod() + " " + path);
                response.setStatus(HttpStatus.FORBIDDEN.value());
                return false;
            }
            return true;
        }
        return bl;
    }

    public void addInterceptors(@NotNull InterceptorRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        registry.addInterceptor((HandlerInterceptor)this);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Llavalink/server/config/RequestAuthorizationFilter$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lavalink-Server"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

