/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.config;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.filter.Filter;
import io.sentry.Sentry;
import io.sentry.SentryClient;
import io.sentry.logback.SentryAppender;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import lavalink.server.Launcher;
import lavalink.server.config.SentryConfigProperties;
import lavalink.server.config.ServerConfig;
import org.jetbrains.annotations.NotNull;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\b\u0017\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0002J,\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Llavalink/server/config/SentryConfiguration;", "", "serverConfig", "Llavalink/server/config/ServerConfig;", "sentryConfig", "Llavalink/server/config/SentryConfigProperties;", "(Llavalink/server/config/ServerConfig;Llavalink/server/config/SentryConfigProperties;)V", "turnOff", "", "turnOn", "dsn", "", "tags", "", "environment", "Companion", "Lavalink-Server"})
public class SentryConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LoggerFactory.getLogger(SentryConfiguration.class);
    @NotNull
    private static final String SENTRY_APPENDER_NAME = "SENTRY";

    public SentryConfiguration(@NotNull ServerConfig serverConfig, @NotNull SentryConfigProperties sentryConfig) {
        Intrinsics.checkNotNullParameter((Object)serverConfig, (String)"serverConfig");
        Intrinsics.checkNotNullParameter((Object)sentryConfig, (String)"sentryConfig");
        String dsn = sentryConfig.getDsn();
        boolean warnDeprecatedDsnConfig = false;
        if (((CharSequence)dsn).length() == 0) {
            dsn = serverConfig.getSentryDsn();
            warnDeprecatedDsnConfig = true;
        }
        if (((CharSequence)dsn).length() > 0) {
            this.turnOn(dsn, sentryConfig.getTags(), sentryConfig.getEnvironment());
            if (warnDeprecatedDsnConfig) {
                log.warn("Please update the location of the sentry dsn in lavalinks config file / your environment vars, it is now located under 'sentry.dsn' instead of 'lavalink.server.sentryDsn'.");
            }
        } else {
            this.turnOff();
        }
    }

    private final void turnOn(String dsn, Map<String, String> tags, String environment) {
        log.info("Turning on sentry");
        SentryClient sentryClient = Sentry.init((String)dsn);
        if (!StringsKt.isBlank((CharSequence)environment)) {
            sentryClient.setEnvironment(environment);
        }
        Map<String, String> $this$forEach$iv = tags;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String name = entry.getKey();
            String value = entry.getValue();
            sentryClient.addTag(name, value);
        }
        Properties gitProps = new Properties();
        try {
            gitProps.load(Launcher.class.getClassLoader().getResourceAsStream("git.properties"));
        }
        catch (NullPointerException e) {
            log.error("Failed to load git repo information", (Throwable)e);
        }
        catch (IOException e) {
            log.error("Failed to load git repo information", (Throwable)e);
        }
        String commitHash = gitProps.getProperty("git.commit.id");
        if (commitHash != null && ((CharSequence)commitHash).length() > 0) {
            log.info("Setting sentry release to commit hash " + commitHash);
            sentryClient.setRelease(commitHash);
        } else {
            log.warn("No git commit hash found to set up sentry release");
        }
        SentryConfiguration.Companion.getSentryLogbackAppender().start();
    }

    private final void turnOff() {
        log.warn("Turning off sentry");
        Sentry.close();
        SentryConfiguration.Companion.getSentryLogbackAppender().stop();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Llavalink/server/config/SentryConfiguration$Companion;", "", "()V", "SENTRY_APPENDER_NAME", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "sentryLogbackAppender", "Lio/sentry/logback/SentryAppender;", "getSentryLogbackAppender", "()Lio/sentry/logback/SentryAppender;", "Lavalink-Server"})
    public static final class Companion {
        private Companion() {
        }

        private final synchronized SentryAppender getSentryLogbackAppender() {
            SentryAppender sentryAppender;
            ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
            Intrinsics.checkNotNull((Object)iLoggerFactory, (String)"null cannot be cast to non-null type ch.qos.logback.classic.LoggerContext");
            LoggerContext loggerContext = (LoggerContext)iLoggerFactory;
            ch.qos.logback.classic.Logger root = loggerContext.getLogger("ROOT");
            Appender appender = root.getAppender(SentryConfiguration.SENTRY_APPENDER_NAME);
            SentryAppender sentryAppender2 = sentryAppender = appender instanceof SentryAppender ? (SentryAppender)appender : null;
            if (sentryAppender == null) {
                sentryAppender = new SentryAppender();
                sentryAppender.setName(SentryConfiguration.SENTRY_APPENDER_NAME);
                ThresholdFilter warningsOrAboveFilter = new ThresholdFilter();
                warningsOrAboveFilter.setLevel(Level.WARN.levelStr);
                warningsOrAboveFilter.start();
                sentryAppender.addFilter((Filter)warningsOrAboveFilter);
                sentryAppender.setContext((Context)loggerContext);
                root.addAppender((Appender)sentryAppender);
            }
            return sentryAppender;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

