/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.config;

import dev.arbjerg.lavalink.api.RestInterceptor;
import dev.arbjerg.lavalink.protocol.v3.MapperKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableWebMvc
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u00020\u00072\u0010\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\fH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0017R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Llavalink/server/config/WebConfiguration;", "Lorg/springframework/web/servlet/config/annotation/WebMvcConfigurer;", "interceptors", "", "Ldev/arbjerg/lavalink/api/RestInterceptor;", "(Ljava/util/List;)V", "addInterceptors", "", "registry", "Lorg/springframework/web/servlet/config/annotation/InterceptorRegistry;", "configureMessageConverters", "converters", "", "Lorg/springframework/http/converter/HttpMessageConverter;", "jackson2ObjectMapperBuilder", "Lorg/springframework/http/converter/json/Jackson2ObjectMapperBuilder;", "Lavalink-Server"})
public class WebConfiguration
implements WebMvcConfigurer {
    @NotNull
    private final List<RestInterceptor> interceptors;

    public WebConfiguration(@NotNull List<? extends RestInterceptor> interceptors) {
        Intrinsics.checkNotNullParameter(interceptors, (String)"interceptors");
        this.interceptors = interceptors;
    }

    public void configureMessageConverters(@NotNull List<HttpMessageConverter<?>> converters) {
        Intrinsics.checkNotNullParameter(converters, (String)"converters");
        Jackson2ObjectMapperBuilder builder = new Jackson2ObjectMapperBuilder();
        builder.configure(MapperKt.objectMapper());
        converters.add((HttpMessageConverter<?>)new StringHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter(builder.build()));
    }

    @Bean
    @NotNull
    public Jackson2ObjectMapperBuilder jackson2ObjectMapperBuilder() {
        Jackson2ObjectMapperBuilder builder = new Jackson2ObjectMapperBuilder();
        builder.configure(MapperKt.objectMapper());
        return builder;
    }

    public void addInterceptors(@NotNull InterceptorRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Iterable $this$forEach$iv = this.interceptors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RestInterceptor it = (RestInterceptor)element$iv;
            boolean bl = false;
            registry.addInterceptor((HandlerInterceptor)it);
        }
    }
}

