/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.info;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\b\b\u0017\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006\u0010"}, d2={"Llavalink/server/info/AppInfo;", "", "()V", "artifactId", "", "getArtifactId", "()Ljava/lang/String;", "buildTime", "", "getBuildTime", "()J", "groupId", "getGroupId", "versionBuild", "getVersionBuild", "Companion", "Lavalink-Server"})
public class AppInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String versionBuild;
    @NotNull
    private final String groupId;
    @NotNull
    private final String artifactId;
    private final long buildTime;
    private static final Logger log = LoggerFactory.getLogger(AppInfo.class);

    public AppInfo() {
        InputStream resourceAsStream = this.getClass().getResourceAsStream("/app.properties");
        Properties prop = new Properties();
        try {
            prop.load(resourceAsStream);
        }
        catch (IOException e) {
            log.error("Failed to load app.properties", (Throwable)e);
        }
        String string = prop.getProperty("version");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"prop.getProperty(\"version\")");
        this.versionBuild = string;
        String string2 = prop.getProperty("groupId");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"prop.getProperty(\"groupId\")");
        this.groupId = string2;
        String string3 = prop.getProperty("artifactId");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"prop.getProperty(\"artifactId\")");
        this.artifactId = string3;
        String string4 = prop.getProperty("buildTime");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"prop.getProperty(\"buildTime\")");
        Long l = StringsKt.toLongOrNull((String)string4);
        this.buildTime = l != null ? l : -1L;
    }

    @NotNull
    public final String getVersionBuild() {
        return this.versionBuild;
    }

    @NotNull
    public final String getGroupId() {
        return this.groupId;
    }

    @NotNull
    public final String getArtifactId() {
        return this.artifactId;
    }

    public final long getBuildTime() {
        return this.buildTime;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Llavalink/server/info/AppInfo$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lavalink-Server"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

