/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.info;

import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0017\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Llavalink/server/info/GitRepoState;", "", "()V", "branch", "", "getBranch", "()Ljava/lang/String;", "commitId", "getCommitId", "commitIdAbbrev", "getCommitIdAbbrev", "commitMessageFull", "getCommitMessageFull", "commitMessageShort", "getCommitMessageShort", "commitTime", "", "getCommitTime", "()J", "commitUserEmail", "getCommitUserEmail", "commitUserName", "getCommitUserName", "isLoaded", "", "()Z", "setLoaded", "(Z)V", "Companion", "Lavalink-Server"})
public class GitRepoState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long commitTime;
    @NotNull
    private final String branch;
    @NotNull
    private final String commitId;
    @NotNull
    private final String commitIdAbbrev;
    @NotNull
    private final String commitUserName;
    @NotNull
    private final String commitUserEmail;
    @NotNull
    private final String commitMessageFull;
    @NotNull
    private final String commitMessageShort;
    private boolean isLoaded;
    private static final Logger log = LoggerFactory.getLogger(GitRepoState.class);

    public GitRepoState() {
        long l;
        Properties properties = new Properties();
        try {
            properties.load(GitRepoState.class.getClassLoader().getResourceAsStream("git.properties"));
            this.isLoaded = true;
        }
        catch (NullPointerException e) {
            log.trace("Failed to load git repo information. Did you build with the git gradle plugin? Is the git.properties file present?");
        }
        catch (IOException e) {
            log.info("Failed to load git repo information due to suspicious IOException", (Throwable)e);
        }
        this.branch = properties.getOrDefault((Object)"git.branch", "").toString();
        this.commitId = properties.getOrDefault((Object)"git.commit.id", "").toString();
        this.commitIdAbbrev = properties.getOrDefault((Object)"git.commit.id.abbrev", "").toString();
        this.commitUserName = properties.getOrDefault((Object)"git.commit.user.name", "").toString();
        this.commitUserEmail = properties.getOrDefault((Object)"git.commit.user.email", "").toString();
        this.commitMessageFull = properties.getOrDefault((Object)"git.commit.message.full", "").toString();
        this.commitMessageShort = properties.getOrDefault((Object)"git.commit.message.short", "").toString();
        String time = String.valueOf(properties.get("git.commit.time"));
        if (Intrinsics.areEqual((Object)time, (Object)"null")) {
            l = 0L;
        } else {
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ");
            l = OffsetDateTime.from(dtf.parse(time)).toEpochSecond();
        }
        this.commitTime = l;
    }

    public final long getCommitTime() {
        return this.commitTime;
    }

    @NotNull
    public final String getBranch() {
        return this.branch;
    }

    @NotNull
    public final String getCommitId() {
        return this.commitId;
    }

    @NotNull
    public final String getCommitIdAbbrev() {
        return this.commitIdAbbrev;
    }

    @NotNull
    public final String getCommitUserName() {
        return this.commitUserName;
    }

    @NotNull
    public final String getCommitUserEmail() {
        return this.commitUserEmail;
    }

    @NotNull
    public final String getCommitMessageFull() {
        return this.commitMessageFull;
    }

    @NotNull
    public final String getCommitMessageShort() {
        return this.commitMessageShort;
    }

    public final boolean isLoaded() {
        return this.isLoaded;
    }

    public final void setLoaded(boolean bl) {
        this.isLoaded = bl;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Llavalink/server/info/GitRepoState$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lavalink-Server"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

