/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.io;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import lavalink.server.config.ServerConfig;
import lavalink.server.io.SocketServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;

@Controller
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0018\u00010\u0010j\u0004\u0018\u0001`\u0011H\u0016J4\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Llavalink/server/io/HandshakeInterceptorImpl;", "Lorg/springframework/web/socket/server/HandshakeInterceptor;", "serverConfig", "Llavalink/server/config/ServerConfig;", "socketServer", "Llavalink/server/io/SocketServer;", "(Llavalink/server/config/ServerConfig;Llavalink/server/io/SocketServer;)V", "afterHandshake", "", "request", "Lorg/springframework/http/server/ServerHttpRequest;", "response", "Lorg/springframework/http/server/ServerHttpResponse;", "wsHandler", "Lorg/springframework/web/socket/WebSocketHandler;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "beforeHandshake", "", "attributes", "", "", "", "Companion", "Lavalink-Server"})
public class HandshakeInterceptorImpl
implements HandshakeInterceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ServerConfig serverConfig;
    @NotNull
    private final SocketServer socketServer;
    private static final Logger log = LoggerFactory.getLogger(HandshakeInterceptorImpl.class);

    @Autowired
    public HandshakeInterceptorImpl(@NotNull ServerConfig serverConfig, @NotNull SocketServer socketServer) {
        Intrinsics.checkNotNullParameter((Object)serverConfig, (String)"serverConfig");
        Intrinsics.checkNotNullParameter((Object)((Object)socketServer), (String)"socketServer");
        this.serverConfig = serverConfig;
        this.socketServer = socketServer;
    }

    public boolean beforeHandshake(@NotNull ServerHttpRequest request, @NotNull ServerHttpResponse response, @NotNull WebSocketHandler wsHandler, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)wsHandler, (String)"wsHandler");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        String password = request.getHeaders().getFirst("Authorization");
        if (!Intrinsics.areEqual((Object)password, (Object)this.serverConfig.getPassword())) {
            log.error("Authentication failed from " + request.getRemoteAddress());
            response.setStatusCode(HttpStatus.UNAUTHORIZED);
            return false;
        }
        if (request.getHeaders().getFirst("User-Id") == null) {
            log.error("Missing User-Id header from " + request.getRemoteAddress());
            response.setStatusCode(HttpStatus.BAD_REQUEST);
            return false;
        }
        log.info("Incoming connection from " + request.getRemoteAddress());
        String resumeKey = request.getHeaders().getFirst("Resume-Key");
        boolean resuming = resumeKey != null && this.socketServer.canResume$Lavalink_Server(resumeKey);
        response.getHeaders().add("Session-Resumed", String.valueOf(resuming));
        return true;
    }

    public void afterHandshake(@NotNull ServerHttpRequest request, @NotNull ServerHttpResponse response, @NotNull WebSocketHandler wsHandler, @Nullable Exception exception) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)wsHandler, (String)"wsHandler");
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Llavalink/server/io/HandshakeInterceptorImpl$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lavalink-Server"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

