/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.io;

import com.sedmelluq.lava.extensions.youtuberotator.planner.AbstractRoutePlanner;
import com.sedmelluq.lava.extensions.youtuberotator.planner.NanoIpRoutePlanner;
import com.sedmelluq.lava.extensions.youtuberotator.planner.RotatingIpRoutePlanner;
import com.sedmelluq.lava.extensions.youtuberotator.planner.RotatingNanoIpRoutePlanner;
import com.sedmelluq.lava.extensions.youtuberotator.tools.ip.IpBlock;
import dev.arbjerg.lavalink.protocol.v3.FailingAddress;
import dev.arbjerg.lavalink.protocol.v3.GenericRoutePlannerStatus;
import dev.arbjerg.lavalink.protocol.v3.IRoutePlannerStatus;
import dev.arbjerg.lavalink.protocol.v3.IpBlockStatus;
import dev.arbjerg.lavalink.protocol.v3.NanoIpRoutePlannerStatus;
import dev.arbjerg.lavalink.protocol.v3.RotatingIpRoutePlannerStatus;
import dev.arbjerg.lavalink.protocol.v3.RotatingNanoIpRoutePlannerStatus;
import dev.arbjerg.lavalink.protocol.v3.RoutePlannerFreeAddress;
import dev.arbjerg.lavalink.protocol.v3.RoutePlannerStatus;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001\u0012B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0017J \u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0012J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00062\u0006\u0010\b\u001a\u00020\tH\u0017R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Llavalink/server/io/RoutePlannerRestHandler;", "", "routePlanner", "Lcom/sedmelluq/lava/extensions/youtuberotator/planner/AbstractRoutePlanner;", "(Lcom/sedmelluq/lava/extensions/youtuberotator/planner/AbstractRoutePlanner;)V", "freeAllAddresses", "Lorg/springframework/http/ResponseEntity;", "", "request", "Ljavax/servlet/http/HttpServletRequest;", "freeSingleAddress", "body", "Ldev/arbjerg/lavalink/protocol/v3/RoutePlannerFreeAddress;", "getDetailBlock", "Ldev/arbjerg/lavalink/protocol/v3/IRoutePlannerStatus;", "planner", "getStatus", "Ldev/arbjerg/lavalink/protocol/v3/RoutePlannerStatus;", "RoutePlannerDisabledException", "Lavalink-Server"})
public class RoutePlannerRestHandler {
    @Nullable
    private final AbstractRoutePlanner routePlanner;

    public RoutePlannerRestHandler(@Nullable AbstractRoutePlanner routePlanner) {
        this.routePlanner = routePlanner;
    }

    @GetMapping(value={"/routeplanner/status", "/v3/routeplanner/status"})
    @NotNull
    public ResponseEntity<RoutePlannerStatus> getStatus(@NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        RoutePlannerStatus status = this.routePlanner == null ? new RoutePlannerStatus(null, null) : new RoutePlannerStatus(this.routePlanner.getClass().getSimpleName(), this.getDetailBlock(this.routePlanner));
        ResponseEntity responseEntity = ResponseEntity.ok((Object)status);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(status)");
        return responseEntity;
    }

    @PostMapping(value={"/routeplanner/free/address", "/v3/routeplanner/free/address"})
    @NotNull
    public ResponseEntity<Unit> freeSingleAddress(@NotNull HttpServletRequest request, @RequestBody @NotNull RoutePlannerFreeAddress body) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        if (this.routePlanner == null) {
            throw new RoutePlannerDisabledException();
        }
        try {
            InetAddress address = InetAddress.getByName(body.getAddress());
            this.routePlanner.freeAddress(address);
            ResponseEntity responseEntity = ResponseEntity.noContent().build();
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"noContent().build()");
            return responseEntity;
        }
        catch (UnknownHostException exception) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Invalid address: " + exception.getMessage(), (Throwable)exception);
        }
    }

    @PostMapping(value={"/routeplanner/free/all", "/v3/routeplanner/free/all"})
    @NotNull
    public ResponseEntity<Unit> freeAllAddresses(@NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.routePlanner == null) {
            throw new RoutePlannerDisabledException();
        }
        this.routePlanner.freeAllAddresses();
        ResponseEntity responseEntity = ResponseEntity.noContent().build();
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"noContent().build()");
        return responseEntity;
    }

    /*
     * WARNING - void declaration
     */
    private IRoutePlannerStatus getDetailBlock(AbstractRoutePlanner planner) {
        IRoutePlannerStatus iRoutePlannerStatus;
        void $this$mapTo$iv$iv;
        IpBlock ipBlock = planner.getIpBlock();
        String string = ipBlock.getType().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ipBlock.type.simpleName");
        String string2 = ipBlock.getSize().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ipBlock.size.toString()");
        IpBlockStatus ipBlockStatus = new IpBlockStatus(string, string2);
        Map failingAddresses = planner.getFailingAddresses();
        Iterable $this$map$iv = failingAddresses.entrySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
            String string3 = (String)k;
            Object v = it.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
            long l = ((Number)v).longValue();
            Object v2 = it.getValue();
            Intrinsics.checkNotNullExpressionValue(v2, (String)"it.value");
            String string4 = new Date(((Number)v2).longValue()).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"Date(it.value).toString()");
            collection.add(new FailingAddress(string3, l, string4));
        }
        List failingAddressesStatus = (List)destination$iv$iv;
        AbstractRoutePlanner abstractRoutePlanner = planner;
        if (abstractRoutePlanner instanceof RotatingIpRoutePlanner) {
            String string5 = ((RotatingIpRoutePlanner)planner).getRotateIndex().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"planner.rotateIndex.toString()");
            String string6 = ((RotatingIpRoutePlanner)planner).getIndex().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"planner.index.toString()");
            String string7 = ((RotatingIpRoutePlanner)planner).getCurrentAddress().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"planner.currentAddress.toString()");
            iRoutePlannerStatus = (IRoutePlannerStatus)new RotatingIpRoutePlannerStatus(ipBlockStatus, failingAddressesStatus, string5, string6, string7);
        } else if (abstractRoutePlanner instanceof NanoIpRoutePlanner) {
            iRoutePlannerStatus = (IRoutePlannerStatus)new NanoIpRoutePlannerStatus(ipBlockStatus, failingAddressesStatus, String.valueOf(((NanoIpRoutePlanner)planner).getCurrentAddress()));
        } else if (abstractRoutePlanner instanceof RotatingNanoIpRoutePlanner) {
            String string8 = ((RotatingNanoIpRoutePlanner)planner).getCurrentBlock().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"planner.currentBlock.toString()");
            iRoutePlannerStatus = (IRoutePlannerStatus)new RotatingNanoIpRoutePlannerStatus(ipBlockStatus, failingAddressesStatus, string8, String.valueOf(((RotatingNanoIpRoutePlanner)planner).getAddressIndexInBlock()));
        } else {
            iRoutePlannerStatus = (IRoutePlannerStatus)new GenericRoutePlannerStatus(ipBlockStatus, failingAddressesStatus);
        }
        return iRoutePlannerStatus;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Llavalink/server/io/RoutePlannerRestHandler$RoutePlannerDisabledException;", "Lorg/springframework/web/server/ResponseStatusException;", "()V", "Lavalink-Server"})
    public static final class RoutePlannerDisabledException
    extends ResponseStatusException {
        public RoutePlannerDisabledException() {
            super(HttpStatus.INTERNAL_SERVER_ERROR, "Can't access disabled route planner");
        }
    }
}

