/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.io;

import dev.arbjerg.lavalink.protocol.v3.Omissible;
import dev.arbjerg.lavalink.protocol.v3.Session;
import dev.arbjerg.lavalink.protocol.v3.SessionUpdate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import lavalink.server.io.SocketContext;
import lavalink.server.io.SocketServer;
import lavalink.server.util.UtilKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Llavalink/server/io/SessionRestHandler;", "", "socketServer", "Llavalink/server/io/SocketServer;", "(Llavalink/server/io/SocketServer;)V", "patchSession", "Lorg/springframework/http/ResponseEntity;", "Ldev/arbjerg/lavalink/protocol/v3/Session;", "sessionUpdate", "Ldev/arbjerg/lavalink/protocol/v3/SessionUpdate;", "sessionId", "", "Lavalink-Server"})
public class SessionRestHandler {
    @NotNull
    private final SocketServer socketServer;

    public SessionRestHandler(@NotNull SocketServer socketServer) {
        Intrinsics.checkNotNullParameter((Object)((Object)socketServer), (String)"socketServer");
        this.socketServer = socketServer;
    }

    @PatchMapping(value={"/v3/sessions/{sessionId}"})
    private ResponseEntity<Session> patchSession(@RequestBody SessionUpdate sessionUpdate, @PathVariable String sessionId) {
        SocketContext context = UtilKt.socketContext(this.socketServer, sessionId);
        Omissible $this$takeIfPresent$iv = sessionUpdate.getResumingKey();
        boolean $i$f$takeIfPresent = false;
        if ($this$takeIfPresent$iv.isPresent()) {
            String it = (String)$this$takeIfPresent$iv.getValue();
            boolean bl = false;
            context.setResumeKey(it);
        }
        $this$takeIfPresent$iv = sessionUpdate.getTimeout();
        $i$f$takeIfPresent = false;
        if ($this$takeIfPresent$iv.isPresent()) {
            long it = ((Number)$this$takeIfPresent$iv.getValue()).longValue();
            boolean bl = false;
            context.setResumeTimeout(it);
        }
        ResponseEntity responseEntity = ResponseEntity.ok((Object)new Session(context.getResumeKey(), context.getResumeTimeout()));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(Session(context.resum\u2026, context.resumeTimeout))");
        return responseEntity;
    }
}

