/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.io;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import dev.arbjerg.lavalink.api.AudioFilterExtension;
import dev.arbjerg.lavalink.api.ISocketContext;
import dev.arbjerg.lavalink.api.PluginEventHandler;
import dev.arbjerg.lavalink.api.WebSocketExtension;
import dev.arbjerg.lavalink.protocol.v3.Message;
import io.undertow.websockets.core.WebSocketCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import io.undertow.websockets.jsr.UndertowSession;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import lavalink.server.config.ServerConfig;
import lavalink.server.io.EventEmitter;
import lavalink.server.io.SocketServer;
import lavalink.server.io.StatsCollector;
import lavalink.server.io.WebSocketHandler;
import lavalink.server.player.LavalinkPlayer;
import moe.kyokobot.koe.KoeClient;
import moe.kyokobot.koe.KoeEventAdapter;
import moe.kyokobot.koe.KoeEventListener;
import moe.kyokobot.koe.MediaConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.adapter.standard.StandardWebSocketSession;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 g2\u00020\u0001:\u0002ghB\u0081\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u0012\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001cJ\b\u0010J\u001a\u00020EH\u0016J\u0010\u0010J\u001a\u00020E2\u0006\u0010K\u001a\u00020LH\u0016J\u001a\u0010J\u001a\u00020E2\u0006\u0010K\u001a\u00020L2\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010N\u001a\u00020E2\u0006\u0010O\u001a\u00020,H\u0016J\n\u0010P\u001a\u0004\u0018\u00010\u0003H\u0016J\u000e\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020-J\u0010\u0010T\u001a\u00020-2\u0006\u0010U\u001a\u00020,H\u0016J\u0014\u0010V\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020-0WH\u0016J\b\u0010X\u001a\u00020\u0003H\u0016J\b\u0010Y\u001a\u00020ZH\u0016J\b\u0010[\u001a\u00020,H\u0016J\u0006\u0010\\\u001a\u00020EJ\u000e\u0010]\u001a\u00020E2\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010^\u001a\u00020E2\u0006\u0010_\u001a\u00020\u0003H\u0002J\u0010\u0010`\u001a\u00020E2\u0006\u0010a\u001a\u00020bH\u0016J\u0010\u0010`\u001a\u00020E2\u0006\u0010a\u001a\u00020cH\u0016J\r\u0010d\u001a\u00020EH\u0000\u00a2\u0006\u0002\beJ\u0006\u0010f\u001a\u00020>R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010'\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u001a\u0010*\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020-0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010.\u001a\b\u0012\u0004\u0012\u00020-0\u00168F\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020\u000302X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00103\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001a\u00108\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010=\u001a\u00020>X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u0016\u0010C\u001a\n\u0012\u0004\u0012\u00020E\u0018\u00010DX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010F\u001a\u00020G\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010I\u00a8\u0006i"}, d2={"Llavalink/server/io/SocketContext;", "Ldev/arbjerg/lavalink/api/ISocketContext;", "sessionId", "", "audioPlayerManager", "Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;", "serverConfig", "Llavalink/server/config/ServerConfig;", "session", "Lorg/springframework/web/socket/WebSocketSession;", "socketServer", "Llavalink/server/io/SocketServer;", "statsCollector", "Llavalink/server/io/StatsCollector;", "userId", "clientName", "koe", "Lmoe/kyokobot/koe/KoeClient;", "eventHandlers", "", "Ldev/arbjerg/lavalink/api/PluginEventHandler;", "webSocketExtensions", "", "Ldev/arbjerg/lavalink/api/WebSocketExtension;", "filterExtensions", "Ldev/arbjerg/lavalink/api/AudioFilterExtension;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Ljava/lang/String;Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;Llavalink/server/config/ServerConfig;Lorg/springframework/web/socket/WebSocketSession;Llavalink/server/io/SocketServer;Llavalink/server/io/StatsCollector;Ljava/lang/String;Ljava/lang/String;Lmoe/kyokobot/koe/KoeClient;Ljava/util/Collection;Ljava/util/List;Ljava/util/List;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "getAudioPlayerManager", "()Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;", "eventEmitter", "Llavalink/server/io/EventEmitter;", "getEventEmitter", "()Llavalink/server/io/EventEmitter;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "getKoe", "()Lmoe/kyokobot/koe/KoeClient;", "playerUpdateService", "getPlayerUpdateService", "()Ljava/util/concurrent/ScheduledExecutorService;", "players", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Llavalink/server/player/LavalinkPlayer;", "playingPlayers", "getPlayingPlayers", "()Ljava/util/List;", "resumeEventQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "resumeKey", "getResumeKey", "()Ljava/lang/String;", "setResumeKey", "(Ljava/lang/String;)V", "resumeTimeout", "getResumeTimeout", "()J", "setResumeTimeout", "(J)V", "sessionPaused", "", "getSessionPaused", "()Z", "setSessionPaused", "(Z)V", "sessionTimeoutFuture", "Ljava/util/concurrent/ScheduledFuture;", "", "wsHandler", "Llavalink/server/io/WebSocketHandler;", "getWsHandler", "()Llavalink/server/io/WebSocketHandler;", "closeWebSocket", "closeCode", "", "reason", "destroyPlayer", "guild", "getClientName", "getMediaConnection", "Lmoe/kyokobot/koe/MediaConnection;", "player", "getPlayer", "guildId", "getPlayers", "", "getSessionId", "getState", "Ldev/arbjerg/lavalink/api/ISocketContext$State;", "getUserId", "pause", "resume", "send", "payload", "sendMessage", "message", "", "Lorg/json/JSONObject;", "shutdown", "shutdown$Lavalink_Server", "stopResumeTimeout", "Companion", "WsEventHandler", "Lavalink-Server"})
public final class SocketContext
implements ISocketContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String sessionId;
    @NotNull
    private final AudioPlayerManager audioPlayerManager;
    @NotNull
    private final ServerConfig serverConfig;
    @NotNull
    private WebSocketSession session;
    @NotNull
    private final SocketServer socketServer;
    @NotNull
    private final String userId;
    @Nullable
    private final String clientName;
    @NotNull
    private final KoeClient koe;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final ConcurrentHashMap<Long, LavalinkPlayer> players;
    @NotNull
    private final EventEmitter eventEmitter;
    @NotNull
    private final WebSocketHandler wsHandler;
    private volatile boolean sessionPaused;
    @NotNull
    private final ConcurrentLinkedQueue<String> resumeEventQueue;
    @Nullable
    private String resumeKey;
    private long resumeTimeout;
    @Nullable
    private ScheduledFuture<Unit> sessionTimeoutFuture;
    @NotNull
    private final ScheduledExecutorService executor;
    @NotNull
    private final ScheduledExecutorService playerUpdateService;
    private static final Logger log = LoggerFactory.getLogger(SocketContext.class);

    public SocketContext(@NotNull String sessionId, @NotNull AudioPlayerManager audioPlayerManager, @NotNull ServerConfig serverConfig, @NotNull WebSocketSession session, @NotNull SocketServer socketServer, @NotNull StatsCollector statsCollector, @NotNull String userId, @Nullable String clientName, @NotNull KoeClient koe, @NotNull Collection<? extends PluginEventHandler> eventHandlers, @NotNull List<? extends WebSocketExtension> webSocketExtensions, @NotNull List<? extends AudioFilterExtension> filterExtensions, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)audioPlayerManager, (String)"audioPlayerManager");
        Intrinsics.checkNotNullParameter((Object)serverConfig, (String)"serverConfig");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)((Object)socketServer), (String)"socketServer");
        Intrinsics.checkNotNullParameter((Object)statsCollector, (String)"statsCollector");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)koe, (String)"koe");
        Intrinsics.checkNotNullParameter(eventHandlers, (String)"eventHandlers");
        Intrinsics.checkNotNullParameter(webSocketExtensions, (String)"webSocketExtensions");
        Intrinsics.checkNotNullParameter(filterExtensions, (String)"filterExtensions");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.sessionId = sessionId;
        this.audioPlayerManager = audioPlayerManager;
        this.serverConfig = serverConfig;
        this.session = session;
        this.socketServer = socketServer;
        this.userId = userId;
        this.clientName = clientName;
        this.koe = koe;
        this.objectMapper = objectMapper;
        this.players = new ConcurrentHashMap();
        this.eventEmitter = new EventEmitter(this, eventHandlers);
        this.wsHandler = new WebSocketHandler(this, webSocketExtensions, filterExtensions, this.serverConfig, this.objectMapper);
        this.resumeEventQueue = new ConcurrentLinkedQueue();
        this.resumeTimeout = 60L;
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newSingleThreadScheduledExecutor()");
        this.executor = scheduledExecutorService;
        this.executor.scheduleAtFixedRate(statsCollector.createTask(this), 0L, 1L, TimeUnit.MINUTES);
        ScheduledExecutorService scheduledExecutorService2 = Executors.newScheduledThreadPool(2, SocketContext::_init_$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService2, (String)"newScheduledThreadPool(2\u2026         thread\n        }");
        this.playerUpdateService = scheduledExecutorService2;
    }

    @NotNull
    public final AudioPlayerManager getAudioPlayerManager() {
        return this.audioPlayerManager;
    }

    @NotNull
    public final KoeClient getKoe() {
        return this.koe;
    }

    @NotNull
    public final EventEmitter getEventEmitter() {
        return this.eventEmitter;
    }

    @NotNull
    public final WebSocketHandler getWsHandler() {
        return this.wsHandler;
    }

    public final boolean getSessionPaused() {
        return this.sessionPaused;
    }

    public final void setSessionPaused(boolean bl) {
        this.sessionPaused = bl;
    }

    @Nullable
    public final String getResumeKey() {
        return this.resumeKey;
    }

    public final void setResumeKey(@Nullable String string) {
        this.resumeKey = string;
    }

    public final long getResumeTimeout() {
        return this.resumeTimeout;
    }

    public final void setResumeTimeout(long l) {
        this.resumeTimeout = l;
    }

    @NotNull
    public final ScheduledExecutorService getPlayerUpdateService() {
        return this.playerUpdateService;
    }

    @NotNull
    public final List<LavalinkPlayer> getPlayingPlayers() {
        LinkedList<LavalinkPlayer> newList = new LinkedList<LavalinkPlayer>();
        Collection<LavalinkPlayer> collection = this.players.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"players.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LavalinkPlayer player = (LavalinkPlayer)((Object)element$iv);
            boolean bl = false;
            if (!player.isPlaying()) continue;
            newList.add(player);
        }
        return newList;
    }

    @NotNull
    public String getSessionId() {
        return this.sessionId;
    }

    public long getUserId() {
        return Long.parseLong(this.userId);
    }

    @Nullable
    public String getClientName() {
        return this.clientName;
    }

    @NotNull
    public LavalinkPlayer getPlayer(long guildId) {
        LavalinkPlayer lavalinkPlayer = this.players.computeIfAbsent(guildId, arg_0 -> SocketContext.getPlayer$lambda$2((Function1)new Function1<Long, LavalinkPlayer>(this, guildId){
            final /* synthetic */ SocketContext this$0;
            final /* synthetic */ long $guildId;
            {
                this.this$0 = $receiver;
                this.$guildId = $guildId;
                super(1);
            }

            @NotNull
            public final LavalinkPlayer invoke(@NotNull Long it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                LavalinkPlayer player = new LavalinkPlayer(this.this$0, this.$guildId, SocketContext.access$getServerConfig$p(this.this$0), this.this$0.getAudioPlayerManager());
                this.this$0.getEventEmitter().onNewPlayer(player);
                return player;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)((Object)lavalinkPlayer), (String)"override fun getPlayer(g\u2026yer)\n        player\n    }");
        return lavalinkPlayer;
    }

    @NotNull
    public Map<Long, LavalinkPlayer> getPlayers() {
        return MapsKt.toMap((Map)this.players);
    }

    @NotNull
    public final MediaConnection getMediaConnection(@NotNull LavalinkPlayer player) {
        Intrinsics.checkNotNullParameter((Object)((Object)player), (String)"player");
        long guildId = player.getGuildId();
        MediaConnection conn = this.koe.getConnection(guildId);
        if (conn == null) {
            conn = this.koe.createConnection(guildId);
            conn.registerListener((KoeEventListener)new WsEventHandler(player));
        }
        return conn;
    }

    public void destroyPlayer(long guild) {
        LavalinkPlayer player = this.players.remove(guild);
        if (player != null) {
            this.eventEmitter.onDestroyPlayer(player);
            player.destroy();
        }
        this.koe.destroyConnection(guild);
    }

    public final void pause() {
        this.sessionPaused = true;
        this.sessionTimeoutFuture = this.executor.schedule(() -> SocketContext.pause$lambda$3(this), this.resumeTimeout, TimeUnit.SECONDS);
        this.eventEmitter.onSocketContextPaused();
    }

    public void sendMessage(@NotNull JSONObject message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String string = message.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message.toString()");
        this.send(string);
    }

    public void sendMessage(@NotNull Object message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String string = this.objectMapper.writeValueAsString(message);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"objectMapper.writeValueAsString(message)");
        this.send(string);
    }

    @NotNull
    public ISocketContext.State getState() {
        return this.session.isOpen() ? ISocketContext.State.OPEN : (this.sessionPaused ? ISocketContext.State.RESUMABLE : ISocketContext.State.DESTROYED);
    }

    private final void send(String payload) {
        this.eventEmitter.onWebSocketMessageOut(payload);
        if (this.sessionPaused) {
            this.resumeEventQueue.add(payload);
            return;
        }
        if (!this.session.isOpen()) {
            return;
        }
        WebSocketSession webSocketSession = this.session;
        Intrinsics.checkNotNull((Object)webSocketSession, (String)"null cannot be cast to non-null type org.springframework.web.socket.adapter.standard.StandardWebSocketSession");
        Object object = ((StandardWebSocketSession)webSocketSession).getNativeSession();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type io.undertow.websockets.jsr.UndertowSession");
        UndertowSession undertowSession = (UndertowSession)object;
        WebSockets.sendText((String)payload, (WebSocketChannel)undertowSession.getWebSocketChannel(), (WebSocketCallback)((WebSocketCallback)new WebSocketCallback<Void>(payload){
            final /* synthetic */ String $payload;
            {
                this.$payload = $payload;
            }

            public void complete(@NotNull WebSocketChannel channel, @Nullable Void context) {
                Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                SocketContext.access$getLog$cp().trace("Sent " + this.$payload);
            }

            public void onError(@NotNull WebSocketChannel channel, @Nullable Void context, @NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                SocketContext.access$getLog$cp().error("Error", throwable);
            }
        }));
    }

    public final boolean stopResumeTimeout() {
        ScheduledFuture<Unit> scheduledFuture = this.sessionTimeoutFuture;
        return scheduledFuture != null ? scheduledFuture.cancel(false) : false;
    }

    public final void resume(@NotNull WebSocketSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.sessionPaused = false;
        this.session = session;
        this.sendMessage(new Message.ReadyEvent(true, this.sessionId));
        log.info("Replaying " + this.resumeEventQueue.size() + " events");
        while (!((Collection)this.resumeEventQueue).isEmpty()) {
            Object e = this.resumeEventQueue.remove();
            Intrinsics.checkNotNullExpressionValue(e, (String)"resumeEventQueue.remove()");
            this.send((String)e);
        }
        Collection<LavalinkPlayer> collection = this.players.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"players.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LavalinkPlayer it = (LavalinkPlayer)((Object)element$iv);
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)it), (String)"it");
            SocketServer.Companion.sendPlayerUpdate(this, it);
        }
    }

    public final void shutdown$Lavalink_Server() {
        log.info("Shutting down " + this.getPlayingPlayers().size() + " playing players.");
        this.executor.shutdown();
        this.playerUpdateService.shutdown();
        Collection<LavalinkPlayer> collection = this.players.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"players.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LavalinkPlayer it = (LavalinkPlayer)((Object)element$iv);
            boolean bl = false;
            this.destroyPlayer(it.getGuildId());
        }
        this.koe.close();
        this.eventEmitter.onSocketContextDestroyed();
    }

    public void closeWebSocket(int closeCode, @Nullable String reason) {
        this.session.close(new CloseStatus(closeCode, reason));
    }

    public void closeWebSocket(int closeCode) {
        this.closeWebSocket(closeCode, null);
    }

    public void closeWebSocket() {
        this.session.close();
    }

    private static final Thread _init_$lambda$1(Runnable r) {
        Thread thread = new Thread(r);
        thread.setName("player-update");
        thread.setDaemon(true);
        return thread;
    }

    private static final LavalinkPlayer getPlayer$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (LavalinkPlayer)((Object)$tmp0.invoke(p0));
    }

    private static final Unit pause$lambda$3(SocketContext this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.socketServer.onSessionResumeTimeout$Lavalink_Server(this$0);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ ServerConfig access$getServerConfig$p(SocketContext $this) {
        return $this.serverConfig;
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Llavalink/server/io/SocketContext$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lavalink-Server"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Llavalink/server/io/SocketContext$WsEventHandler;", "Lmoe/kyokobot/koe/KoeEventAdapter;", "player", "Llavalink/server/player/LavalinkPlayer;", "(Llavalink/server/io/SocketContext;Llavalink/server/player/LavalinkPlayer;)V", "gatewayClosed", "", "code", "", "reason", "", "byRemote", "", "gatewayReady", "target", "Ljava/net/InetSocketAddress;", "ssrc", "Lavalink-Server"})
    private final class WsEventHandler
    extends KoeEventAdapter {
        @NotNull
        private final LavalinkPlayer player;

        public WsEventHandler(LavalinkPlayer player) {
            Intrinsics.checkNotNullParameter((Object)((Object)player), (String)"player");
            this.player = player;
        }

        public void gatewayClosed(int code, @Nullable String reason, boolean byRemote) {
            String string = reason;
            if (string == null) {
                string = "";
            }
            Message.WebSocketClosedEvent event = new Message.WebSocketClosedEvent(code, string, byRemote, String.valueOf(this.player.getGuildId()));
            SocketContext.this.sendMessage(event);
            SocketServer.Companion.sendPlayerUpdate(SocketContext.this, this.player);
        }

        public void gatewayReady(@Nullable InetSocketAddress target, int ssrc) {
            SocketServer.Companion.sendPlayerUpdate(SocketContext.this, this.player);
        }
    }
}

