/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.io;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.arbjerg.lavalink.api.AudioFilterExtension;
import dev.arbjerg.lavalink.api.PluginEventHandler;
import dev.arbjerg.lavalink.api.WebSocketExtension;
import dev.arbjerg.lavalink.protocol.v3.Message;
import dev.arbjerg.lavalink.protocol.v3.PlayerState;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.random.Random;
import kotlin.ranges.CharRange;
import lavalink.server.config.ServerConfig;
import lavalink.server.io.EventEmitter;
import lavalink.server.io.SocketContext;
import lavalink.server.io.StatsCollector;
import lavalink.server.player.LavalinkPlayer;
import moe.kyokobot.koe.Koe;
import moe.kyokobot.koe.KoeClient;
import moe.kyokobot.koe.KoeOptions;
import moe.kyokobot.koe.gateway.MediaGatewayConnection;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 82\u00020\u0001:\u00018BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u0015\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0018H\u0010\u00a2\u0006\u0002\b0J\b\u00101\u001a\u00020\u0018H\u0012J\u0018\u00102\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u00103\u001a\u000204H\u0014J\u0015\u00105\u001a\u00020'2\u0006\u00106\u001a\u00020\u0019H\u0010\u00a2\u0006\u0002\b7R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190#X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Llavalink/server/io/SocketServer;", "Lorg/springframework/web/socket/handler/TextWebSocketHandler;", "serverConfig", "Llavalink/server/config/ServerConfig;", "audioPlayerManager", "Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;", "koeOptions", "Lmoe/kyokobot/koe/KoeOptions;", "eventHandlers", "", "Ldev/arbjerg/lavalink/api/PluginEventHandler;", "webSocketExtensions", "Ldev/arbjerg/lavalink/api/WebSocketExtension;", "filterExtensions", "Ldev/arbjerg/lavalink/api/AudioFilterExtension;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Llavalink/server/config/ServerConfig;Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;Lmoe/kyokobot/koe/KoeOptions;Ljava/util/List;Ljava/util/List;Ljava/util/List;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "getAudioPlayerManager", "()Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;", "charPool", "", "contextMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Llavalink/server/io/SocketContext;", "getContextMap", "()Ljava/util/concurrent/ConcurrentHashMap;", "contexts", "", "getContexts", "()Ljava/util/Collection;", "koe", "Lmoe/kyokobot/koe/Koe;", "resumableSessions", "", "statsCollector", "Llavalink/server/io/StatsCollector;", "afterConnectionClosed", "", "session", "Lorg/springframework/web/socket/WebSocketSession;", "status", "Lorg/springframework/web/socket/CloseStatus;", "afterConnectionEstablished", "canResume", "", "key", "canResume$Lavalink_Server", "generateUniqueSessionId", "handleTextMessage", "message", "Lorg/springframework/web/socket/TextMessage;", "onSessionResumeTimeout", "context", "onSessionResumeTimeout$Lavalink_Server", "Companion", "Lavalink-Server"})
public class SocketServer
extends TextWebSocketHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ServerConfig serverConfig;
    @NotNull
    private final AudioPlayerManager audioPlayerManager;
    @NotNull
    private final List<PluginEventHandler> eventHandlers;
    @NotNull
    private final List<WebSocketExtension> webSocketExtensions;
    @NotNull
    private final List<AudioFilterExtension> filterExtensions;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final ConcurrentHashMap<String, SocketContext> contextMap;
    @NotNull
    private final Map<String, SocketContext> resumableSessions;
    @NotNull
    private final Koe koe;
    @NotNull
    private final StatsCollector statsCollector;
    @NotNull
    private final List<Character> charPool;
    private static final Logger log = LoggerFactory.getLogger(SocketServer.class);

    public SocketServer(@NotNull ServerConfig serverConfig, @NotNull AudioPlayerManager audioPlayerManager, @NotNull KoeOptions koeOptions, @NotNull List<? extends PluginEventHandler> eventHandlers, @NotNull List<? extends WebSocketExtension> webSocketExtensions, @NotNull List<? extends AudioFilterExtension> filterExtensions, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)serverConfig, (String)"serverConfig");
        Intrinsics.checkNotNullParameter((Object)audioPlayerManager, (String)"audioPlayerManager");
        Intrinsics.checkNotNullParameter((Object)koeOptions, (String)"koeOptions");
        Intrinsics.checkNotNullParameter(eventHandlers, (String)"eventHandlers");
        Intrinsics.checkNotNullParameter(webSocketExtensions, (String)"webSocketExtensions");
        Intrinsics.checkNotNullParameter(filterExtensions, (String)"filterExtensions");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.serverConfig = serverConfig;
        this.audioPlayerManager = audioPlayerManager;
        this.eventHandlers = eventHandlers;
        this.webSocketExtensions = webSocketExtensions;
        this.filterExtensions = filterExtensions;
        this.objectMapper = objectMapper;
        this.contextMap = new ConcurrentHashMap();
        this.resumableSessions = new LinkedHashMap();
        Koe koe = Koe.koe((KoeOptions)koeOptions);
        Intrinsics.checkNotNullExpressionValue((Object)koe, (String)"koe(koeOptions)");
        this.koe = koe;
        this.statsCollector = new StatsCollector(this);
        this.charPool = CollectionsKt.plus((Iterable)((Iterable)new CharRange('a', 'z')), (Iterable)((Iterable)new CharRange('0', '9')));
    }

    @NotNull
    public AudioPlayerManager getAudioPlayerManager() {
        return this.audioPlayerManager;
    }

    @NotNull
    public ConcurrentHashMap<String, SocketContext> getContextMap() {
        return this.contextMap;
    }

    private String generateUniqueSessionId() {
        String sessionId = null;
        do {
            int n = 16;
            ArrayList<Character> arrayList = new ArrayList<Character>(n);
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4 = n3 = n2++;
                ArrayList<Character> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add(Character.valueOf(((Character)CollectionsKt.random((Collection)this.charPool, (Random)((Random)Random.Default))).charValue()));
            }
            sessionId = CollectionsKt.joinToString$default((Iterable)arrayList, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        } while (this.getContextMap().get(sessionId) != null);
        return sessionId;
    }

    @NotNull
    public Collection<SocketContext> getContexts() {
        Collection<SocketContext> collection = this.getContextMap().values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"contextMap.values");
        return collection;
    }

    public void afterConnectionEstablished(@NotNull WebSocketSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        String string = session.getHandshakeHeaders().getFirst("User-Id");
        Intrinsics.checkNotNull((Object)string);
        String userId = string;
        String resumeKey = session.getHandshakeHeaders().getFirst("Resume-Key");
        String clientName = session.getHandshakeHeaders().getFirst("Client-Name");
        String userAgent = session.getHandshakeHeaders().getFirst("User-Agent");
        SocketContext resumable = null;
        if (resumeKey != null) {
            resumable = this.resumableSessions.remove(resumeKey);
        }
        if (resumable != null) {
            Map map = session.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"session.attributes");
            Map map2 = map;
            String string2 = "sessionId";
            String string3 = resumable.getSessionId();
            map2.put(string2, string3);
            ((Map)this.getContextMap()).put(resumable.getSessionId(), resumable);
            resumable.resume(session);
            log.info("Resumed session with key " + resumeKey);
            resumable.getEventEmitter().onWebSocketOpen(true);
            return;
        }
        String sessionId = this.generateUniqueSessionId();
        Map map = session.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"session.attributes");
        Map map3 = map;
        map3.put("sessionId", sessionId);
        AudioPlayerManager audioPlayerManager = this.getAudioPlayerManager();
        KoeClient koeClient = this.koe.newClient(Long.parseLong(userId));
        Intrinsics.checkNotNullExpressionValue((Object)koeClient, (String)"koe.newClient(userId.toLong())");
        SocketContext socketContext = new SocketContext(sessionId, audioPlayerManager, this.serverConfig, session, this, this.statsCollector, userId, clientName, koeClient, (Collection<? extends PluginEventHandler>)this.eventHandlers, this.webSocketExtensions, this.filterExtensions, this.objectMapper);
        ((Map)this.getContextMap()).put(sessionId, socketContext);
        socketContext.sendMessage(new Message.ReadyEvent(false, sessionId));
        socketContext.getEventEmitter().onWebSocketOpen(false);
        if (clientName != null) {
            log.info("Connection successfully established from " + clientName);
            return;
        }
        log.info("Connection successfully established");
        if (userAgent != null) {
            log.warn("Library developers: Please specify a 'Client-Name' header. User agent: " + userAgent);
        } else {
            log.warn("Library developers: Please specify a 'Client-Name' header.");
        }
    }

    public void afterConnectionClosed(@NotNull WebSocketSession session, @NotNull CloseStatus status) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Map map = this.getContextMap();
        Object v = session.getAttributes().get("sessionId");
        SocketContext socketContext = (SocketContext)TypeIntrinsics.asMutableMap((Object)map).remove(v);
        if (socketContext == null) {
            return;
        }
        SocketContext context = socketContext;
        if (context.getResumeKey() != null) {
            String string = context.getResumeKey();
            Intrinsics.checkNotNull((Object)string);
            SocketContext socketContext2 = this.resumableSessions.remove(string);
            if (socketContext2 != null) {
                SocketContext removed = socketContext2;
                boolean bl = false;
                log.warn("Shutdown resumable session with key " + removed.getResumeKey() + " because it has the same key as a newly disconnected resumable session.");
                removed.shutdown$Lavalink_Server();
            }
            String string2 = context.getResumeKey();
            Intrinsics.checkNotNull((Object)string2);
            this.resumableSessions.put(string2, context);
            context.pause();
            log.info("Connection closed from " + session.getRemoteAddress() + " with status " + status + " -- Session can be resumed within the next " + context.getResumeTimeout() + " seconds with key " + context.getResumeKey());
            return;
        }
        log.info("Connection closed from " + session.getRemoteAddress() + " -- " + status);
        context.shutdown$Lavalink_Server();
    }

    protected void handleTextMessage(@NotNull WebSocketSession session, @NotNull TextMessage message) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        JSONObject json = new JSONObject((String)message.getPayload());
        log.info((String)message.getPayload());
        if (!session.isOpen()) {
            InetSocketAddress inetSocketAddress = session.getRemoteAddress();
            Intrinsics.checkNotNull((Object)inetSocketAddress);
            log.error("Ignoring closing websocket: " + inetSocketAddress);
            return;
        }
        SocketContext socketContext = (SocketContext)((Map)this.getContextMap()).get(session.getAttributes().get("sessionId"));
        if (socketContext == null) {
            throw new IllegalStateException("No context for session ID " + session.getId() + ". Broken websocket?");
        }
        SocketContext context = socketContext;
        EventEmitter eventEmitter = context.getEventEmitter();
        Object object = message.getPayload();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"message.payload");
        eventEmitter.onWebsocketMessageIn((String)object);
        context.getWsHandler().handle(json);
    }

    public void onSessionResumeTimeout$Lavalink_Server(@NotNull SocketContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Map<String, SocketContext> map = this.resumableSessions;
        String string = context.getResumeKey();
        TypeIntrinsics.asMutableMap(map).remove(string);
        context.shutdown$Lavalink_Server();
    }

    public boolean canResume$Lavalink_Server(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SocketContext socketContext = this.resumableSessions.get(key);
        return socketContext != null ? socketContext.stopResumeTimeout() : false;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Llavalink/server/io/SocketServer$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "sendPlayerUpdate", "", "socketContext", "Llavalink/server/io/SocketContext;", "player", "Llavalink/server/player/LavalinkPlayer;", "Lavalink-Server"})
    public static final class Companion {
        private Companion() {
        }

        public final void sendPlayerUpdate(@NotNull SocketContext socketContext, @NotNull LavalinkPlayer player) {
            Intrinsics.checkNotNullParameter((Object)socketContext, (String)"socketContext");
            Intrinsics.checkNotNullParameter((Object)((Object)player), (String)"player");
            if (socketContext.getSessionPaused()) {
                return;
            }
            MediaGatewayConnection connection = socketContext.getMediaConnection(player).getGatewayConnection();
            AudioTrack audioTrack = player.getAudioPlayer().getPlayingTrack();
            MediaGatewayConnection mediaGatewayConnection = connection;
            MediaGatewayConnection mediaGatewayConnection2 = connection;
            socketContext.sendMessage(new Message.PlayerUpdateEvent(new PlayerState(System.currentTimeMillis(), audioTrack != null ? audioTrack.getPosition() : 0L, mediaGatewayConnection != null ? mediaGatewayConnection.isOpen() : false, mediaGatewayConnection2 != null ? mediaGatewayConnection2.getPing() : -1L), String.valueOf(player.getGuildId())));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

