/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.io;

import dev.arbjerg.lavalink.protocol.v3.Cpu;
import dev.arbjerg.lavalink.protocol.v3.FrameStats;
import dev.arbjerg.lavalink.protocol.v3.Memory;
import dev.arbjerg.lavalink.protocol.v3.Message;
import dev.arbjerg.lavalink.protocol.v3.Stats;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import lavalink.server.Launcher;
import lavalink.server.io.SocketContext;
import lavalink.server.io.SocketServer;
import lavalink.server.player.AudioLossCounter;
import lavalink.server.player.LavalinkPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import oshi.SystemInfo;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;

@RestController
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0017J\u0014\u0010\u0013\u001a\u00020\u00122\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u00068RX\u0092\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0006X\u0092\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Llavalink/server/io/StatsCollector;", "", "socketServer", "Llavalink/server/io/SocketServer;", "(Llavalink/server/io/SocketServer;)V", "cpuTime", "", "processRecentCpuUsage", "getProcessRecentCpuUsage", "()D", "getSocketServer", "()Llavalink/server/io/SocketServer;", "uptime", "createTask", "Ljava/lang/Runnable;", "context", "Llavalink/server/io/SocketContext;", "getStats", "Ldev/arbjerg/lavalink/protocol/v3/Stats;", "retrieveStats", "Companion", "Lavalink-Server"})
public class StatsCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SocketServer socketServer;
    private double uptime;
    private double cpuTime;
    private static final Logger log = LoggerFactory.getLogger(StatsCollector.class);
    @NotNull
    private static final SystemInfo si = new SystemInfo();
    @Nullable
    private static long[] prevTicks;

    public StatsCollector(@NotNull SocketServer socketServer) {
        Intrinsics.checkNotNullParameter((Object)((Object)socketServer), (String)"socketServer");
        this.socketServer = socketServer;
    }

    @NotNull
    public SocketServer getSocketServer() {
        return this.socketServer;
    }

    private double getProcessRecentCpuUsage() {
        double d;
        OSProcess p = StatsCollector.Companion.getOs().getProcess(StatsCollector.Companion.getOs().getProcessId());
        if (!(this.cpuTime == 0.0)) {
            double uptimeDiff = (double)p.getUpTime() - this.uptime;
            double cpuDiff = (double)(p.getKernelTime() + p.getUserTime()) - this.cpuTime;
            d = cpuDiff / uptimeDiff;
        } else {
            d = (double)(p.getKernelTime() + p.getUserTime()) / (double)p.getUserTime();
        }
        double output = d;
        this.uptime = p.getUpTime();
        this.cpuTime = p.getKernelTime() + p.getUserTime();
        return output / (double)StatsCollector.Companion.getHal().getProcessor().getLogicalProcessorCount();
    }

    @NotNull
    public Runnable createTask(@NotNull SocketContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return () -> StatsCollector.createTask$lambda$0(this, context);
    }

    @GetMapping(value={"/v3/stats"})
    @NotNull
    public Stats getStats() {
        return StatsCollector.retrieveStats$default(this, null, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Stats retrieveStats(@Nullable SocketContext context) {
        void it;
        int[] nArray = new int[]{0};
        int[] playersTotal = nArray;
        int[] nArray2 = new int[]{0};
        int[] playersPlaying = nArray2;
        Iterable $this$forEach$iv = this.getSocketServer().getContexts();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SocketContext socketContext = (SocketContext)element$iv;
            boolean bl = false;
            playersTotal[0] = playersTotal[0] + socketContext.getPlayers().size();
            playersPlaying[0] = playersPlaying[0] + socketContext.getPlayingPlayers().size();
        }
        long uptime = System.currentTimeMillis() - Launcher.INSTANCE.getStartTime();
        Runtime runtime = Runtime.getRuntime();
        Memory mem = new Memory(runtime.freeMemory(), runtime.totalMemory() - runtime.freeMemory(), runtime.totalMemory(), runtime.maxMemory());
        if (prevTicks == null) {
            prevTicks = StatsCollector.Companion.getHal().getProcessor().getSystemCpuLoadTicks();
        }
        Double d = this.getProcessRecentCpuUsage();
        double d2 = ((Number)d).doubleValue();
        double d3 = StatsCollector.Companion.getHal().getProcessor().getSystemCpuLoadBetweenTicks(prevTicks);
        int n = runtime.availableProcessors();
        boolean bl = false;
        void var14_21 = it;
        boolean bl2 = !Double.isInfinite((double)var14_21) && !Double.isNaN((double)var14_21);
        Double d4 = bl2 ? d : null;
        double d5 = d4 != null ? d4 : 0.0;
        double d6 = d3;
        int n2 = n;
        Cpu cpu = new Cpu(n2, d6, d5);
        prevTicks = StatsCollector.Companion.getHal().getProcessor().getSystemCpuLoadTicks();
        FrameStats frameStats = null;
        if (context != null) {
            int playerCount = 0;
            int totalSent = 0;
            int totalNulled = 0;
            for (LavalinkPlayer player : context.getPlayingPlayers()) {
                AudioLossCounter counter = player.getAudioLossCounter();
                if (!counter.isDataUsable()) continue;
                ++playerCount;
                totalSent += counter.getLastMinuteSuccess();
                totalNulled += counter.getLastMinuteLoss();
            }
            if (playerCount != 0) {
                int totalDeficit = playerCount * 3000 - (totalSent + totalNulled);
                frameStats = new FrameStats(totalSent / playerCount, totalNulled / playerCount, totalDeficit / playerCount);
            }
        }
        return new Stats(frameStats, playersTotal[0], playersPlaying[0], uptime, mem, cpu);
    }

    public static /* synthetic */ Stats retrieveStats$default(StatsCollector statsCollector, SocketContext socketContext, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: retrieveStats");
        }
        if ((n & 1) != 0) {
            socketContext = null;
        }
        return statsCollector.retrieveStats(socketContext);
    }

    private static final void createTask$lambda$0(StatsCollector this$0, SocketContext $context) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        try {
            Stats stats = this$0.retrieveStats($context);
            $context.sendMessage(new Message.StatsEvent(stats));
        }
        catch (Exception e) {
            log.error("Exception while sending stats", (Throwable)e);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u000b0\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Llavalink/server/io/StatsCollector$Companion;", "", "()V", "hal", "Loshi/hardware/HardwareAbstractionLayer;", "kotlin.jvm.PlatformType", "getHal", "()Loshi/hardware/HardwareAbstractionLayer;", "log", "Lorg/slf4j/Logger;", "os", "Loshi/software/os/OperatingSystem;", "getOs", "()Loshi/software/os/OperatingSystem;", "prevTicks", "", "si", "Loshi/SystemInfo;", "Lavalink-Server"})
    public static final class Companion {
        private Companion() {
        }

        private final HardwareAbstractionLayer getHal() {
            return si.getHardware();
        }

        private final OperatingSystem getOs() {
            return si.getOperatingSystem();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

