/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.io;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.TrackMarker;
import com.sedmelluq.discord.lavaplayer.track.TrackMarkerHandler;
import dev.arbjerg.lavalink.api.AudioFilterExtension;
import dev.arbjerg.lavalink.api.ISocketContext;
import dev.arbjerg.lavalink.api.WebSocketExtension;
import dev.arbjerg.lavalink.protocol.v3.Filters;
import dev.arbjerg.lavalink.protocol.v3.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import lavalink.server.config.ServerConfig;
import lavalink.server.io.SocketContext;
import lavalink.server.io.SocketServer;
import lavalink.server.player.LavalinkPlayer;
import lavalink.server.player.TrackEndMarkerHandler;
import lavalink.server.player.filters.Band;
import lavalink.server.player.filters.EqualizerConfig;
import lavalink.server.player.filters.FilterChain;
import moe.kyokobot.koe.MediaConnection;
import moe.kyokobot.koe.VoiceServerInfo;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\u0018\u0000 $2\u00020\u0001:\u0001$B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J\u000e\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0013J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Llavalink/server/io/WebSocketHandler;", "", "context", "Llavalink/server/io/SocketContext;", "wsExtensions", "", "Ldev/arbjerg/lavalink/api/WebSocketExtension;", "filterExtensions", "Ldev/arbjerg/lavalink/api/AudioFilterExtension;", "serverConfig", "Llavalink/server/config/ServerConfig;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Llavalink/server/io/SocketContext;Ljava/util/List;Ljava/util/List;Llavalink/server/config/ServerConfig;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "disabledFilters", "", "handlers", "", "Lkotlin/Function1;", "Lorg/json/JSONObject;", "", "loggedEqualizerDeprecationWarning", "", "loggedWsCommandsDeprecationWarning", "configureResuming", "json", "destroy", "equalizer", "filters", "handle", "pause", "play", "seek", "stop", "voiceUpdate", "volume", "Companion", "Lavalink-Server"})
public final class WebSocketHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SocketContext context;
    @NotNull
    private final List<AudioFilterExtension> filterExtensions;
    @NotNull
    private final ObjectMapper objectMapper;
    private boolean loggedEqualizerDeprecationWarning;
    private boolean loggedWsCommandsDeprecationWarning;
    @NotNull
    private final Map<String, Function1<JSONObject, Unit>> handlers;
    @NotNull
    private final List<String> disabledFilters;
    @NotNull
    private static final Logger log;

    /*
     * WARNING - void declaration
     */
    public WebSocketHandler(@NotNull SocketContext context, @NotNull List<? extends WebSocketExtension> wsExtensions, @NotNull List<? extends AudioFilterExtension> filterExtensions, @NotNull ServerConfig serverConfig, @NotNull ObjectMapper objectMapper) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map.Entry it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(wsExtensions, (String)"wsExtensions");
        Intrinsics.checkNotNullParameter(filterExtensions, (String)"filterExtensions");
        Intrinsics.checkNotNullParameter((Object)serverConfig, (String)"serverConfig");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.context = context;
        this.filterExtensions = filterExtensions;
        this.objectMapper = objectMapper;
        Object object = new Pair[]{TuplesKt.to((Object)"voiceUpdate", (Object)new Function1<JSONObject, Unit>((Object)this){

            public final void invoke(@NotNull JSONObject p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                WebSocketHandler.access$voiceUpdate((WebSocketHandler)this.receiver, p0);
            }
        }), TuplesKt.to((Object)"play", (Object)new Function1<JSONObject, Unit>((Object)this){

            public final void invoke(@NotNull JSONObject p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                WebSocketHandler.access$play((WebSocketHandler)this.receiver, p0);
            }
        }), TuplesKt.to((Object)"stop", (Object)new Function1<JSONObject, Unit>((Object)this){

            public final void invoke(@NotNull JSONObject p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                WebSocketHandler.access$stop((WebSocketHandler)this.receiver, p0);
            }
        }), TuplesKt.to((Object)"pause", (Object)new Function1<JSONObject, Unit>((Object)this){

            public final void invoke(@NotNull JSONObject p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                WebSocketHandler.access$pause((WebSocketHandler)this.receiver, p0);
            }
        }), TuplesKt.to((Object)"seek", (Object)new Function1<JSONObject, Unit>((Object)this){

            public final void invoke(@NotNull JSONObject p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                WebSocketHandler.access$seek((WebSocketHandler)this.receiver, p0);
            }
        }), TuplesKt.to((Object)"volume", (Object)new Function1<JSONObject, Unit>((Object)this){

            public final void invoke(@NotNull JSONObject p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                WebSocketHandler.access$volume((WebSocketHandler)this.receiver, p0);
            }
        }), TuplesKt.to((Object)"equalizer", (Object)new Function1<JSONObject, Unit>((Object)this){

            public final void invoke(@NotNull JSONObject p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                WebSocketHandler.access$equalizer((WebSocketHandler)this.receiver, p0);
            }
        }), TuplesKt.to((Object)"filters", (Object)new Function1<JSONObject, Unit>((Object)this){

            public final void invoke(@NotNull JSONObject p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                WebSocketHandler.access$filters((WebSocketHandler)this.receiver, p0);
            }
        }), TuplesKt.to((Object)"destroy", (Object)new Function1<JSONObject, Unit>((Object)this){

            public final void invoke(@NotNull JSONObject p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                WebSocketHandler.access$destroy((WebSocketHandler)this.receiver, p0);
            }
        }), TuplesKt.to((Object)"configureResuming", (Object)new Function1<JSONObject, Unit>((Object)this){

            public final void invoke(@NotNull JSONObject p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                WebSocketHandler.access$configureResuming((WebSocketHandler)this.receiver, p0);
            }
        })};
        Map map = MapsKt.mutableMapOf((Pair[])object);
        object = wsExtensions;
        Object object2 = map;
        WebSocketHandler webSocketHandler = this;
        boolean $i$f$associate = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var9_12 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            WebSocketExtension it2 = (WebSocketExtension)element$iv$iv;
            boolean bl = false;
            Pair<String, Function1<JSONObject, Unit>> pair = Companion.toHandler(it2, this.context);
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map map3 = destination$iv$iv;
        webSocketHandler.handlers = MapsKt.plus((Map)object2, (Map)map3);
        $this$associate$iv = serverConfig.getFilters().entrySet();
        webSocketHandler = this;
        boolean $i$f$filter = false;
        void capacity$iv22 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!((Boolean)it.getValue() == false)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl = false;
            object2.add((String)it.getKey());
        }
        webSocketHandler.disabledFilters = (List)destination$iv$iv2;
    }

    public final void handle(@NotNull JSONObject json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        if (!this.loggedWsCommandsDeprecationWarning) {
            log.warn("Sending websocket commands to Lavalink has been deprecated and will be removed in API version 4. API version 3 will be removed in Lavalink 5. Please use the new REST endpoints instead.");
            this.loggedWsCommandsDeprecationWarning = true;
        }
        String op = json.getString("op");
        Function1<JSONObject, Unit> function1 = this.handlers.get(op);
        if (function1 == null) {
            log.warn("Unknown op '" + op + "'");
            return;
        }
        Function1<JSONObject, Unit> handler = function1;
        handler.invoke((Object)json);
    }

    private final void voiceUpdate(JSONObject json) {
        String sessionId = json.getString("sessionId");
        long guildId = json.getLong("guildId");
        JSONObject event = json.getJSONObject("event");
        String endpoint = event.optString("endpoint");
        String string = event.getString("token");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.getString(\"token\")");
        String token = string;
        if (endpoint == null) {
            return;
        }
        this.context.getKoe().destroyConnection(guildId);
        LavalinkPlayer player = this.context.getPlayer(guildId);
        MediaConnection conn = this.context.getMediaConnection(player);
        conn.connect(new VoiceServerInfo(sessionId, endpoint, token)).whenComplete((arg_0, arg_1) -> WebSocketHandler.voiceUpdate$lambda$3((Function2)new Function2<Void, Throwable, Unit>(player, conn){
            final /* synthetic */ LavalinkPlayer $player;
            final /* synthetic */ MediaConnection $conn;
            {
                this.$player = $player;
                this.$conn = $conn;
                super(2);
            }

            public final void invoke(Void void_, Throwable throwable) {
                this.$player.provideTo(this.$conn);
            }
        }, arg_0, arg_1));
    }

    private final void play(JSONObject json) {
        long stopTime;
        LavalinkPlayer player = this.context.getPlayer(json.getLong("guildId"));
        boolean noReplace = json.optBoolean("noReplace", false);
        if (noReplace && player.getTrack() != null) {
            log.info("Skipping play request because of noReplace");
            return;
        }
        AudioPlayerManager audioPlayerManager = this.context.getAudioPlayerManager();
        String string = json.getString("track");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"json.getString(\"track\")");
        AudioTrack track2 = UtilKt.decodeTrack((AudioPlayerManager)audioPlayerManager, (String)string);
        if (json.has("startTime")) {
            track2.setPosition(json.getLong("startTime"));
        }
        player.setPause(json.optBoolean("pause", false));
        if (json.has("volume")) {
            player.setVolume(json.getInt("volume"));
        }
        if (json.has("endTime") && (stopTime = json.getLong("endTime")) > 0L) {
            TrackEndMarkerHandler handler = new TrackEndMarkerHandler(player);
            TrackMarker marker = new TrackMarker(stopTime, (TrackMarkerHandler)handler);
            track2.setMarker(marker);
        }
        player.play(track2);
        MediaConnection conn = this.context.getMediaConnection(player);
        this.context.getPlayer(json.getLong("guildId")).provideTo(conn);
    }

    private final void stop(JSONObject json) {
        LavalinkPlayer player = this.context.getPlayer(json.getLong("guildId"));
        player.stop();
    }

    private final void pause(JSONObject json) {
        LavalinkPlayer player = this.context.getPlayer(json.getLong("guildId"));
        player.setPause(json.getBoolean("pause"));
        SocketServer.Companion.sendPlayerUpdate(this.context, player);
    }

    private final void seek(JSONObject json) {
        LavalinkPlayer player = this.context.getPlayer(json.getLong("guildId"));
        if (!player.isPlaying()) {
            log.warn("Can't seek when player is not playing anything");
            return;
        }
        player.seekTo(json.getLong("position"));
        SocketServer.Companion.sendPlayerUpdate(this.context, player);
    }

    private final void volume(JSONObject json) {
        LavalinkPlayer player = this.context.getPlayer(json.getLong("guildId"));
        player.setVolume(json.getInt("volume"));
    }

    /*
     * WARNING - void declaration
     */
    private final void equalizer(JSONObject json) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        if (!this.loggedEqualizerDeprecationWarning) {
            log.warn("The 'equalizer' op has been deprecated in favour of the 'filters' op. Please switch to that one, as this op will be removed in API version 4.");
            this.loggedEqualizerDeprecationWarning = true;
        }
        if (this.disabledFilters.contains("equalizer")) {
            log.warn("Equalizer filter is disabled in the config, ignoring equalizer op");
            return;
        }
        LavalinkPlayer player = this.context.getPlayer(json.getLong("guildId"));
        JSONArray jSONArray = json.getJSONArray("bands");
        Intrinsics.checkNotNullExpressionValue((Object)jSONArray, (String)"json.getJSONArray(\"bands\")");
        Iterable iterable = (Iterable)jSONArray;
        boolean $i$f$filterIsInstance = false;
        void var6_5 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof JSONObject)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void b;
            JSONObject jSONObject = (JSONObject)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Band(b.getInt("band"), b.getFloat("gain")));
        }
        List bands = (List)destination$iv$iv;
        FilterChain filters = player.getFilters();
        filters.setEqualizer(new EqualizerConfig(bands));
        player.setFilters(filters);
    }

    private final void filters(JSONObject json) {
        LavalinkPlayer player = this.context.getPlayer(json.getLong("guildId"));
        Filters filters = (Filters)this.objectMapper.readValue(json.toString(), Filters.class);
        List invalidFilters = filters.validate(this.disabledFilters);
        if (!((Collection)invalidFilters).isEmpty()) {
            log.warn("The following filters are disabled in the config and are being ignored: " + invalidFilters);
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)filters, (String)"filters");
        player.setFilters(FilterChain.Companion.parse(filters, this.filterExtensions));
    }

    private final void destroy(JSONObject json) {
        this.context.destroyPlayer(json.getLong("guildId"));
    }

    private final void configureResuming(JSONObject json) {
        this.context.setResumeKey(json.optString("key", null));
        if (json.has("timeout")) {
            this.context.setResumeTimeout(json.getLong("timeout"));
        }
    }

    private static final void voiceUpdate$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ void access$voiceUpdate(WebSocketHandler $this, JSONObject json) {
        $this.voiceUpdate(json);
    }

    public static final /* synthetic */ void access$play(WebSocketHandler $this, JSONObject json) {
        $this.play(json);
    }

    public static final /* synthetic */ void access$stop(WebSocketHandler $this, JSONObject json) {
        $this.stop(json);
    }

    public static final /* synthetic */ void access$pause(WebSocketHandler $this, JSONObject json) {
        $this.pause(json);
    }

    public static final /* synthetic */ void access$seek(WebSocketHandler $this, JSONObject json) {
        $this.seek(json);
    }

    public static final /* synthetic */ void access$volume(WebSocketHandler $this, JSONObject json) {
        $this.volume(json);
    }

    public static final /* synthetic */ void access$equalizer(WebSocketHandler $this, JSONObject json) {
        $this.equalizer(json);
    }

    public static final /* synthetic */ void access$filters(WebSocketHandler $this, JSONObject json) {
        $this.filters(json);
    }

    public static final /* synthetic */ void access$destroy(WebSocketHandler $this, JSONObject json) {
        $this.destroy(json);
    }

    public static final /* synthetic */ void access$configureResuming(WebSocketHandler $this, JSONObject json) {
        $this.configureResuming(json);
    }

    static {
        Logger logger = LoggerFactory.getLogger(WebSocketHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(WebSocketHandler::class.java)");
        log = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0006*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Llavalink/server/io/WebSocketHandler$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "toHandler", "Lkotlin/Pair;", "", "Lkotlin/Function1;", "Lorg/json/JSONObject;", "", "Ldev/arbjerg/lavalink/api/WebSocketExtension;", "ctx", "Llavalink/server/io/SocketContext;", "Lavalink-Server"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pair<String, Function1<JSONObject, Unit>> toHandler(@NotNull WebSocketExtension $this$toHandler, @NotNull SocketContext ctx) {
            Intrinsics.checkNotNullParameter((Object)$this$toHandler, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            return TuplesKt.to((Object)$this$toHandler.getOpName(), (Object)new Function1<JSONObject, Unit>($this$toHandler, ctx){
                final /* synthetic */ WebSocketExtension $this_toHandler;
                final /* synthetic */ SocketContext $ctx;
                {
                    this.$this_toHandler = $receiver;
                    this.$ctx = $ctx;
                    super(1);
                }

                public final void invoke(@NotNull JSONObject it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$this_toHandler.onInvocation((ISocketContext)this.$ctx, it);
                }
            });
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

