/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.player;

import com.sedmelluq.discord.lavaplayer.player.AudioLoadResultHandler;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.arbjerg.lavalink.protocol.v3.LoadResult;
import dev.arbjerg.lavalink.protocol.v3.Track;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import lavalink.server.util.UtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Llavalink/server/player/AudioLoader;", "Lcom/sedmelluq/discord/lavaplayer/player/AudioLoadResultHandler;", "audioPlayerManager", "Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;", "(Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;)V", "loadResult", "Ljava/util/concurrent/CompletableFuture;", "Ldev/arbjerg/lavalink/protocol/v3/LoadResult;", "used", "Ljava/util/concurrent/atomic/AtomicBoolean;", "load", "Ljava/util/concurrent/CompletionStage;", "identifier", "", "loadFailed", "", "e", "Lcom/sedmelluq/discord/lavaplayer/tools/FriendlyException;", "noMatches", "playlistLoaded", "audioPlaylist", "Lcom/sedmelluq/discord/lavaplayer/track/AudioPlaylist;", "trackLoaded", "audioTrack", "Lcom/sedmelluq/discord/lavaplayer/track/AudioTrack;", "Companion", "Lavalink-Server"})
public final class AudioLoader
implements AudioLoadResultHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AudioPlayerManager audioPlayerManager;
    @NotNull
    private final CompletableFuture<LoadResult> loadResult;
    @NotNull
    private final AtomicBoolean used;
    private static final Logger log = LoggerFactory.getLogger(AudioLoader.class);

    public AudioLoader(@NotNull AudioPlayerManager audioPlayerManager) {
        Intrinsics.checkNotNullParameter((Object)audioPlayerManager, (String)"audioPlayerManager");
        this.audioPlayerManager = audioPlayerManager;
        this.loadResult = new CompletableFuture();
        this.used = new AtomicBoolean(false);
    }

    @NotNull
    public final CompletionStage<LoadResult> load(@Nullable String identifier) {
        boolean isUsed = this.used.getAndSet(true);
        if (!(!isUsed)) {
            boolean bl = false;
            String string = "This loader can only be used once per instance";
            throw new IllegalStateException(string.toString());
        }
        log.trace("Loading item with identifier " + identifier);
        this.audioPlayerManager.loadItem(identifier, (AudioLoadResultHandler)this);
        return this.loadResult;
    }

    public void trackLoaded(@NotNull AudioTrack audioTrack) {
        Intrinsics.checkNotNullParameter((Object)audioTrack, (String)"audioTrack");
        log.info("Loaded track " + audioTrack.getInfo().title);
        Track track2 = UtilKt.toTrack(audioTrack, this.audioPlayerManager);
        this.loadResult.complete(LoadResult.Companion.trackLoaded(track2));
    }

    /*
     * WARNING - void declaration
     */
    public void playlistLoaded(@NotNull AudioPlaylist audioPlaylist) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)audioPlaylist, (String)"audioPlaylist");
        log.info("Loaded playlist " + audioPlaylist.getName());
        List list = audioPlaylist.getTracks();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"audioPlaylist.tracks");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AudioTrack audioTrack = (AudioTrack)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(UtilKt.toTrack((AudioTrack)it, this.audioPlayerManager));
        }
        List tracks = (List)destination$iv$iv;
        if (audioPlaylist.isSearchResult()) {
            this.loadResult.complete(LoadResult.Companion.searchResultLoaded(tracks));
            return;
        }
        this.loadResult.complete(LoadResult.Companion.playlistLoaded(UtilKt.toPlaylistInfo(audioPlaylist), tracks));
    }

    public void noMatches() {
        log.info("No matches found");
        this.loadResult.complete(LoadResult.Companion.getNoMatches());
    }

    public void loadFailed(@NotNull FriendlyException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        log.error("Load failed", (Throwable)e);
        this.loadResult.complete(LoadResult.Companion.loadFailed(e));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Llavalink/server/player/AudioLoader$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lavalink-Server"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

