/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.player;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import dev.arbjerg.lavalink.protocol.v3.DecodedTrack;
import dev.arbjerg.lavalink.protocol.v3.LoadResult;
import dev.arbjerg.lavalink.protocol.v3.Track;
import dev.arbjerg.lavalink.protocol.v3.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletionStage;
import javax.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import lavalink.server.player.AudioLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\u000e\b\u0001\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tH\u0017J&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\b2\n\b\u0001\u0010\u000f\u001a\u0004\u0018\u00010\f2\n\b\u0001\u0010\u0010\u001a\u0004\u0018\u00010\fH\u0017J&\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\b0\u00122\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Llavalink/server/player/AudioLoaderRestHandler;", "", "audioPlayerManager", "Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "decodeTracks", "Lorg/springframework/http/ResponseEntity;", "", "Ldev/arbjerg/lavalink/protocol/v3/Track;", "encodedTracks", "", "getDecodeTrack", "Ldev/arbjerg/lavalink/protocol/v3/DecodedTrack;", "encodedTrack", "track", "loadTracks", "Ljava/util/concurrent/CompletionStage;", "Lcom/fasterxml/jackson/databind/JsonNode;", "request", "Ljavax/servlet/http/HttpServletRequest;", "identifier", "Companion", "Lavalink-Server"})
public class AudioLoaderRestHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AudioPlayerManager audioPlayerManager;
    @NotNull
    private final ObjectMapper objectMapper;
    private static final Logger log = LoggerFactory.getLogger(AudioLoaderRestHandler.class);

    public AudioLoaderRestHandler(@NotNull AudioPlayerManager audioPlayerManager, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)audioPlayerManager, (String)"audioPlayerManager");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.audioPlayerManager = audioPlayerManager;
        this.objectMapper = objectMapper;
    }

    @GetMapping(value={"/loadtracks", "/v3/loadtracks"})
    @NotNull
    public CompletionStage<ResponseEntity<JsonNode>> loadTracks(@NotNull HttpServletRequest request, @RequestParam @NotNull String identifier) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        log.info("Got request to load for identifier \"" + identifier + "\"");
        CompletionStage<ResponseEntity<JsonNode>> completionStage = new AudioLoader(this.audioPlayerManager).load(identifier).thenApply(arg_0 -> AudioLoaderRestHandler.loadTracks$lambda$0((Function1)new Function1<LoadResult, ResponseEntity<JsonNode>>(this, request){
            final /* synthetic */ AudioLoaderRestHandler this$0;
            final /* synthetic */ HttpServletRequest $request;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                super(1);
            }

            public final ResponseEntity<JsonNode> invoke(LoadResult it) {
                ObjectNode node;
                block6: {
                    block5: {
                        JsonNode jsonNode = AudioLoaderRestHandler.access$getObjectMapper$p(this.this$0).valueToTree((Object)it);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"objectMapper.valueToTree(it)");
                        node = (ObjectNode)jsonNode;
                        String string = this.$request.getServletPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.servletPath");
                        if (StringsKt.startsWith$default((String)string, (String)"/loadtracks", (boolean)false, (int)2, null)) break block5;
                        String string2 = this.$request.getServletPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"request.servletPath");
                        if (!StringsKt.startsWith$default((String)string2, (String)"/v3/loadtracks", (boolean)false, (int)2, null)) break block6;
                    }
                    if (node.get("playlistInfo").isNull()) {
                        node.replace("playlistInfo", (JsonNode)JsonNodeFactory.instance.objectNode());
                    }
                    if (node.get("exception").isNull()) {
                        node.remove("exception");
                    }
                }
                return ResponseEntity.ok((Object)node);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue(completionStage, (String)"@GetMapping(value = [\"/l\u2026.ok(node)\n        }\n    }");
        return completionStage;
    }

    @GetMapping(value={"/decodetrack", "/v3/decodetrack"})
    @NotNull
    public ResponseEntity<DecodedTrack> getDecodeTrack(@RequestParam @Nullable String encodedTrack, @RequestParam @Nullable String track2) {
        String string = encodedTrack;
        if (string == null && (string = track2) == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "No track to decode provided");
        }
        String trackToDecode = string;
        Track decodedTrack = lavalink.server.util.UtilKt.toTrack(UtilKt.decodeTrack((AudioPlayerManager)this.audioPlayerManager, (String)trackToDecode), trackToDecode);
        ResponseEntity responseEntity = ResponseEntity.ok((Object)new DecodedTrack(decodedTrack.getEncoded(), decodedTrack.getInfo(), decodedTrack.getInfo()));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(DecodedTrack(decodedT\u2026info, decodedTrack.info))");
        return responseEntity;
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/decodetracks", "/v3/decodetracks"})
    @NotNull
    public ResponseEntity<List<Track>> decodeTracks(@RequestBody @NotNull List<String> encodedTracks) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(encodedTracks, (String)"encodedTracks");
        if (encodedTracks.isEmpty()) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "No tracks to decode provided");
        }
        Iterable $this$map$iv = encodedTracks;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(lavalink.server.util.UtilKt.toTrack(UtilKt.decodeTrack((AudioPlayerManager)this.audioPlayerManager, (String)it), (String)it));
        }
        ResponseEntity responseEntity = ResponseEntity.ok((Object)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(encodedTracks.map {\n \u2026t).toTrack(it)\n        })");
        return responseEntity;
    }

    private static final ResponseEntity loadTracks$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ResponseEntity)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ObjectMapper access$getObjectMapper$p(AudioLoaderRestHandler $this) {
        return $this.objectMapper;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Llavalink/server/player/AudioLoaderRestHandler$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lavalink-Server"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

