/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.player;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.player.event.AudioEventAdapter;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackEndReason;
import dev.arbjerg.lavalink.protocol.v3.Exception;
import dev.arbjerg.lavalink.protocol.v3.Message;
import dev.arbjerg.lavalink.protocol.v3.UtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import lavalink.server.io.SocketContext;
import lavalink.server.io.SocketServer;
import lavalink.server.player.LavalinkPlayer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\u0012\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Llavalink/server/player/EventEmitter;", "Lcom/sedmelluq/discord/lavaplayer/player/event/AudioEventAdapter;", "audioPlayerManager", "Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;", "player", "Llavalink/server/player/LavalinkPlayer;", "(Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;Llavalink/server/player/LavalinkPlayer;)V", "onTrackEnd", "", "Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayer;", "track", "Lcom/sedmelluq/discord/lavaplayer/track/AudioTrack;", "endReason", "Lcom/sedmelluq/discord/lavaplayer/track/AudioTrackEndReason;", "onTrackException", "exception", "Lcom/sedmelluq/discord/lavaplayer/tools/FriendlyException;", "onTrackStart", "onTrackStuck", "thresholdMs", "", "Companion", "Lavalink-Server"})
public final class EventEmitter
extends AudioEventAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AudioPlayerManager audioPlayerManager;
    @NotNull
    private final LavalinkPlayer player;
    private static final Logger log = LoggerFactory.getLogger(EventEmitter.class);

    public EventEmitter(@NotNull AudioPlayerManager audioPlayerManager, @NotNull LavalinkPlayer player) {
        Intrinsics.checkNotNullParameter((Object)audioPlayerManager, (String)"audioPlayerManager");
        Intrinsics.checkNotNullParameter((Object)((Object)player), (String)"player");
        this.audioPlayerManager = audioPlayerManager;
        this.player = player;
    }

    public void onTrackStart(@NotNull AudioPlayer player, @NotNull AudioTrack track2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)track2, (String)"track");
        String encodedTrack = UtilKt.encodeTrack((AudioPlayerManager)this.audioPlayerManager, (AudioTrack)track2);
        this.player.getSocket().sendMessage(new Message.TrackStartEvent(encodedTrack, encodedTrack, String.valueOf(this.player.getGuildId())));
    }

    public void onTrackEnd(@NotNull AudioPlayer player, @NotNull AudioTrack track2, @NotNull AudioTrackEndReason endReason) {
        AudioTrackEndReason audioTrackEndReason;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)track2, (String)"track");
        Intrinsics.checkNotNullParameter((Object)endReason, (String)"endReason");
        if (this.player.getEndMarkerHit()) {
            this.player.setEndMarkerHit(false);
            audioTrackEndReason = AudioTrackEndReason.FINISHED;
        } else {
            audioTrackEndReason = endReason;
        }
        AudioTrackEndReason reason = audioTrackEndReason;
        String encodedTrack = UtilKt.encodeTrack((AudioPlayerManager)this.audioPlayerManager, (AudioTrack)track2);
        this.player.getSocket().sendMessage(new Message.TrackEndEvent(encodedTrack, encodedTrack, reason, String.valueOf(this.player.getGuildId())));
    }

    public void onTrackException(@NotNull AudioPlayer player, @NotNull AudioTrack track2, @NotNull FriendlyException exception) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)track2, (String)"track");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        String encodedTrack = UtilKt.encodeTrack((AudioPlayerManager)this.audioPlayerManager, (AudioTrack)track2);
        SocketContext socketContext = this.player.getSocket();
        String string = exception.getMessage();
        FriendlyException.Severity severity = exception.severity;
        Intrinsics.checkNotNullExpressionValue((Object)severity, (String)"exception.severity");
        socketContext.sendMessage(new Message.TrackExceptionEvent(encodedTrack, encodedTrack, new Exception(string, severity, lavalink.server.util.UtilKt.getRootCause((Throwable)exception).toString()), String.valueOf(this.player.getGuildId())));
    }

    public void onTrackStuck(@NotNull AudioPlayer player, @NotNull AudioTrack track2, long thresholdMs) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)track2, (String)"track");
        log.warn(track2.getInfo().title + " got stuck! Threshold surpassed: " + thresholdMs + "ms");
        String encodedTrack = UtilKt.encodeTrack((AudioPlayerManager)this.audioPlayerManager, (AudioTrack)track2);
        this.player.getSocket().sendMessage(new Message.TrackStuckEvent(encodedTrack, encodedTrack, thresholdMs, String.valueOf(this.player.getGuildId())));
        SocketServer.Companion.sendPlayerUpdate(this.player.getSocket(), this.player);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Llavalink/server/player/EventEmitter$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lavalink-Server"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

