/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.player;

import com.sedmelluq.discord.lavaplayer.filter.PcmFilterFactory;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.player.event.AudioEventAdapter;
import com.sedmelluq.discord.lavaplayer.player.event.AudioEventListener;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackEndReason;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioFrame;
import dev.arbjerg.lavalink.api.IPlayer;
import dev.arbjerg.lavalink.api.ISocketContext;
import io.netty.buffer.ByteBuf;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import lavalink.server.config.ServerConfig;
import lavalink.server.io.SocketContext;
import lavalink.server.io.SocketServer;
import lavalink.server.player.AudioLossCounter;
import lavalink.server.player.EventEmitter;
import lavalink.server.player.filters.FilterChain;
import moe.kyokobot.koe.MediaConnection;
import moe.kyokobot.koe.media.MediaFrameProvider;
import moe.kyokobot.koe.media.OpusAudioFrameProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0001>B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010#\u001a\u00020$J\b\u0010%\u001a\u00020\u0011H\u0016J\b\u0010&\u001a\u00020\u0006H\u0016J\b\u0010'\u001a\u00020(H\u0016J\n\u0010)\u001a\u0004\u0018\u00010*H\u0016J\b\u0010+\u001a\u00020\u0013H\u0016J \u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020*2\u0006\u0010/\u001a\u000200H\u0016J\u0018\u00101\u001a\u00020$2\u0006\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020*H\u0016J\u0010\u00102\u001a\u00020$2\u0006\u0010.\u001a\u00020*H\u0016J\u000e\u00103\u001a\u00020$2\u0006\u00104\u001a\u000205J\u0010\u00106\u001a\u00020$2\u0006\u00107\u001a\u00020\u0006H\u0016J\u0010\u00108\u001a\u00020$2\u0006\u00109\u001a\u00020\u0013H\u0016J\u0010\u0010:\u001a\u00020$2\u0006\u0010;\u001a\u00020<H\u0016J\b\u0010=\u001a\u00020$H\u0016R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R$\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Llavalink/server/player/LavalinkPlayer;", "Lcom/sedmelluq/discord/lavaplayer/player/event/AudioEventAdapter;", "Ldev/arbjerg/lavalink/api/IPlayer;", "socket", "Llavalink/server/io/SocketContext;", "guildId", "", "serverConfig", "Llavalink/server/config/ServerConfig;", "audioPlayerManager", "Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;", "(Llavalink/server/io/SocketContext;JLlavalink/server/config/ServerConfig;Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;)V", "audioLossCounter", "Llavalink/server/player/AudioLossCounter;", "getAudioLossCounter", "()Llavalink/server/player/AudioLossCounter;", "audioPlayer", "Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayer;", "endMarkerHit", "", "getEndMarkerHit", "()Z", "setEndMarkerHit", "(Z)V", "value", "Llavalink/server/player/filters/FilterChain;", "filters", "getFilters", "()Llavalink/server/player/filters/FilterChain;", "setFilters", "(Llavalink/server/player/filters/FilterChain;)V", "getSocket", "()Llavalink/server/io/SocketContext;", "updateFuture", "Ljava/util/concurrent/ScheduledFuture;", "destroy", "", "getAudioPlayer", "getGuildId", "getSocketContext", "Ldev/arbjerg/lavalink/api/ISocketContext;", "getTrack", "Lcom/sedmelluq/discord/lavaplayer/track/AudioTrack;", "isPlaying", "onTrackEnd", "player", "track", "endReason", "Lcom/sedmelluq/discord/lavaplayer/track/AudioTrackEndReason;", "onTrackStart", "play", "provideTo", "connection", "Lmoe/kyokobot/koe/MediaConnection;", "seekTo", "position", "setPause", "b", "setVolume", "volume", "", "stop", "Provider", "Lavalink-Server"})
public final class LavalinkPlayer
extends AudioEventAdapter
implements IPlayer {
    @NotNull
    private final SocketContext socket;
    private final long guildId;
    @NotNull
    private final ServerConfig serverConfig;
    @NotNull
    private final AudioLossCounter audioLossCounter;
    private boolean endMarkerHit;
    @NotNull
    private FilterChain filters;
    @NotNull
    private final AudioPlayer audioPlayer;
    @Nullable
    private ScheduledFuture<?> updateFuture;

    /*
     * WARNING - void declaration
     */
    public LavalinkPlayer(@NotNull SocketContext socket, long guildId, @NotNull ServerConfig serverConfig, @NotNull AudioPlayerManager audioPlayerManager) {
        void it;
        AudioPlayer audioPlayer;
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        Intrinsics.checkNotNullParameter((Object)serverConfig, (String)"serverConfig");
        Intrinsics.checkNotNullParameter((Object)audioPlayerManager, (String)"audioPlayerManager");
        this.socket = socket;
        this.guildId = guildId;
        this.serverConfig = serverConfig;
        this.audioLossCounter = new AudioLossCounter();
        this.filters = new FilterChain(null, null, null, null, null, null, null, null, null, null, 1023, null);
        AudioPlayer audioPlayer2 = audioPlayer = audioPlayerManager.createPlayer();
        LavalinkPlayer lavalinkPlayer = this;
        boolean bl = false;
        it.addListener((AudioEventListener)this);
        it.addListener((AudioEventListener)new EventEmitter(audioPlayerManager, this));
        it.addListener((AudioEventListener)this.audioLossCounter);
        AudioPlayer audioPlayer3 = audioPlayer;
        Intrinsics.checkNotNullExpressionValue((Object)audioPlayer3, (String)"audioPlayerManager.creat\u2026r(audioLossCounter)\n    }");
        lavalinkPlayer.audioPlayer = audioPlayer3;
    }

    @NotNull
    public final SocketContext getSocket() {
        return this.socket;
    }

    @NotNull
    public final AudioLossCounter getAudioLossCounter() {
        return this.audioLossCounter;
    }

    public final boolean getEndMarkerHit() {
        return this.endMarkerHit;
    }

    public final void setEndMarkerHit(boolean bl) {
        this.endMarkerHit = bl;
    }

    @NotNull
    public final FilterChain getFilters() {
        return this.filters;
    }

    /*
     * WARNING - void declaration
     */
    public final void setFilters(@NotNull FilterChain value) {
        void it;
        FilterChain filterChain;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        FilterChain filterChain2 = filterChain = value;
        AudioPlayer audioPlayer = this.audioPlayer;
        boolean bl = false;
        boolean bl2 = it.isEnabled();
        audioPlayer.setFilterFactory((PcmFilterFactory)(bl2 ? filterChain : null));
        this.filters = value;
    }

    public final void destroy() {
        this.audioPlayer.destroy();
    }

    public final void provideTo(@NotNull MediaConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        connection.setAudioSender((MediaFrameProvider)new Provider(connection));
    }

    public boolean isPlaying() {
        return this.audioPlayer.getPlayingTrack() != null && !this.audioPlayer.isPaused();
    }

    @NotNull
    public AudioPlayer getAudioPlayer() {
        return this.audioPlayer;
    }

    @Nullable
    public AudioTrack getTrack() {
        return this.audioPlayer.getPlayingTrack();
    }

    public long getGuildId() {
        return this.guildId;
    }

    @NotNull
    public ISocketContext getSocketContext() {
        return this.socket;
    }

    public void play(@NotNull AudioTrack track2) {
        Intrinsics.checkNotNullParameter((Object)track2, (String)"track");
        this.audioPlayer.playTrack(track2);
        SocketServer.Companion.sendPlayerUpdate(this.socket, this);
    }

    public void stop() {
        this.audioPlayer.stopTrack();
    }

    public void setPause(boolean b) {
        this.audioPlayer.setPaused(b);
    }

    public void seekTo(long position) {
        AudioTrack audioTrack = this.audioPlayer.getPlayingTrack();
        if (audioTrack == null) {
            throw new RuntimeException("Can't seek when not playing anything");
        }
        AudioTrack track2 = audioTrack;
        track2.setPosition(position);
    }

    public void setVolume(int volume) {
        this.audioPlayer.setVolume(volume);
    }

    public void onTrackEnd(@NotNull AudioPlayer player, @NotNull AudioTrack track2, @NotNull AudioTrackEndReason endReason) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)track2, (String)"track");
        Intrinsics.checkNotNullParameter((Object)endReason, (String)"endReason");
        ScheduledFuture<?> scheduledFuture = this.updateFuture;
        Intrinsics.checkNotNull(scheduledFuture);
        scheduledFuture.cancel(false);
    }

    public void onTrackStart(@NotNull AudioPlayer player, @NotNull AudioTrack track2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)track2, (String)"track");
        ScheduledFuture<?> scheduledFuture = this.updateFuture;
        boolean bl = scheduledFuture != null ? !scheduledFuture.isCancelled() : false;
        if (bl) {
            return;
        }
        this.updateFuture = this.socket.getPlayerUpdateService().scheduleAtFixedRate(() -> LavalinkPlayer.onTrackStart$lambda$2(this), 0L, this.serverConfig.getPlayerUpdateInterval(), TimeUnit.SECONDS);
    }

    private static final void onTrackStart$lambda$2(LavalinkPlayer this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        SocketServer.Companion.sendPlayerUpdate(this$0.socket, this$0);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Llavalink/server/player/LavalinkPlayer$Provider;", "Lmoe/kyokobot/koe/media/OpusAudioFrameProvider;", "connection", "Lmoe/kyokobot/koe/MediaConnection;", "(Llavalink/server/player/LavalinkPlayer;Lmoe/kyokobot/koe/MediaConnection;)V", "lastFrame", "Lcom/sedmelluq/discord/lavaplayer/track/playback/AudioFrame;", "canProvide", "", "retrieveOpusFrame", "", "buf", "Lio/netty/buffer/ByteBuf;", "Lavalink-Server"})
    private final class Provider
    extends OpusAudioFrameProvider {
        @Nullable
        private AudioFrame lastFrame;

        public Provider(MediaConnection connection) {
            super(connection);
        }

        public boolean canProvide() {
            boolean bl;
            this.lastFrame = LavalinkPlayer.this.audioPlayer.provide();
            if (this.lastFrame == null) {
                LavalinkPlayer.this.getAudioLossCounter().onLoss();
                bl = false;
            } else {
                bl = true;
            }
            return bl;
        }

        public void retrieveOpusFrame(@NotNull ByteBuf buf) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            LavalinkPlayer.this.getAudioLossCounter().onSuccess();
            AudioFrame audioFrame = this.lastFrame;
            Intrinsics.checkNotNull((Object)audioFrame);
            buf.writeBytes(audioFrame.getData());
        }
    }
}

