/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.player;

import com.sedmelluq.discord.lavaplayer.player.AudioLoadResultHandler;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.TrackMarker;
import com.sedmelluq.discord.lavaplayer.track.TrackMarkerHandler;
import dev.arbjerg.lavalink.api.AudioFilterExtension;
import dev.arbjerg.lavalink.protocol.v3.Filters;
import dev.arbjerg.lavalink.protocol.v3.Omissible;
import dev.arbjerg.lavalink.protocol.v3.Player;
import dev.arbjerg.lavalink.protocol.v3.PlayerUpdate;
import dev.arbjerg.lavalink.protocol.v3.Players;
import dev.arbjerg.lavalink.protocol.v3.UtilKt;
import dev.arbjerg.lavalink.protocol.v3.VoiceState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import lavalink.server.config.ServerConfig;
import lavalink.server.io.SocketContext;
import lavalink.server.io.SocketServer;
import lavalink.server.player.LavalinkPlayer;
import lavalink.server.player.TrackEndMarkerHandler;
import lavalink.server.player.filters.FilterChain;
import moe.kyokobot.koe.MediaConnection;
import moe.kyokobot.koe.VoiceServerInfo;
import moe.kyokobot.koe.gateway.MediaGatewayConnection;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u000b2\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0013J\"\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\b\u0001\u0010\u0010\u001a\u00020\u000b2\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0013J\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00142\b\b\u0001\u0010\u0010\u001a\u00020\u000bH\u0013J6\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u0010\u001a\u00020\u000b2\b\b\u0001\u0010\u0011\u001a\u00020\u00122\b\b\u0003\u0010\u001b\u001a\u00020\u001cH\u0013R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Llavalink/server/player/PlayerRestHandler;", "", "socketServer", "Llavalink/server/io/SocketServer;", "filterExtensions", "", "Ldev/arbjerg/lavalink/api/AudioFilterExtension;", "serverConfig", "Llavalink/server/config/ServerConfig;", "(Llavalink/server/io/SocketServer;Ljava/util/List;Llavalink/server/config/ServerConfig;)V", "disabledFilters", "", "getDisabledFilters", "()Ljava/util/List;", "deletePlayer", "", "sessionId", "guildId", "", "getPlayer", "Lorg/springframework/http/ResponseEntity;", "Ldev/arbjerg/lavalink/protocol/v3/Player;", "getPlayers", "Ldev/arbjerg/lavalink/protocol/v3/Players;", "patchPlayer", "playerUpdate", "Ldev/arbjerg/lavalink/protocol/v3/PlayerUpdate;", "noReplace", "", "Companion", "Lavalink-Server"})
public class PlayerRestHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SocketServer socketServer;
    @NotNull
    private final List<AudioFilterExtension> filterExtensions;
    @NotNull
    private final List<String> disabledFilters;
    private static final Logger log = LoggerFactory.getLogger(PlayerRestHandler.class);

    /*
     * WARNING - void declaration
     */
    public PlayerRestHandler(@NotNull SocketServer socketServer, @NotNull List<? extends AudioFilterExtension> filterExtensions, @NotNull ServerConfig serverConfig) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map.Entry it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)socketServer), (String)"socketServer");
        Intrinsics.checkNotNullParameter(filterExtensions, (String)"filterExtensions");
        Intrinsics.checkNotNullParameter((Object)serverConfig, (String)"serverConfig");
        this.socketServer = socketServer;
        this.filterExtensions = filterExtensions;
        Iterable iterable = serverConfig.getFilters().entrySet();
        PlayerRestHandler playerRestHandler = this;
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!((Boolean)it.getValue() == false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getKey());
        }
        playerRestHandler.disabledFilters = (List)destination$iv$iv;
    }

    @NotNull
    public List<String> getDisabledFilters() {
        return this.disabledFilters;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/v3/sessions/{sessionId}/players"})
    private ResponseEntity<Players> getPlayers(@PathVariable String sessionId) {
        void $this$mapTo$iv$iv;
        SocketContext context = lavalink.server.util.UtilKt.socketContext(this.socketServer, sessionId);
        Iterable $this$map$iv = context.getPlayers().values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LavalinkPlayer lavalinkPlayer = (LavalinkPlayer)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(lavalink.server.util.UtilKt.toPlayer((LavalinkPlayer)it, context));
        }
        List list = (List)destination$iv$iv;
        ResponseEntity responseEntity = ResponseEntity.ok((Object)new Players(list));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(Players(context.playe\u2026 it.toPlayer(context) }))");
        return responseEntity;
    }

    @GetMapping(value={"/v3/sessions/{sessionId}/players/{guildId}"})
    private ResponseEntity<Player> getPlayer(@PathVariable String sessionId, @PathVariable long guildId) {
        SocketContext context = lavalink.server.util.UtilKt.socketContext(this.socketServer, sessionId);
        LavalinkPlayer player = lavalink.server.util.UtilKt.existingPlayer(context, guildId);
        ResponseEntity responseEntity = ResponseEntity.ok((Object)lavalink.server.util.UtilKt.toPlayer(player, context));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(player.toPlayer(context))");
        return responseEntity;
    }

    @PatchMapping(value={"/v3/sessions/{sessionId}/players/{guildId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    private ResponseEntity<Player> patchPlayer(@RequestBody PlayerUpdate playerUpdate, @PathVariable String sessionId, @PathVariable long guildId, @RequestParam boolean noReplace) {
        Omissible $i$f$takeIfPresent3;
        Omissible $this$takeIfPresent$iv;
        LavalinkPlayer player;
        SocketContext context;
        block31: {
            VoiceState it;
            block32: {
                Object it2;
                context = lavalink.server.util.UtilKt.socketContext(this.socketServer, sessionId);
                if (playerUpdate.getEncodedTrack().isPresent() && playerUpdate.getIdentifier().isPresent()) {
                    throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Cannot specify both encodedTrack and identifier");
                }
                Omissible $this$takeIfPresent$iv2 = playerUpdate.getFilters();
                boolean $i$f$takeIfPresent2 = false;
                if ($this$takeIfPresent$iv2.isPresent()) {
                    Filters filters = (Filters)$this$takeIfPresent$iv2.getValue();
                    boolean bl = false;
                    List invalidFilters = filters.validate(this.getDisabledFilters());
                    if (!((Collection)invalidFilters).isEmpty()) {
                        throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Following filters are disabled in the config: " + CollectionsKt.joinToString$default((Iterable)invalidFilters, null, null, null, (int)0, null, null, (int)63, null));
                    }
                }
                $this$takeIfPresent$iv2 = playerUpdate.getVoice();
                $i$f$takeIfPresent2 = false;
                if ($this$takeIfPresent$iv2.isPresent()) {
                    it2 = (VoiceState)$this$takeIfPresent$iv2.getValue();
                    boolean bl = false;
                    if (((CharSequence)it2.getEndpoint()).length() == 0 || ((CharSequence)it2.getToken()).length() == 0 || ((CharSequence)it2.getSessionId()).length() == 0) {
                        throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Partial voice state update: " + (VoiceState)it2);
                    }
                }
                $this$takeIfPresent$iv2 = playerUpdate.getEndTime();
                $i$f$takeIfPresent2 = false;
                if ($this$takeIfPresent$iv2.isPresent()) {
                    it2 = (Long)$this$takeIfPresent$iv2.getValue();
                    boolean bl = false;
                    if (it2 != null && (Long)it2 <= 0L) {
                        throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "End time must be greater than 0");
                    }
                }
                player = context.getPlayer(guildId);
                $this$takeIfPresent$iv = playerUpdate.getVoice();
                boolean $i$f$takeIfPresent3 = false;
                if (!$this$takeIfPresent$iv.isPresent()) break block31;
                it = (VoiceState)$this$takeIfPresent$iv.getValue();
                boolean bl = false;
                MediaConnection oldConn = context.getKoe().getConnection(guildId);
                if (oldConn == null) break block32;
                MediaGatewayConnection mediaGatewayConnection = oldConn.getGatewayConnection();
                if ((mediaGatewayConnection != null ? !mediaGatewayConnection.isOpen() : false) || oldConn.getVoiceServerInfo() == null) break block32;
                VoiceServerInfo voiceServerInfo = oldConn.getVoiceServerInfo();
                if (!Intrinsics.areEqual((Object)(voiceServerInfo != null ? voiceServerInfo.getEndpoint() : null), (Object)it.getEndpoint())) break block32;
                VoiceServerInfo voiceServerInfo2 = oldConn.getVoiceServerInfo();
                if (!Intrinsics.areEqual((Object)(voiceServerInfo2 != null ? voiceServerInfo2.getToken() : null), (Object)it.getToken())) break block32;
                VoiceServerInfo voiceServerInfo3 = oldConn.getVoiceServerInfo();
                if (Intrinsics.areEqual((Object)(voiceServerInfo3 != null ? voiceServerInfo3.getSessionId() : null), (Object)it.getSessionId())) break block31;
            }
            context.getKoe().destroyConnection(guildId);
            MediaConnection conn = context.getMediaConnection(player);
            conn.connect(new VoiceServerInfo(it.getSessionId(), it.getEndpoint(), it.getToken())).exceptionally(PlayerRestHandler::patchPlayer$lambda$7$lambda$6).toCompletableFuture().join();
            player.provideTo(conn);
        }
        Omissible it = $i$f$takeIfPresent3 = playerUpdate.getPaused();
        boolean bl = false;
        Object object = $this$takeIfPresent$iv = it.isPresent() && !playerUpdate.getEncodedTrack().isPresent() && !playerUpdate.getIdentifier().isPresent() ? $i$f$takeIfPresent3 : null;
        if ($this$takeIfPresent$iv != null) {
            it = $this$takeIfPresent$iv;
            boolean bl2 = false;
            player.setPause((Boolean)it.getValue());
        }
        $this$takeIfPresent$iv = playerUpdate.getVolume();
        boolean $i$f$takeIfPresent2 = false;
        if ($this$takeIfPresent$iv.isPresent()) {
            int it3 = ((Number)$this$takeIfPresent$iv.getValue()).intValue();
            boolean bl3 = false;
            player.setVolume(it3);
        }
        Omissible it4 = $i$f$takeIfPresent2 = playerUpdate.getPosition();
        boolean bl4 = false;
        Object object2 = $this$takeIfPresent$iv = it4.isPresent() && !playerUpdate.getEncodedTrack().isPresent() && !playerUpdate.getIdentifier().isPresent() ? $i$f$takeIfPresent2 : null;
        if ($this$takeIfPresent$iv != null) {
            it4 = $this$takeIfPresent$iv;
            boolean bl5 = false;
            if (player.isPlaying()) {
                player.seekTo(((Number)it4.getValue()).longValue());
                SocketServer.Companion.sendPlayerUpdate(context, player);
            }
        }
        it4 = $i$f$takeIfPresent2 = playerUpdate.getEndTime();
        boolean bl6 = false;
        Object object3 = $this$takeIfPresent$iv = it4.isPresent() && !playerUpdate.getEncodedTrack().isPresent() && !playerUpdate.getIdentifier().isPresent() ? $i$f$takeIfPresent2 : null;
        if ($this$takeIfPresent$iv != null) {
            TrackMarker trackMarker;
            it4 = $this$takeIfPresent$iv;
            boolean bl7 = false;
            Long l = (Long)it4.getValue();
            if (l != null) {
                long endTime = ((Number)l).longValue();
                boolean bl8 = false;
                trackMarker = new TrackMarker(endTime, (TrackMarkerHandler)new TrackEndMarkerHandler(player));
            } else {
                trackMarker = null;
            }
            TrackMarker marker = trackMarker;
            AudioTrack audioTrack = player.getTrack();
            if (audioTrack != null) {
                audioTrack.setMarker(marker);
            }
        }
        $this$takeIfPresent$iv = playerUpdate.getFilters();
        boolean $i$f$takeIfPresent3 = false;
        if ($this$takeIfPresent$iv.isPresent()) {
            it4 = (Filters)$this$takeIfPresent$iv.getValue();
            boolean bl9 = false;
            player.setFilters(FilterChain.Companion.parse((Filters)it4, this.filterExtensions));
            SocketServer.Companion.sendPlayerUpdate(context, player);
        }
        if (playerUpdate.getEncodedTrack().isPresent() || playerUpdate.getIdentifier().isPresent()) {
            Unit unit;
            AudioTrack track2;
            AudioTrack audioTrack;
            if (noReplace && player.getTrack() != null) {
                log.info("Skipping play request because of noReplace");
                ResponseEntity responseEntity = ResponseEntity.ok((Object)lavalink.server.util.UtilKt.toPlayer(player, context));
                Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(player.toPlayer(context))");
                return responseEntity;
            }
            player.setPause(playerUpdate.getPaused().isPresent() ? (Boolean)playerUpdate.getPaused().getValue() : false);
            if (playerUpdate.getEncodedTrack().isPresent()) {
                String string = (String)playerUpdate.getEncodedTrack().getValue();
                if (string != null) {
                    String encodedTrack = string;
                    boolean bl10 = false;
                    audioTrack = UtilKt.decodeTrack((AudioPlayerManager)context.getAudioPlayerManager(), (String)encodedTrack);
                } else {
                    audioTrack = null;
                }
            } else {
                CompletableFuture<AudioTrack> trackFuture = new CompletableFuture<AudioTrack>();
                context.getAudioPlayerManager().loadItem((String)playerUpdate.getIdentifier().getValue(), new AudioLoadResultHandler(trackFuture){
                    final /* synthetic */ CompletableFuture<AudioTrack> $trackFuture;
                    {
                        this.$trackFuture = $trackFuture;
                    }

                    public void trackLoaded(@NotNull AudioTrack track2) {
                        Intrinsics.checkNotNullParameter((Object)track2, (String)"track");
                        this.$trackFuture.complete(track2);
                    }

                    public void playlistLoaded(@NotNull AudioPlaylist playlist) {
                        Intrinsics.checkNotNullParameter((Object)playlist, (String)"playlist");
                        this.$trackFuture.completeExceptionally((Throwable)new ResponseStatusException(HttpStatus.BAD_REQUEST, "Cannot play a playlist or search result"));
                    }

                    public void noMatches() {
                        this.$trackFuture.completeExceptionally((Throwable)new ResponseStatusException(HttpStatus.BAD_REQUEST, "No matches found for identifier"));
                    }

                    public void loadFailed(@NotNull FriendlyException exception) {
                        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                        this.$trackFuture.completeExceptionally((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, exception.getMessage(), lavalink.server.util.UtilKt.getRootCause((Throwable)exception)));
                    }
                });
                audioTrack = (AudioTrack)((CompletableFuture)trackFuture.exceptionally(PlayerRestHandler::patchPlayer$lambda$18)).join();
            }
            AudioTrack audioTrack2 = track2 = audioTrack;
            if (audioTrack2 != null) {
                AudioTrack it5 = audioTrack2;
                boolean bl11 = false;
                Omissible $this$takeIfPresent$iv3 = playerUpdate.getPosition();
                boolean $i$f$takeIfPresent4 = false;
                if ($this$takeIfPresent$iv3.isPresent()) {
                    long position = ((Number)$this$takeIfPresent$iv3.getValue()).longValue();
                    boolean bl12 = false;
                    track2.setPosition(position);
                }
                $this$takeIfPresent$iv3 = playerUpdate.getEndTime();
                $i$f$takeIfPresent4 = false;
                if ($this$takeIfPresent$iv3.isPresent()) {
                    Long endTime = (Long)$this$takeIfPresent$iv3.getValue();
                    boolean bl13 = false;
                    if (endTime != null) {
                        track2.setMarker(new TrackMarker(endTime.longValue(), (TrackMarkerHandler)new TrackEndMarkerHandler(player)));
                    }
                }
                player.play(track2);
                player.provideTo(context.getMediaConnection(player));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                player.stop();
            }
        }
        ResponseEntity responseEntity = ResponseEntity.ok((Object)lavalink.server.util.UtilKt.toPlayer(player, context));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(player.toPlayer(context))");
        return responseEntity;
    }

    static /* synthetic */ ResponseEntity patchPlayer$default(PlayerRestHandler playerRestHandler, PlayerUpdate playerUpdate, String string, long l, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: patchPlayer");
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return playerRestHandler.patchPlayer(playerUpdate, string, l, bl);
    }

    @DeleteMapping(value={"/v3/sessions/{sessionId}/players/{guildId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    private void deletePlayer(@PathVariable String sessionId, @PathVariable long guildId) {
        lavalink.server.util.UtilKt.socketContext(this.socketServer, sessionId).destroyPlayer(guildId);
    }

    private static final Void patchPlayer$lambda$7$lambda$6(Throwable it) {
        throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, "Failed to connect to voice server");
    }

    private static final AudioTrack patchPlayer$lambda$18(Throwable it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        throw it;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Llavalink/server/player/PlayerRestHandler$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lavalink-Server"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

