/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.player.filters;

import com.fasterxml.jackson.databind.JsonNode;
import com.sedmelluq.discord.lavaplayer.filter.AudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.FloatPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.PcmFilterFactory;
import com.sedmelluq.discord.lavaplayer.filter.UniversalPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.format.AudioDataFormat;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.arbjerg.lavalink.api.AudioFilterExtension;
import dev.arbjerg.lavalink.protocol.v3.ChannelMix;
import dev.arbjerg.lavalink.protocol.v3.Distortion;
import dev.arbjerg.lavalink.protocol.v3.Filters;
import dev.arbjerg.lavalink.protocol.v3.Karaoke;
import dev.arbjerg.lavalink.protocol.v3.LowPass;
import dev.arbjerg.lavalink.protocol.v3.Rotation;
import dev.arbjerg.lavalink.protocol.v3.Timescale;
import dev.arbjerg.lavalink.protocol.v3.Tremolo;
import dev.arbjerg.lavalink.protocol.v3.Vibrato;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.ranges.RangesKt;
import lavalink.server.player.filters.Band;
import lavalink.server.player.filters.ChannelMixConfig;
import lavalink.server.player.filters.DistortionConfig;
import lavalink.server.player.filters.EqualizerConfig;
import lavalink.server.player.filters.FilterConfig;
import lavalink.server.player.filters.KaraokeConfig;
import lavalink.server.player.filters.LowPassConfig;
import lavalink.server.player.filters.RotationConfig;
import lavalink.server.player.filters.TimescaleConfig;
import lavalink.server.player.filters.TremoloConfig;
import lavalink.server.player.filters.VibratoConfig;
import lavalink.server.player.filters.VolumeConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 32\u00020\u0001:\u000234B}\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010\u0016J(\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u001bH\u0002J*\u0010(\u001a\u00020)2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020-0+2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u001bH\u0002J\u000e\u00100\u001a\u00020)2\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u00101\u001a\u000202R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0019R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Llavalink/server/player/filters/FilterChain;", "Lcom/sedmelluq/discord/lavaplayer/filter/PcmFilterFactory;", "volume", "Llavalink/server/player/filters/VolumeConfig;", "equalizer", "Llavalink/server/player/filters/EqualizerConfig;", "karaoke", "Llavalink/server/player/filters/KaraokeConfig;", "timescale", "Llavalink/server/player/filters/TimescaleConfig;", "tremolo", "Llavalink/server/player/filters/TremoloConfig;", "vibrato", "Llavalink/server/player/filters/VibratoConfig;", "distortion", "Llavalink/server/player/filters/DistortionConfig;", "rotation", "Llavalink/server/player/filters/RotationConfig;", "channelMix", "Llavalink/server/player/filters/ChannelMixConfig;", "lowPass", "Llavalink/server/player/filters/LowPassConfig;", "(Llavalink/server/player/filters/VolumeConfig;Llavalink/server/player/filters/EqualizerConfig;Llavalink/server/player/filters/KaraokeConfig;Llavalink/server/player/filters/TimescaleConfig;Llavalink/server/player/filters/TremoloConfig;Llavalink/server/player/filters/VibratoConfig;Llavalink/server/player/filters/DistortionConfig;Llavalink/server/player/filters/RotationConfig;Llavalink/server/player/filters/ChannelMixConfig;Llavalink/server/player/filters/LowPassConfig;)V", "isEnabled", "", "()Z", "pluginFilters", "", "Llavalink/server/player/filters/FilterChain$PluginConfig;", "buildChain", "", "Lcom/sedmelluq/discord/lavaplayer/filter/AudioFilter;", "track", "Lcom/sedmelluq/discord/lavaplayer/track/AudioTrack;", "format", "Lcom/sedmelluq/discord/lavaplayer/format/AudioDataFormat;", "output", "Lcom/sedmelluq/discord/lavaplayer/filter/UniversalPcmAudioFilter;", "buildList", "Llavalink/server/player/filters/FilterConfig;", "parsePluginConfigs", "", "dynamicValues", "", "", "Lcom/fasterxml/jackson/databind/JsonNode;", "extensions", "Ldev/arbjerg/lavalink/api/AudioFilterExtension;", "setEqualizer", "toFilters", "Ldev/arbjerg/lavalink/protocol/v3/Filters;", "Companion", "PluginConfig", "Lavalink-Server"})
public final class FilterChain
implements PcmFilterFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final VolumeConfig volume;
    @Nullable
    private EqualizerConfig equalizer;
    @Nullable
    private final KaraokeConfig karaoke;
    @Nullable
    private final TimescaleConfig timescale;
    @Nullable
    private final TremoloConfig tremolo;
    @Nullable
    private final VibratoConfig vibrato;
    @Nullable
    private final DistortionConfig distortion;
    @Nullable
    private final RotationConfig rotation;
    @Nullable
    private final ChannelMixConfig channelMix;
    @Nullable
    private final LowPassConfig lowPass;
    @NotNull
    private volatile List<PluginConfig> pluginFilters;

    public FilterChain(@Nullable VolumeConfig volume, @Nullable EqualizerConfig equalizer, @Nullable KaraokeConfig karaoke, @Nullable TimescaleConfig timescale, @Nullable TremoloConfig tremolo, @Nullable VibratoConfig vibrato, @Nullable DistortionConfig distortion, @Nullable RotationConfig rotation, @Nullable ChannelMixConfig channelMix, @Nullable LowPassConfig lowPass) {
        this.volume = volume;
        this.equalizer = equalizer;
        this.karaoke = karaoke;
        this.timescale = timescale;
        this.tremolo = tremolo;
        this.vibrato = vibrato;
        this.distortion = distortion;
        this.rotation = rotation;
        this.channelMix = channelMix;
        this.lowPass = lowPass;
        this.pluginFilters = CollectionsKt.emptyList();
    }

    public /* synthetic */ FilterChain(VolumeConfig volumeConfig, EqualizerConfig equalizerConfig, KaraokeConfig karaokeConfig, TimescaleConfig timescaleConfig, TremoloConfig tremoloConfig, VibratoConfig vibratoConfig, DistortionConfig distortionConfig, RotationConfig rotationConfig, ChannelMixConfig channelMixConfig, LowPassConfig lowPassConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            volumeConfig = null;
        }
        if ((n & 2) != 0) {
            equalizerConfig = null;
        }
        if ((n & 4) != 0) {
            karaokeConfig = null;
        }
        if ((n & 8) != 0) {
            timescaleConfig = null;
        }
        if ((n & 0x10) != 0) {
            tremoloConfig = null;
        }
        if ((n & 0x20) != 0) {
            vibratoConfig = null;
        }
        if ((n & 0x40) != 0) {
            distortionConfig = null;
        }
        if ((n & 0x80) != 0) {
            rotationConfig = null;
        }
        if ((n & 0x100) != 0) {
            channelMixConfig = null;
        }
        if ((n & 0x200) != 0) {
            lowPassConfig = null;
        }
        this(volumeConfig, equalizerConfig, karaokeConfig, timescaleConfig, tremoloConfig, vibratoConfig, distortionConfig, rotationConfig, channelMixConfig, lowPassConfig);
    }

    /*
     * WARNING - void declaration
     */
    private final void parsePluginConfigs(Map<String, ? extends JsonNode> dynamicValues, List<? extends AudioFilterExtension> extensions) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Iterable iterable = extensions;
        FilterChain filterChain = this;
        boolean $i$f$mapNotNull = false;
        void var5_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PluginConfig it$iv$iv;
            JsonNode json;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            AudioFilterExtension it = (AudioFilterExtension)element$iv$iv;
            boolean bl2 = false;
            if ((dynamicValues.get(it.getName()) == null ? null : new PluginConfig(it, json)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        filterChain.pluginFilters = (List)destination$iv$iv;
    }

    public final void setEqualizer(@NotNull EqualizerConfig equalizer) {
        Intrinsics.checkNotNullParameter((Object)equalizer, (String)"equalizer");
        this.equalizer = equalizer;
    }

    private final List<FilterConfig> buildList() {
        SpreadBuilder spreadBuilder = new SpreadBuilder(11);
        spreadBuilder.add((Object)this.volume);
        spreadBuilder.add((Object)this.equalizer);
        spreadBuilder.add((Object)this.karaoke);
        spreadBuilder.add((Object)this.timescale);
        spreadBuilder.add((Object)this.tremolo);
        spreadBuilder.add((Object)this.vibrato);
        spreadBuilder.add((Object)this.distortion);
        spreadBuilder.add((Object)this.rotation);
        spreadBuilder.add((Object)this.channelMix);
        spreadBuilder.add((Object)this.lowPass);
        Collection $this$toTypedArray$iv = this.pluginFilters;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        PluginConfig[] pluginConfigArray = thisCollection$iv.toArray(new PluginConfig[0]);
        Intrinsics.checkNotNull((Object)pluginConfigArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        spreadBuilder.addSpread((Object)pluginConfigArray);
        return CollectionsKt.listOfNotNull((Object[])spreadBuilder.toArray((Object[])new FilterConfig[spreadBuilder.size()]));
    }

    public final boolean isEnabled() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.buildList();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FilterConfig it = (FilterConfig)element$iv;
                    boolean bl2 = false;
                    if (!it.isEnabled()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public List<AudioFilter> buildChain(@Nullable AudioTrack track2, @NotNull AudioDataFormat format, @NotNull UniversalPcmAudioFilter output) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        List<FilterConfig> list = this.buildList();
        List<FilterConfig> it = list;
        boolean bl = false;
        Object object = !((Collection)it).isEmpty() ? list : null;
        if (object == null) {
            return new ArrayList();
        }
        List<FilterConfig> enabledFilters = object;
        List pipeline = new ArrayList();
        for (FilterConfig filter : enabledFilters) {
            FloatPcmAudioFilter floatPcmAudioFilter = (FloatPcmAudioFilter)CollectionsKt.lastOrNull((List)pipeline);
            if (floatPcmAudioFilter == null) {
                floatPcmAudioFilter = (FloatPcmAudioFilter)output;
            }
            FloatPcmAudioFilter outputTo = floatPcmAudioFilter;
            pipeline.add(filter.build(format, outputTo));
        }
        return CollectionsKt.toMutableList((Collection)CollectionsKt.reversed((Iterable)pipeline));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Filters toFilters() {
        Map map;
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        LowPass lowPass;
        LowPass lowPass2;
        ChannelMix channelMix;
        ChannelMix channelMix2;
        Rotation rotation;
        Rotation rotation2;
        Distortion distortion;
        Distortion distortion2;
        Vibrato vibrato;
        Vibrato vibrato2;
        Tremolo tremolo;
        Tremolo tremolo2;
        Timescale timescale;
        Timescale timescale2;
        Karaoke karaoke;
        Karaoke karaoke2;
        FilterConfig it;
        Collection collection;
        PluginConfig it2;
        Collection<dev.arbjerg.lavalink.protocol.v3.Band> collection2;
        Band band;
        KaraokeConfig $this$map$iv;
        Float f;
        VolumeConfig volumeConfig = this.volume;
        Float f2 = volumeConfig != null ? Float.valueOf(volumeConfig.getVolume()) : null;
        Object object = this.equalizer;
        if (object != null && (object = ((EqualizerConfig)object).getBands()) != null) {
            void $this$mapTo$iv$iv;
            Iterable iterable = (Iterable)object;
            f = f2;
            boolean $i$f$map = false;
            KaraokeConfig karaokeConfig = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                band = (Band)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(new dev.arbjerg.lavalink.protocol.v3.Band(((Band)((Object)it2)).getBand(), ((Band)((Object)it2)).getGain()));
            }
            collection = (List)destination$iv$iv;
            f2 = f;
        } else {
            collection = null;
        }
        KaraokeConfig karaokeConfig = this.karaoke;
        if (karaokeConfig != null) {
            $this$map$iv = karaokeConfig;
            collection2 = collection;
            f = f2;
            boolean bl = false;
            karaoke2 = new Karaoke(((KaraokeConfig)it).getLevel(), ((KaraokeConfig)it).getMonoLevel(), ((KaraokeConfig)it).getFilterBand(), ((KaraokeConfig)it).getFilterWidth());
            f2 = f;
            collection = collection2;
            karaoke = karaoke2;
        } else {
            karaoke = null;
        }
        TimescaleConfig timescaleConfig = this.timescale;
        if (timescaleConfig != null) {
            it = timescaleConfig;
            karaoke2 = karaoke;
            collection2 = collection;
            f = f2;
            boolean bl = false;
            timescale2 = new Timescale(((TimescaleConfig)it).getSpeed(), ((TimescaleConfig)it).getPitch(), ((TimescaleConfig)it).getRate());
            f2 = f;
            collection = collection2;
            karaoke = karaoke2;
            timescale = timescale2;
        } else {
            timescale = null;
        }
        TremoloConfig tremoloConfig = this.tremolo;
        if (tremoloConfig != null) {
            it = tremoloConfig;
            timescale2 = timescale;
            karaoke2 = karaoke;
            collection2 = collection;
            f = f2;
            boolean bl = false;
            tremolo2 = new Tremolo(((TremoloConfig)it).getFrequency(), ((TremoloConfig)it).getDepth());
            f2 = f;
            collection = collection2;
            karaoke = karaoke2;
            timescale = timescale2;
            tremolo = tremolo2;
        } else {
            tremolo = null;
        }
        VibratoConfig vibratoConfig = this.vibrato;
        if (vibratoConfig != null) {
            it = vibratoConfig;
            tremolo2 = tremolo;
            timescale2 = timescale;
            karaoke2 = karaoke;
            collection2 = collection;
            f = f2;
            boolean bl = false;
            vibrato2 = new Vibrato(((VibratoConfig)it).getFrequency(), ((VibratoConfig)it).getDepth());
            f2 = f;
            collection = collection2;
            karaoke = karaoke2;
            timescale = timescale2;
            tremolo = tremolo2;
            vibrato = vibrato2;
        } else {
            vibrato = null;
        }
        DistortionConfig distortionConfig = this.distortion;
        if (distortionConfig != null) {
            it = distortionConfig;
            vibrato2 = vibrato;
            tremolo2 = tremolo;
            timescale2 = timescale;
            karaoke2 = karaoke;
            collection2 = collection;
            f = f2;
            boolean bl = false;
            distortion2 = new Distortion(((DistortionConfig)it).getSinOffset(), ((DistortionConfig)it).getSinScale(), ((DistortionConfig)it).getCosOffset(), ((DistortionConfig)it).getCosScale(), ((DistortionConfig)it).getTanOffset(), ((DistortionConfig)it).getTanScale(), ((DistortionConfig)it).getOffset(), ((DistortionConfig)it).getScale());
            f2 = f;
            collection = collection2;
            karaoke = karaoke2;
            timescale = timescale2;
            tremolo = tremolo2;
            vibrato = vibrato2;
            distortion = distortion2;
        } else {
            distortion = null;
        }
        RotationConfig rotationConfig = this.rotation;
        if (rotationConfig != null) {
            it = rotationConfig;
            distortion2 = distortion;
            vibrato2 = vibrato;
            tremolo2 = tremolo;
            timescale2 = timescale;
            karaoke2 = karaoke;
            collection2 = collection;
            f = f2;
            boolean bl = false;
            rotation2 = new Rotation(((RotationConfig)it).getRotationHz());
            f2 = f;
            collection = collection2;
            karaoke = karaoke2;
            timescale = timescale2;
            tremolo = tremolo2;
            vibrato = vibrato2;
            distortion = distortion2;
            rotation = rotation2;
        } else {
            rotation = null;
        }
        ChannelMixConfig channelMixConfig = this.channelMix;
        if (channelMixConfig != null) {
            it = channelMixConfig;
            rotation2 = rotation;
            distortion2 = distortion;
            vibrato2 = vibrato;
            tremolo2 = tremolo;
            timescale2 = timescale;
            karaoke2 = karaoke;
            collection2 = collection;
            f = f2;
            boolean bl = false;
            channelMix2 = new ChannelMix(((ChannelMixConfig)it).getLeftToLeft(), ((ChannelMixConfig)it).getLeftToRight(), ((ChannelMixConfig)it).getRightToLeft(), ((ChannelMixConfig)it).getRightToRight());
            f2 = f;
            collection = collection2;
            karaoke = karaoke2;
            timescale = timescale2;
            tremolo = tremolo2;
            vibrato = vibrato2;
            distortion = distortion2;
            rotation = rotation2;
            channelMix = channelMix2;
        } else {
            channelMix = null;
        }
        LowPassConfig lowPassConfig = this.lowPass;
        if (lowPassConfig != null) {
            it = lowPassConfig;
            channelMix2 = channelMix;
            rotation2 = rotation;
            distortion2 = distortion;
            vibrato2 = vibrato;
            tremolo2 = tremolo;
            timescale2 = timescale;
            karaoke2 = karaoke;
            collection2 = collection;
            f = f2;
            boolean bl = false;
            lowPass2 = new LowPass(((LowPassConfig)it).getSmoothing());
            f2 = f;
            collection = collection2;
            karaoke = karaoke2;
            timescale = timescale2;
            tremolo = tremolo2;
            vibrato = vibrato2;
            distortion = distortion2;
            rotation = rotation2;
            channelMix = channelMix2;
            lowPass = lowPass2;
        } else {
            lowPass = null;
        }
        Iterable iterable = this.pluginFilters;
        lowPass2 = lowPass;
        channelMix2 = channelMix;
        rotation2 = rotation;
        distortion2 = distortion;
        vibrato2 = vibrato;
        tremolo2 = tremolo;
        timescale2 = timescale;
        karaoke2 = karaoke;
        collection2 = collection;
        f = f2;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void bl = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            it2 = (PluginConfig)element$iv$iv;
            boolean bl2 = false;
            band = TuplesKt.to((Object)it2.getExtension().getName(), (Object)it2.getJson());
            map2.put(band.getFirst(), band.getSecond());
        }
        Map map3 = map = destination$iv$iv;
        LowPass lowPass3 = lowPass2;
        ChannelMix channelMix3 = channelMix2;
        Rotation rotation3 = rotation2;
        Distortion distortion3 = distortion2;
        Vibrato vibrato3 = vibrato2;
        Tremolo tremolo3 = tremolo2;
        Timescale timescale3 = timescale2;
        Karaoke karaoke3 = karaoke2;
        Collection<dev.arbjerg.lavalink.protocol.v3.Band> collection3 = collection2;
        Float f3 = f;
        return new Filters(f3, collection3, karaoke3, timescale3, tremolo3, vibrato3, distortion3, rotation3, channelMix3, lowPass3, map3);
    }

    public FilterChain() {
        this(null, null, null, null, null, null, null, null, null, null, 1023, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a8\u0006\n"}, d2={"Llavalink/server/player/filters/FilterChain$Companion;", "", "()V", "parse", "Llavalink/server/player/filters/FilterChain;", "filters", "Ldev/arbjerg/lavalink/protocol/v3/Filters;", "extensions", "", "Ldev/arbjerg/lavalink/api/AudioFilterExtension;", "Lavalink-Server"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final FilterChain parse(@NotNull Filters filters, @NotNull List<? extends AudioFilterExtension> extensions) {
            FilterChain filterChain;
            LowPassConfig lowPassConfig;
            ChannelMixConfig channelMixConfig;
            ChannelMixConfig channelMixConfig2;
            RotationConfig rotationConfig;
            RotationConfig rotationConfig2;
            DistortionConfig distortionConfig;
            DistortionConfig distortionConfig2;
            VibratoConfig vibratoConfig;
            VibratoConfig vibratoConfig2;
            TremoloConfig tremoloConfig;
            TremoloConfig tremoloConfig2;
            TimescaleConfig timescaleConfig;
            TimescaleConfig timescaleConfig2;
            KaraokeConfig karaokeConfig;
            KaraokeConfig karaokeConfig2;
            EqualizerConfig equalizerConfig;
            EqualizerConfig equalizerConfig2;
            VolumeConfig volumeConfig;
            VolumeConfig volumeConfig2;
            Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
            Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
            Float f = filters.getVolume();
            if (f != null) {
                float it = ((Number)f).floatValue();
                boolean bl = false;
                volumeConfig2 = new VolumeConfig(it);
            } else {
                volumeConfig2 = null;
            }
            List list = filters.getEqualizer();
            if (list != null) {
                void $this$mapTo$iv$iv;
                List it = list;
                volumeConfig = volumeConfig2;
                boolean bl = false;
                Iterable $this$map$iv = it;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void band;
                    dev.arbjerg.lavalink.protocol.v3.Band band2 = (dev.arbjerg.lavalink.protocol.v3.Band)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(new Band(band.getBand(), band.getGain()));
                }
                List list2 = (List)destination$iv$iv;
                equalizerConfig2 = new EqualizerConfig(list2);
                volumeConfig2 = volumeConfig;
            } else {
                equalizerConfig2 = null;
            }
            Karaoke karaoke = filters.getKaraoke();
            if (karaoke != null) {
                Karaoke it = karaoke;
                equalizerConfig = equalizerConfig2;
                volumeConfig = volumeConfig2;
                boolean bl = false;
                karaokeConfig2 = new KaraokeConfig(it.getLevel(), it.getMonoLevel(), it.getFilterBand(), it.getFilterWidth());
                volumeConfig2 = volumeConfig;
                equalizerConfig2 = equalizerConfig;
                karaokeConfig = karaokeConfig2;
            } else {
                karaokeConfig = null;
            }
            Timescale timescale = filters.getTimescale();
            if (timescale != null) {
                Timescale it = timescale;
                karaokeConfig2 = karaokeConfig;
                equalizerConfig = equalizerConfig2;
                volumeConfig = volumeConfig2;
                boolean bl = false;
                timescaleConfig2 = new TimescaleConfig(it.getSpeed(), it.getPitch(), it.getRate());
                volumeConfig2 = volumeConfig;
                equalizerConfig2 = equalizerConfig;
                karaokeConfig = karaokeConfig2;
                timescaleConfig = timescaleConfig2;
            } else {
                timescaleConfig = null;
            }
            Tremolo tremolo = filters.getTremolo();
            if (tremolo != null) {
                Tremolo it = tremolo;
                timescaleConfig2 = timescaleConfig;
                karaokeConfig2 = karaokeConfig;
                equalizerConfig = equalizerConfig2;
                volumeConfig = volumeConfig2;
                boolean bl = false;
                tremoloConfig2 = new TremoloConfig(it.getFrequency(), it.getDepth());
                volumeConfig2 = volumeConfig;
                equalizerConfig2 = equalizerConfig;
                karaokeConfig = karaokeConfig2;
                timescaleConfig = timescaleConfig2;
                tremoloConfig = tremoloConfig2;
            } else {
                tremoloConfig = null;
            }
            Vibrato vibrato = filters.getVibrato();
            if (vibrato != null) {
                Vibrato it = vibrato;
                tremoloConfig2 = tremoloConfig;
                timescaleConfig2 = timescaleConfig;
                karaokeConfig2 = karaokeConfig;
                equalizerConfig = equalizerConfig2;
                volumeConfig = volumeConfig2;
                boolean bl = false;
                vibratoConfig2 = new VibratoConfig(it.getFrequency(), it.getDepth());
                volumeConfig2 = volumeConfig;
                equalizerConfig2 = equalizerConfig;
                karaokeConfig = karaokeConfig2;
                timescaleConfig = timescaleConfig2;
                tremoloConfig = tremoloConfig2;
                vibratoConfig = vibratoConfig2;
            } else {
                vibratoConfig = null;
            }
            Distortion distortion = filters.getDistortion();
            if (distortion != null) {
                Distortion it = distortion;
                vibratoConfig2 = vibratoConfig;
                tremoloConfig2 = tremoloConfig;
                timescaleConfig2 = timescaleConfig;
                karaokeConfig2 = karaokeConfig;
                equalizerConfig = equalizerConfig2;
                volumeConfig = volumeConfig2;
                boolean bl = false;
                distortionConfig2 = new DistortionConfig(it.getSinOffset(), it.getSinScale(), it.getCosOffset(), it.getCosScale(), it.getTanOffset(), it.getTanScale(), it.getOffset(), it.getScale());
                volumeConfig2 = volumeConfig;
                equalizerConfig2 = equalizerConfig;
                karaokeConfig = karaokeConfig2;
                timescaleConfig = timescaleConfig2;
                tremoloConfig = tremoloConfig2;
                vibratoConfig = vibratoConfig2;
                distortionConfig = distortionConfig2;
            } else {
                distortionConfig = null;
            }
            Rotation rotation = filters.getRotation();
            if (rotation != null) {
                Rotation it = rotation;
                distortionConfig2 = distortionConfig;
                vibratoConfig2 = vibratoConfig;
                tremoloConfig2 = tremoloConfig;
                timescaleConfig2 = timescaleConfig;
                karaokeConfig2 = karaokeConfig;
                equalizerConfig = equalizerConfig2;
                volumeConfig = volumeConfig2;
                boolean bl = false;
                rotationConfig2 = new RotationConfig(it.getRotationHz());
                volumeConfig2 = volumeConfig;
                equalizerConfig2 = equalizerConfig;
                karaokeConfig = karaokeConfig2;
                timescaleConfig = timescaleConfig2;
                tremoloConfig = tremoloConfig2;
                vibratoConfig = vibratoConfig2;
                distortionConfig = distortionConfig2;
                rotationConfig = rotationConfig2;
            } else {
                rotationConfig = null;
            }
            ChannelMix channelMix = filters.getChannelMix();
            if (channelMix != null) {
                ChannelMix it = channelMix;
                rotationConfig2 = rotationConfig;
                distortionConfig2 = distortionConfig;
                vibratoConfig2 = vibratoConfig;
                tremoloConfig2 = tremoloConfig;
                timescaleConfig2 = timescaleConfig;
                karaokeConfig2 = karaokeConfig;
                equalizerConfig = equalizerConfig2;
                volumeConfig = volumeConfig2;
                boolean bl = false;
                channelMixConfig2 = new ChannelMixConfig(it.getLeftToLeft(), it.getLeftToRight(), it.getRightToLeft(), it.getRightToRight());
                volumeConfig2 = volumeConfig;
                equalizerConfig2 = equalizerConfig;
                karaokeConfig = karaokeConfig2;
                timescaleConfig = timescaleConfig2;
                tremoloConfig = tremoloConfig2;
                vibratoConfig = vibratoConfig2;
                distortionConfig = distortionConfig2;
                rotationConfig = rotationConfig2;
                channelMixConfig = channelMixConfig2;
            } else {
                channelMixConfig = null;
            }
            LowPass lowPass = filters.getLowPass();
            if (lowPass != null) {
                LowPass it = lowPass;
                channelMixConfig2 = channelMixConfig;
                rotationConfig2 = rotationConfig;
                distortionConfig2 = distortionConfig;
                vibratoConfig2 = vibratoConfig;
                tremoloConfig2 = tremoloConfig;
                timescaleConfig2 = timescaleConfig;
                karaokeConfig2 = karaokeConfig;
                equalizerConfig = equalizerConfig2;
                volumeConfig = volumeConfig2;
                boolean bl = false;
                LowPassConfig lowPassConfig2 = new LowPassConfig(it.getSmoothing());
                volumeConfig2 = volumeConfig;
                equalizerConfig2 = equalizerConfig;
                karaokeConfig = karaokeConfig2;
                timescaleConfig = timescaleConfig2;
                tremoloConfig = tremoloConfig2;
                vibratoConfig = vibratoConfig2;
                distortionConfig = distortionConfig2;
                rotationConfig = rotationConfig2;
                channelMixConfig = channelMixConfig2;
                lowPassConfig = lowPassConfig2;
            } else {
                lowPassConfig = null;
            }
            LowPassConfig lowPassConfig3 = lowPassConfig;
            ChannelMixConfig channelMixConfig3 = channelMixConfig;
            RotationConfig rotationConfig3 = rotationConfig;
            DistortionConfig distortionConfig3 = distortionConfig;
            VibratoConfig vibratoConfig3 = vibratoConfig;
            TremoloConfig tremoloConfig3 = tremoloConfig;
            TimescaleConfig timescaleConfig3 = timescaleConfig;
            KaraokeConfig karaokeConfig3 = karaokeConfig;
            EqualizerConfig equalizerConfig3 = equalizerConfig2;
            VolumeConfig volumeConfig3 = volumeConfig2;
            FilterChain $this$parse_u24lambda_u2411 = filterChain = new FilterChain(volumeConfig3, equalizerConfig3, karaokeConfig3, timescaleConfig3, tremoloConfig3, vibratoConfig3, distortionConfig3, rotationConfig3, channelMixConfig3, lowPassConfig3);
            boolean bl = false;
            $this$parse_u24lambda_u2411.parsePluginConfigs(filters.getPluginFilters(), extensions);
            return filterChain;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Llavalink/server/player/filters/FilterChain$PluginConfig;", "Llavalink/server/player/filters/FilterConfig;", "extension", "Ldev/arbjerg/lavalink/api/AudioFilterExtension;", "json", "Lcom/fasterxml/jackson/databind/JsonNode;", "(Ldev/arbjerg/lavalink/api/AudioFilterExtension;Lcom/fasterxml/jackson/databind/JsonNode;)V", "getExtension", "()Ldev/arbjerg/lavalink/api/AudioFilterExtension;", "isEnabled", "", "()Z", "getJson", "()Lcom/fasterxml/jackson/databind/JsonNode;", "name", "", "getName", "()Ljava/lang/String;", "build", "Lcom/sedmelluq/discord/lavaplayer/filter/FloatPcmAudioFilter;", "format", "Lcom/sedmelluq/discord/lavaplayer/format/AudioDataFormat;", "output", "Lavalink-Server"})
    private static final class PluginConfig
    extends FilterConfig {
        @NotNull
        private final AudioFilterExtension extension;
        @NotNull
        private final JsonNode json;
        private final boolean isEnabled;
        @NotNull
        private final String name;

        public PluginConfig(@NotNull AudioFilterExtension extension, @NotNull JsonNode json) {
            Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            this.extension = extension;
            this.json = json;
            this.isEnabled = this.extension.isEnabled(this.json);
            String string = this.extension.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extension.name");
            this.name = string;
        }

        @NotNull
        public final AudioFilterExtension getExtension() {
            return this.extension;
        }

        @NotNull
        public final JsonNode getJson() {
            return this.json;
        }

        @Override
        @NotNull
        public FloatPcmAudioFilter build(@NotNull AudioDataFormat format, @NotNull FloatPcmAudioFilter output) {
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            FloatPcmAudioFilter floatPcmAudioFilter = this.extension.build(this.json, format, output);
            Intrinsics.checkNotNullExpressionValue((Object)floatPcmAudioFilter, (String)"extension.build(json, format, output)");
            return floatPcmAudioFilter;
        }

        @Override
        public boolean isEnabled() {
            return this.isEnabled;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }
    }
}

