/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.util;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.arbjerg.lavalink.protocol.v3.Player;
import dev.arbjerg.lavalink.protocol.v3.PlaylistInfo;
import dev.arbjerg.lavalink.protocol.v3.Track;
import dev.arbjerg.lavalink.protocol.v3.TrackInfo;
import dev.arbjerg.lavalink.protocol.v3.VoiceState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import lavalink.server.io.SocketContext;
import lavalink.server.io.SocketServer;
import lavalink.server.player.LavalinkPlayer;
import moe.kyokobot.koe.MediaConnection;
import moe.kyokobot.koe.VoiceServerInfo;
import moe.kyokobot.koe.gateway.MediaGatewayConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ResponseStatusException;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u001a\u0016\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u000f\u001a\u0012\u0010\u0010\u001a\u00020\u0011*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0003\u001a\n\u0010\u0013\u001a\u00020\u0014*\u00020\u0015\u001a\u0012\u0010\u0016\u001a\u00020\u0017*\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u0012\u0010\u0016\u001a\u00020\u0017*\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\f\u00a8\u0006\u001b"}, d2={"existingPlayer", "Llavalink/server/player/LavalinkPlayer;", "socketContext", "Llavalink/server/io/SocketContext;", "guildId", "", "getRootCause", "", "throwable", "socketServer", "Llavalink/server/io/SocketServer;", "sessionId", "", "toInfo", "Ldev/arbjerg/lavalink/protocol/v3/TrackInfo;", "Lcom/sedmelluq/discord/lavaplayer/track/AudioTrack;", "toPlayer", "Ldev/arbjerg/lavalink/protocol/v3/Player;", "context", "toPlaylistInfo", "Ldev/arbjerg/lavalink/protocol/v3/PlaylistInfo;", "Lcom/sedmelluq/discord/lavaplayer/track/AudioPlaylist;", "toTrack", "Ldev/arbjerg/lavalink/protocol/v3/Track;", "audioPlayerManager", "Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;", "encoded", "Lavalink-Server"})
public final class UtilKt {
    @NotNull
    public static final Track toTrack(@NotNull AudioTrack $this$toTrack, @NotNull AudioPlayerManager audioPlayerManager) {
        Intrinsics.checkNotNullParameter((Object)$this$toTrack, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)audioPlayerManager, (String)"audioPlayerManager");
        return UtilKt.toTrack($this$toTrack, dev.arbjerg.lavalink.protocol.v3.UtilKt.encodeTrack((AudioPlayerManager)audioPlayerManager, (AudioTrack)$this$toTrack));
    }

    @NotNull
    public static final Track toTrack(@NotNull AudioTrack $this$toTrack, @NotNull String encoded) {
        Intrinsics.checkNotNullParameter((Object)$this$toTrack, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
        return new Track(encoded, encoded, UtilKt.toInfo($this$toTrack));
    }

    @NotNull
    public static final TrackInfo toInfo(@NotNull AudioTrack $this$toInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$toInfo, (String)"<this>");
        String string = $this$toInfo.getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.identifier");
        boolean bl = $this$toInfo.isSeekable();
        String string2 = $this$toInfo.getInfo().author;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this.info.author");
        long l = $this$toInfo.getDuration();
        boolean bl2 = $this$toInfo.getInfo().isStream;
        long l2 = $this$toInfo.getPosition();
        String string3 = $this$toInfo.getInfo().title;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this.info.title");
        String string4 = $this$toInfo.getInfo().uri;
        String string5 = $this$toInfo.getSourceManager().getSourceName();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this.sourceManager.sourceName");
        return new TrackInfo(string, bl, string2, l, bl2, l2, string3, string4, string5);
    }

    @NotNull
    public static final PlaylistInfo toPlaylistInfo(@NotNull AudioPlaylist $this$toPlaylistInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$toPlaylistInfo, (String)"<this>");
        String string = $this$toPlaylistInfo.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.name");
        return new PlaylistInfo(string, $this$toPlaylistInfo.getTracks().indexOf($this$toPlaylistInfo.getSelectedTrack()));
    }

    @NotNull
    public static final Player toPlayer(@NotNull LavalinkPlayer $this$toPlayer, @NotNull SocketContext context) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toPlayer), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        MediaGatewayConnection connection = context.getMediaConnection($this$toPlayer).getGatewayConnection();
        MediaConnection mediaConnection = context.getKoe().getConnection($this$toPlayer.getGuildId());
        VoiceServerInfo voiceServerInfo = mediaConnection != null ? mediaConnection.getVoiceServerInfo() : null;
        String string = String.valueOf($this$toPlayer.getGuildId());
        AudioTrack audioTrack = $this$toPlayer.getTrack();
        Track track2 = audioTrack != null ? UtilKt.toTrack(audioTrack, context.getAudioPlayerManager()) : null;
        int n = $this$toPlayer.getAudioPlayer().getVolume();
        boolean bl = $this$toPlayer.getAudioPlayer().isPaused();
        Object object3 = voiceServerInfo;
        if (object3 == null || (object3 = object3.getToken()) == null) {
            object3 = "";
        }
        if ((object2 = voiceServerInfo) == null || (object2 = object2.getEndpoint()) == null) {
            object2 = "";
        }
        if ((object = voiceServerInfo) == null || (object = object.getSessionId()) == null) {
            object = "";
        }
        MediaGatewayConnection mediaGatewayConnection = connection;
        MediaGatewayConnection mediaGatewayConnection2 = connection;
        return new Player(string, track2, n, bl, new VoiceState((String)object3, (String)object2, (String)object, mediaGatewayConnection != null ? mediaGatewayConnection.isOpen() : false, mediaGatewayConnection2 != null ? mediaGatewayConnection2.getPing() : -1L), $this$toPlayer.getFilters().toFilters());
    }

    @NotNull
    public static final Throwable getRootCause(@Nullable Throwable throwable) {
        Throwable rootCause = throwable;
        while (true) {
            Throwable throwable2 = rootCause;
            Intrinsics.checkNotNull((Object)throwable2);
            if (throwable2.getCause() == null) break;
            rootCause = rootCause.getCause();
        }
        return rootCause;
    }

    @NotNull
    public static final SocketContext socketContext(@NotNull SocketServer socketServer, @NotNull String sessionId) {
        Intrinsics.checkNotNullParameter((Object)((Object)socketServer), (String)"socketServer");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        SocketContext socketContext = socketServer.getContextMap().get(sessionId);
        if (socketContext == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Session not found");
        }
        return socketContext;
    }

    @NotNull
    public static final LavalinkPlayer existingPlayer(@NotNull SocketContext socketContext, long guildId) {
        Intrinsics.checkNotNullParameter((Object)socketContext, (String)"socketContext");
        LavalinkPlayer lavalinkPlayer = socketContext.getPlayers().get(guildId);
        if (lavalinkPlayer == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Player not found");
        }
        return lavalinkPlayer;
    }
}

