/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.io;

import com.sedmelluq.lava.extensions.youtuberotator.planner.AbstractRoutePlanner;
import com.sedmelluq.lava.extensions.youtuberotator.planner.BalancingIpRoutePlanner;
import com.sedmelluq.lava.extensions.youtuberotator.planner.NanoIpRoutePlanner;
import com.sedmelluq.lava.extensions.youtuberotator.planner.RotatingIpRoutePlanner;
import com.sedmelluq.lava.extensions.youtuberotator.planner.RotatingNanoIpRoutePlanner;
import com.sedmelluq.lava.extensions.youtuberotator.tools.ip.IpBlock;
import dev.arbjerg.lavalink.protocol.v4.RoutePlannerFreeAddress;
import dev.arbjerg.lavalink.protocol.v4.RoutePlannerStatus;
import jakarta.servlet.http.HttpServletRequest;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import lavalink.server.io.RoutePlannerRestHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001:\u0001\u0011B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0017J \u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0012J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00062\u0006\u0010\b\u001a\u00020\tH\u0017R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Llavalink/server/io/RoutePlannerRestHandler;", "", "routePlanner", "Lcom/sedmelluq/lava/extensions/youtuberotator/planner/AbstractRoutePlanner;", "(Lcom/sedmelluq/lava/extensions/youtuberotator/planner/AbstractRoutePlanner;)V", "freeAllAddresses", "Lorg/springframework/http/ResponseEntity;", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "freeSingleAddress", "body", "Ldev/arbjerg/lavalink/protocol/v4/RoutePlannerFreeAddress;", "getDetailBlock", "Ldev/arbjerg/lavalink/protocol/v4/RoutePlannerStatus;", "planner", "getStatus", "RoutePlannerDisabledException", "Lavalink-Server"})
@SourceDebugExtension(value={"SMAP\nRoutePlannerRestHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoutePlannerRestHandler.kt\nlavalink/server/io/RoutePlannerRestHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n1549#2:120\n1620#2,3:121\n*S KotlinDebug\n*F\n+ 1 RoutePlannerRestHandler.kt\nlavalink/server/io/RoutePlannerRestHandler\n*L\n72#1:120\n72#1:121,3\n*E\n"})
public class RoutePlannerRestHandler {
    @Nullable
    private final AbstractRoutePlanner routePlanner;

    public RoutePlannerRestHandler(@Nullable AbstractRoutePlanner routePlanner) {
        this.routePlanner = routePlanner;
    }

    @GetMapping(value={"/v4/routeplanner/status"})
    @NotNull
    public ResponseEntity<RoutePlannerStatus> getStatus(@NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.routePlanner == null) {
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.NO_CONTENT)).build();
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"status(HttpStatus.NO_CONTENT).build()");
            return responseEntity;
        }
        RoutePlannerStatus status = this.getDetailBlock(this.routePlanner);
        ResponseEntity responseEntity = ResponseEntity.ok((Object)status);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(status)");
        return responseEntity;
    }

    @PostMapping(value={"/v4/routeplanner/free/address"})
    @NotNull
    public ResponseEntity<Unit> freeSingleAddress(@NotNull HttpServletRequest request, @RequestBody @NotNull RoutePlannerFreeAddress body) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        if (this.routePlanner == null) {
            throw new RoutePlannerDisabledException();
        }
        try {
            InetAddress address = InetAddress.getByName(body.getAddress());
            this.routePlanner.freeAddress(address);
            ResponseEntity responseEntity = ResponseEntity.noContent().build();
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"noContent().build()");
            return responseEntity;
        }
        catch (UnknownHostException exception) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Invalid address: " + exception.getMessage(), (Throwable)exception);
        }
    }

    @PostMapping(value={"/v4/routeplanner/free/all"})
    @NotNull
    public ResponseEntity<Unit> freeAllAddresses(@NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.routePlanner == null) {
            throw new RoutePlannerDisabledException();
        }
        this.routePlanner.freeAllAddresses();
        ResponseEntity responseEntity = ResponseEntity.noContent().build();
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"noContent().build()");
        return responseEntity;
    }

    /*
     * WARNING - void declaration
     */
    private RoutePlannerStatus getDetailBlock(AbstractRoutePlanner planner) {
        RoutePlannerStatus routePlannerStatus;
        void $this$mapTo$iv$iv;
        IpBlock ipBlock = planner.getIpBlock();
        String string = ipBlock.getType().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ipBlock.type.simpleName");
        RoutePlannerStatus.IpBlockStatus.Type type = RoutePlannerStatus.IpBlockStatus.Type.Companion.fromName(string);
        String string2 = ipBlock.getSize().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ipBlock.size.toString()");
        RoutePlannerStatus.IpBlockStatus ipBlockStatus = new RoutePlannerStatus.IpBlockStatus(type, string2);
        Map failingAddresses = planner.getFailingAddresses();
        Iterable $this$map$iv = failingAddresses.entrySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
            String string3 = (String)k;
            Object v = it.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
            long l = ((Number)v).longValue();
            Object v2 = it.getValue();
            Intrinsics.checkNotNullExpressionValue(v2, (String)"it.value");
            String string4 = new Date(((Number)v2).longValue()).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"Date(it.value).toString()");
            collection.add(new RoutePlannerStatus.FailingAddress(string3, l, string4));
        }
        List failingAddressesStatus = (List)destination$iv$iv;
        AbstractRoutePlanner abstractRoutePlanner = planner;
        if (abstractRoutePlanner instanceof RotatingIpRoutePlanner) {
            String string5 = ((RotatingIpRoutePlanner)planner).getRotateIndex().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"planner.rotateIndex.toString()");
            String string6 = ((RotatingIpRoutePlanner)planner).getIndex().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"planner.index.toString()");
            String string7 = ((RotatingIpRoutePlanner)planner).getCurrentAddress().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"planner.currentAddress.toString()");
            routePlannerStatus = (RoutePlannerStatus)new RoutePlannerStatus.RotatingIpRoutePlannerStatus(new RoutePlannerStatus.RotatingIpRoutePlannerStatus.Details(ipBlockStatus, failingAddressesStatus, string5, string6, string7));
        } else if (abstractRoutePlanner instanceof NanoIpRoutePlanner) {
            routePlannerStatus = (RoutePlannerStatus)new RoutePlannerStatus.NanoIpRoutePlannerStatus(new RoutePlannerStatus.NanoIpRoutePlannerStatus.Details(ipBlockStatus, failingAddressesStatus, String.valueOf(((NanoIpRoutePlanner)planner).getCurrentAddress())));
        } else if (abstractRoutePlanner instanceof RotatingNanoIpRoutePlanner) {
            String string8 = ((RotatingNanoIpRoutePlanner)planner).getCurrentBlock().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"planner.currentBlock.toString()");
            routePlannerStatus = (RoutePlannerStatus)new RoutePlannerStatus.RotatingNanoIpRoutePlannerStatus(new RoutePlannerStatus.RotatingNanoIpRoutePlannerStatus.Details(ipBlockStatus, failingAddressesStatus, string8, String.valueOf(((RotatingNanoIpRoutePlanner)planner).getAddressIndexInBlock())));
        } else if (abstractRoutePlanner instanceof BalancingIpRoutePlanner) {
            routePlannerStatus = (RoutePlannerStatus)new RoutePlannerStatus.BalancingIpRoutePlannerStatus(new RoutePlannerStatus.BalancingIpRoutePlannerStatus.Details(ipBlockStatus, failingAddressesStatus));
        } else {
            throw new IllegalStateException(("Received unexpected route planner type: " + Reflection.getOrCreateKotlinClass(planner.getClass()).getSimpleName()).toString());
        }
        return routePlannerStatus;
    }
}

