/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.player;

import com.sedmelluq.discord.lavaplayer.player.AudioLoadResultHandler;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.arbjerg.lavalink.api.AudioPluginInfoModifier;
import dev.arbjerg.lavalink.protocol.v4.LoadResult;
import dev.arbjerg.lavalink.protocol.v4.Track;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import lavalink.server.player.AudioLoader;
import lavalink.server.util.UtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Llavalink/server/player/AudioLoader;", "Lcom/sedmelluq/discord/lavaplayer/player/AudioLoadResultHandler;", "audioPlayerManager", "Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;", "pluginInfoModifiers", "", "Ldev/arbjerg/lavalink/api/AudioPluginInfoModifier;", "(Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;Ljava/util/List;)V", "loadResult", "Ljava/util/concurrent/CompletableFuture;", "Ldev/arbjerg/lavalink/protocol/v4/LoadResult;", "used", "Ljava/util/concurrent/atomic/AtomicBoolean;", "load", "identifier", "", "loadFailed", "", "e", "Lcom/sedmelluq/discord/lavaplayer/tools/FriendlyException;", "noMatches", "playlistLoaded", "audioPlaylist", "Lcom/sedmelluq/discord/lavaplayer/track/AudioPlaylist;", "trackLoaded", "audioTrack", "Lcom/sedmelluq/discord/lavaplayer/track/AudioTrack;", "Companion", "Lavalink-Server"})
@SourceDebugExtension(value={"SMAP\nAudioLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioLoader.kt\nlavalink/server/player/AudioLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1#2:97\n1549#3:98\n1620#3,3:99\n*S KotlinDebug\n*F\n+ 1 AudioLoader.kt\nlavalink/server/player/AudioLoader\n*L\n70#1:98\n70#1:99,3\n*E\n"})
public final class AudioLoader
implements AudioLoadResultHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AudioPlayerManager audioPlayerManager;
    @NotNull
    private final List<AudioPluginInfoModifier> pluginInfoModifiers;
    @NotNull
    private final CompletableFuture<LoadResult> loadResult;
    @NotNull
    private final AtomicBoolean used;
    private static final Logger log = LoggerFactory.getLogger(AudioLoader.class);

    public AudioLoader(@NotNull AudioPlayerManager audioPlayerManager, @NotNull List<? extends AudioPluginInfoModifier> pluginInfoModifiers) {
        Intrinsics.checkNotNullParameter((Object)audioPlayerManager, (String)"audioPlayerManager");
        Intrinsics.checkNotNullParameter(pluginInfoModifiers, (String)"pluginInfoModifiers");
        this.audioPlayerManager = audioPlayerManager;
        this.pluginInfoModifiers = pluginInfoModifiers;
        this.loadResult = new CompletableFuture();
        this.used = new AtomicBoolean(false);
    }

    @NotNull
    public final LoadResult load(@Nullable String identifier) {
        boolean isUsed = this.used.getAndSet(true);
        if (!(!isUsed)) {
            boolean bl = false;
            String string = "This loader can only be used once per instance";
            throw new IllegalStateException(string.toString());
        }
        log.trace("Loading item with identifier " + identifier);
        this.audioPlayerManager.loadItemSync(identifier, (AudioLoadResultHandler)this);
        Object t = this.loadResult.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"loadResult.get()");
        return (LoadResult)t;
    }

    public void trackLoaded(@NotNull AudioTrack audioTrack) {
        Intrinsics.checkNotNullParameter((Object)audioTrack, (String)"audioTrack");
        log.info("Loaded track " + audioTrack.getInfo().title);
        Track track = UtilKt.toTrack((AudioTrack)audioTrack, (AudioPlayerManager)this.audioPlayerManager, (List)this.pluginInfoModifiers);
        this.loadResult.complete(LoadResult.Companion.trackLoaded(track));
    }

    /*
     * WARNING - void declaration
     */
    public void playlistLoaded(@NotNull AudioPlaylist audioPlaylist) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)audioPlaylist, (String)"audioPlaylist");
        log.info("Loaded playlist " + audioPlaylist.getName());
        List list = audioPlaylist.getTracks();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"audioPlaylist.tracks");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AudioTrack audioTrack = (AudioTrack)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(UtilKt.toTrack((AudioTrack)it, (AudioPlayerManager)this.audioPlayerManager, (List)this.pluginInfoModifiers));
        }
        List tracks = (List)destination$iv$iv;
        if (audioPlaylist.isSearchResult()) {
            this.loadResult.complete(LoadResult.Companion.searchResult(tracks));
            return;
        }
        this.loadResult.complete(LoadResult.Companion.playlistLoaded(UtilKt.toPlaylistInfo((AudioPlaylist)audioPlaylist), UtilKt.toPluginInfo((AudioPlaylist)audioPlaylist, (List)this.pluginInfoModifiers), tracks));
    }

    public void noMatches() {
        log.info("No matches found");
        this.loadResult.complete(LoadResult.NoMatches.Companion.invoke());
    }

    public void loadFailed(@NotNull FriendlyException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        log.error("Load failed", (Throwable)e);
        this.loadResult.complete(UtilKt.loadFailed((LoadResult.Companion)LoadResult.Companion, (FriendlyException)e));
    }
}

