/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.player;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.arbjerg.lavalink.api.AudioPluginInfoModifier;
import dev.arbjerg.lavalink.protocol.v4.LoadResult;
import dev.arbjerg.lavalink.protocol.v4.Track;
import dev.arbjerg.lavalink.protocol.v4.Tracks;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import lavalink.server.player.AudioLoader;
import lavalink.server.player.AudioLoaderRestHandler;
import lavalink.server.util.UtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@RestController
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J%\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0017\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\r\u0010\u000eJ&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t2\n\b\u0001\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0017J \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\t2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\u0018\u001a\u00020\u0012H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"Llavalink/server/player/AudioLoaderRestHandler;", "", "audioPlayerManager", "Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;", "pluginInfoModifiers", "", "Ldev/arbjerg/lavalink/api/AudioPluginInfoModifier;", "(Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;Ljava/util/List;)V", "decodeTracks", "Lorg/springframework/http/ResponseEntity;", "Ldev/arbjerg/lavalink/protocol/v4/Tracks;", "encodedTracks", "Ldev/arbjerg/lavalink/protocol/v4/EncodedTracks;", "decodeTracks-x8KJPTo", "(Ljava/util/ArrayList;)Lorg/springframework/http/ResponseEntity;", "getDecodeTrack", "Ldev/arbjerg/lavalink/protocol/v4/Track;", "encodedTrack", "", "track", "loadTracks", "Ldev/arbjerg/lavalink/protocol/v4/LoadResult;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "identifier", "Companion", "Lavalink-Server"})
@SourceDebugExtension(value={"SMAP\nAudioLoaderRestHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioLoaderRestHandler.kt\nlavalink/server/player/AudioLoaderRestHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n1549#2:79\n1620#2,3:80\n*S KotlinDebug\n*F\n+ 1 AudioLoaderRestHandler.kt\nlavalink/server/player/AudioLoaderRestHandler\n*L\n73#1:79\n73#1:80,3\n*E\n"})
public class AudioLoaderRestHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AudioPlayerManager audioPlayerManager;
    @NotNull
    private final List<AudioPluginInfoModifier> pluginInfoModifiers;
    private static final Logger log = LoggerFactory.getLogger(AudioLoaderRestHandler.class);

    public AudioLoaderRestHandler(@NotNull AudioPlayerManager audioPlayerManager, @NotNull List<? extends AudioPluginInfoModifier> pluginInfoModifiers) {
        Intrinsics.checkNotNullParameter((Object)audioPlayerManager, (String)"audioPlayerManager");
        Intrinsics.checkNotNullParameter(pluginInfoModifiers, (String)"pluginInfoModifiers");
        this.audioPlayerManager = audioPlayerManager;
        this.pluginInfoModifiers = pluginInfoModifiers;
    }

    @GetMapping(value={"/v4/loadtracks"})
    @NotNull
    public ResponseEntity<LoadResult> loadTracks(@NotNull HttpServletRequest request, @RequestParam @NotNull String identifier) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        log.info("Got request to load for identifier \"" + identifier + "\"");
        ResponseEntity responseEntity = ResponseEntity.ok((Object)new AudioLoader(this.audioPlayerManager, this.pluginInfoModifiers).load(identifier));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(AudioLoader(audioPlay\u2026ifiers).load(identifier))");
        return responseEntity;
    }

    @GetMapping(value={"/v4/decodetrack"})
    @NotNull
    public ResponseEntity<Track> getDecodeTrack(@RequestParam @Nullable String encodedTrack, @RequestParam @Nullable String track) {
        String string = encodedTrack;
        if (string == null && (string = track) == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "No track to decode provided");
        }
        String trackToDecode = string;
        ResponseEntity responseEntity = ResponseEntity.ok((Object)UtilKt.toTrack((AudioTrack)UtilKt.decodeTrack((AudioPlayerManager)this.audioPlayerManager, (String)trackToDecode), (String)trackToDecode, (List)this.pluginInfoModifiers));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(decodeTrack(audioPlay\u2026de, pluginInfoModifiers))");
        return responseEntity;
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/v4/decodetracks"})
    @NotNull
    public ResponseEntity<Tracks> decodeTracks-x8KJPTo(@RequestBody @NotNull ArrayList<String> encodedTracks) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(encodedTracks, (String)"encodedTracks");
        if (encodedTracks.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "No tracks to decode provided");
        }
        Iterable $this$map$iv = encodedTracks;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(UtilKt.toTrack((AudioTrack)UtilKt.decodeTrack((AudioPlayerManager)this.audioPlayerManager, (String)it), (String)it, (List)this.pluginInfoModifiers));
        }
        ResponseEntity responseEntity = ResponseEntity.ok((Object)Tracks.box-impl((List)Tracks.constructor-impl((List)((List)destination$iv$iv))));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(Tracks(encodedTracks.\u2026nfoModifiers)\n        }))");
        return responseEntity;
    }
}

