/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.player;

import com.sedmelluq.discord.lavaplayer.player.event.AudioEvent;
import com.sedmelluq.discord.lavaplayer.player.event.AudioEventListener;
import com.sedmelluq.discord.lavaplayer.player.event.PlayerPauseEvent;
import com.sedmelluq.discord.lavaplayer.player.event.PlayerResumeEvent;
import com.sedmelluq.discord.lavaplayer.player.event.TrackEndEvent;
import com.sedmelluq.discord.lavaplayer.player.event.TrackStartEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import lavalink.server.player.AudioLossCounter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u0015J\u0006\u0010\u001a\u001a\u00020\u0015J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u001e\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Llavalink/server/player/AudioLossCounter;", "Lcom/sedmelluq/discord/lavaplayer/player/event/AudioEventListener;", "()V", "curLoss", "", "curMinute", "", "curSucc", "isDataUsable", "", "()Z", "<set-?>", "lastMinuteLoss", "getLastMinuteLoss", "()I", "lastMinuteSuccess", "getLastMinuteSuccess", "lastTrackEnded", "lastTrackStarted", "playingSince", "checkTime", "", "onEvent", "event", "Lcom/sedmelluq/discord/lavaplayer/player/event/AudioEvent;", "onLoss", "onSuccess", "toString", "", "Companion", "Lavalink-Server"})
public final class AudioLossCounter
implements AudioEventListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long playingSince = Long.MAX_VALUE;
    private long lastTrackStarted = 0x3FFFFFFFFFFFFFFFL;
    private long lastTrackEnded = Long.MAX_VALUE;
    private long curMinute;
    private int curLoss;
    private int curSucc;
    private int lastMinuteLoss;
    private int lastMinuteSuccess;
    public static final int EXPECTED_PACKET_COUNT_PER_MIN = 3000;
    private static final int ACCEPTABLE_TRACK_SWITCH_TIME = 100;

    public final int getLastMinuteLoss() {
        return this.lastMinuteLoss;
    }

    public final int getLastMinuteSuccess() {
        return this.lastMinuteSuccess;
    }

    public final void onLoss() {
        this.checkTime();
        int n = this.curLoss;
        this.curLoss = n + 1;
    }

    public final void onSuccess() {
        this.checkTime();
        int n = this.curSucc;
        this.curSucc = n + 1;
    }

    public final boolean isDataUsable() {
        if (this.lastTrackStarted - this.lastTrackEnded > 100L && this.lastTrackEnded != Long.MAX_VALUE) {
            return false;
        }
        long lastMin = System.currentTimeMillis() / (long)60000 - 1L;
        return this.playingSince < lastMin * (long)60000;
    }

    private final void checkTime() {
        long actualMinute = System.currentTimeMillis() / (long)60000;
        if (this.curMinute != actualMinute) {
            this.lastMinuteLoss = this.curLoss;
            this.lastMinuteSuccess = this.curSucc;
            this.curLoss = 0;
            this.curSucc = 0;
            this.curMinute = actualMinute;
        }
    }

    public void onEvent(@NotNull AudioEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        AudioEvent audioEvent = event;
        if (audioEvent instanceof PlayerPauseEvent ? true : audioEvent instanceof TrackEndEvent) {
            this.lastTrackEnded = System.currentTimeMillis();
        } else if (audioEvent instanceof PlayerResumeEvent ? true : audioEvent instanceof TrackStartEvent) {
            this.lastTrackStarted = System.currentTimeMillis();
            if (this.lastTrackStarted - this.lastTrackEnded > 100L || this.playingSince == Long.MAX_VALUE) {
                this.playingSince = System.currentTimeMillis();
                this.lastTrackEnded = Long.MAX_VALUE;
            }
        }
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u240.append("AudioLossCounter{");
        $this$toString_u24lambda_u240.append("lastLoss=" + this.lastMinuteLoss + ", ");
        $this$toString_u24lambda_u240.append("lastSucc=" + this.lastMinuteSuccess + ", ");
        $this$toString_u24lambda_u240.append("total=" + (this.lastMinuteSuccess + this.lastMinuteLoss));
        $this$toString_u24lambda_u240.append('}');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }
}

