/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.common;

import com.sedmelluq.discord.lavaplayer.filter.AudioPipeline;
import com.sedmelluq.discord.lavaplayer.filter.AudioPipelineFactory;
import com.sedmelluq.discord.lavaplayer.filter.PcmFormat;
import com.sedmelluq.discord.lavaplayer.natives.aac.AacDecoder;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import net.sourceforge.jaad.aac.Decoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AacPacketRouter {
    private static final Logger log = LoggerFactory.getLogger(AacPacketRouter.class);
    private final AudioProcessingContext context;
    private Long initialRequestedTimecode;
    private Long initialProvidedTimecode;
    private AudioPipeline downstream;
    private ShortBuffer outputBuffer;
    public AacDecoder nativeDecoder;
    public Decoder embeddedDecoder;

    public AacPacketRouter(AudioProcessingContext context) {
        this.context = context;
    }

    public void processInput(ByteBuffer inputBuffer) throws InterruptedException {
        if (this.embeddedDecoder == null) {
            this.nativeDecoder.fill(inputBuffer);
            if (this.downstream == null) {
                log.debug("Using native decoder");
                AacDecoder.StreamInfo streamInfo = this.nativeDecoder.resolveStreamInfo();
                if (streamInfo != null) {
                    this.downstream = AudioPipelineFactory.create(this.context, new PcmFormat(streamInfo.channels, streamInfo.sampleRate));
                    this.outputBuffer = ByteBuffer.allocateDirect(2 * streamInfo.frameSize * streamInfo.channels).order(ByteOrder.nativeOrder()).asShortBuffer();
                    if (this.initialRequestedTimecode != null) {
                        this.downstream.seekPerformed(this.initialRequestedTimecode, this.initialProvidedTimecode);
                    }
                }
            }
            if (this.downstream != null) {
                while (this.nativeDecoder.decode(this.outputBuffer, false)) {
                    this.downstream.process(this.outputBuffer);
                    this.outputBuffer.clear();
                }
            }
        } else {
            if (this.downstream == null) {
                log.debug("Using embedded decoder");
                this.downstream = AudioPipelineFactory.create(this.context, new PcmFormat(this.embeddedDecoder.getAudioFormat().getChannels(), (int)this.embeddedDecoder.getAudioFormat().getSampleRate()));
                if (this.initialRequestedTimecode != null) {
                    this.downstream.seekPerformed(this.initialRequestedTimecode, this.initialProvidedTimecode);
                }
            }
            if (this.downstream != null) {
                this.downstream.process(this.embeddedDecoder.decodeFrame(inputBuffer.array()));
            }
        }
    }

    public void seekPerformed(long requestedTimecode, long providedTimecode) {
        if (this.downstream != null) {
            this.downstream.seekPerformed(requestedTimecode, providedTimecode);
        } else {
            this.initialRequestedTimecode = requestedTimecode;
            this.initialProvidedTimecode = providedTimecode;
        }
        if (this.nativeDecoder != null) {
            this.nativeDecoder.close();
            this.nativeDecoder = null;
        } else if (this.embeddedDecoder != null) {
            this.embeddedDecoder = null;
        }
    }

    public void flush() throws InterruptedException {
        if (this.downstream != null) {
            while (this.nativeDecoder.decode(this.outputBuffer, true)) {
                this.downstream.process(this.outputBuffer);
                this.outputBuffer.clear();
            }
        }
    }

    public void close() {
        try {
            if (this.downstream != null) {
                this.downstream.close();
            }
        }
        finally {
            if (this.nativeDecoder != null) {
                this.nativeDecoder.close();
            } else if (this.embeddedDecoder != null) {
                this.embeddedDecoder = null;
            }
        }
    }
}

