/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.mpeg;

import com.sedmelluq.discord.lavaplayer.container.common.AacPacketRouter;
import com.sedmelluq.discord.lavaplayer.container.mpeg.MpegTrackConsumer;
import com.sedmelluq.discord.lavaplayer.container.mpeg.MpegTrackInfo;
import com.sedmelluq.discord.lavaplayer.natives.aac.AacDecoder;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ReadableByteChannel;
import net.sourceforge.jaad.aac.Decoder;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MpegAacTrackConsumer
implements MpegTrackConsumer {
    private static final Logger log = LoggerFactory.getLogger(MpegAacTrackConsumer.class);
    private final MpegTrackInfo track;
    private final AacPacketRouter packetRouter;
    private ByteBuffer inputBuffer;
    private boolean configured;

    public MpegAacTrackConsumer(AudioProcessingContext context, MpegTrackInfo track) {
        this.track = track;
        this.packetRouter = new AacPacketRouter(context);
    }

    @Override
    public void initialise() {
        log.debug("Initialising AAC track with expected frequency {} and channel count {}.", (Object)this.track.sampleRate, (Object)this.track.channelCount);
    }

    @Override
    public MpegTrackInfo getTrack() {
        return this.track;
    }

    @Override
    public void seekPerformed(long requestedTimecode, long providedTimecode) {
        this.packetRouter.seekPerformed(requestedTimecode, providedTimecode);
    }

    @Override
    public void flush() throws InterruptedException {
        this.packetRouter.flush();
    }

    @Override
    public void consume(ReadableByteChannel channel, int length) throws InterruptedException {
        if (this.packetRouter.nativeDecoder == null) {
            this.packetRouter.nativeDecoder = new AacDecoder();
            this.configured = this.configureDecoder(this.packetRouter.nativeDecoder);
        }
        if (this.configured) {
            if (this.inputBuffer == null) {
                this.inputBuffer = ByteBuffer.allocateDirect(4096);
            }
            this.processInput(channel, length);
        } else {
            if (this.packetRouter.embeddedDecoder == null) {
                this.packetRouter.embeddedDecoder = this.track.decoderConfig != null ? Decoder.create((byte[])this.track.decoderConfig) : Decoder.create((int)2, (int)this.track.sampleRate, (int)this.track.channelCount);
                this.inputBuffer = ByteBuffer.allocate(4096);
            }
            this.processInput(channel, length);
        }
    }

    private void processInput(ReadableByteChannel channel, int length) throws InterruptedException {
        int chunk;
        for (int remaining = length; remaining > 0; remaining -= chunk) {
            chunk = Math.min(remaining, this.inputBuffer.capacity());
            this.inputBuffer.clear();
            this.inputBuffer.limit(chunk);
            try {
                IOUtils.readFully((ReadableByteChannel)channel, (ByteBuffer)this.inputBuffer);
            }
            catch (ClosedByInterruptException e) {
                log.trace("Interrupt received while reading channel", (Throwable)e);
                Thread.currentThread().interrupt();
                throw new InterruptedException();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.inputBuffer.flip();
            this.packetRouter.processInput(this.inputBuffer);
        }
    }

    @Override
    public void close() {
        this.packetRouter.close();
    }

    private boolean configureDecoder(AacDecoder decoder) {
        if (this.track.decoderConfig != null) {
            return decoder.configure(this.track.decoderConfig) == 0;
        }
        return decoder.configure(2, this.track.sampleRate, this.track.channelCount) == 0;
    }
}

