/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.tools.io;

import com.sedmelluq.discord.lavaplayer.track.info.AudioTrackInfoProvider;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public abstract class SeekableInputStream
extends InputStream {
    protected long contentLength;
    private final long maxSkipDistance;

    public SeekableInputStream(long contentLength, long maxSkipDistance) {
        this.contentLength = contentLength;
        this.maxSkipDistance = maxSkipDistance;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public long getMaxSkipDistance() {
        return this.maxSkipDistance;
    }

    public abstract long getPosition();

    protected abstract void seekHard(long var1) throws IOException;

    public abstract boolean canSeekHard();

    public void skipFully(long distance) throws IOException {
        long skipped;
        long current;
        long target = current + distance;
        for (current = this.getPosition(); current < target; current += skipped) {
            skipped = this.skip(target - current);
            if (skipped != 0L) continue;
            if (this.read() == -1) {
                throw new EOFException("Cannot skip any further.");
            }
            skipped = 1L;
        }
    }

    public void seek(long position) throws IOException {
        long current = this.getPosition();
        if (current != position) {
            if (current <= position && position - current <= this.maxSkipDistance) {
                this.skipFully(position - current);
            } else if (!this.canSeekHard()) {
                if (current > position) {
                    this.seekHard(0L);
                    this.skipFully(position);
                } else {
                    this.skipFully(position - current);
                }
            } else {
                this.seekHard(position);
            }
        }
    }

    public abstract List<AudioTrackInfoProvider> getTrackInfoProviders();
}

