/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.matroska;

import com.sedmelluq.discord.lavaplayer.container.matroska.MatroskaAacTrackConsumer;
import com.sedmelluq.discord.lavaplayer.container.matroska.MatroskaOpusTrackConsumer;
import com.sedmelluq.discord.lavaplayer.container.matroska.MatroskaStreamingFile;
import com.sedmelluq.discord.lavaplayer.container.matroska.MatroskaTrackConsumer;
import com.sedmelluq.discord.lavaplayer.container.matroska.MatroskaVorbisTrackConsumer;
import com.sedmelluq.discord.lavaplayer.container.matroska.format.MatroskaFileTrack;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.BaseAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatroskaAudioTrack
extends BaseAudioTrack {
    private static final Logger log = LoggerFactory.getLogger(MatroskaAudioTrack.class);
    private final SeekableInputStream inputStream;

    public MatroskaAudioTrack(AudioTrackInfo trackInfo, SeekableInputStream inputStream) {
        super(trackInfo);
        this.inputStream = inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(LocalAudioTrackExecutor localExecutor) {
        MatroskaStreamingFile file = this.loadMatroskaFile();
        MatroskaTrackConsumer trackConsumer = this.loadAudioTrack(file, localExecutor.getProcessingContext());
        try {
            localExecutor.executeProcessingLoop(() -> file.provideFrames(trackConsumer), position -> file.seekToTimecode(trackConsumer.getTrack().index, position));
        }
        finally {
            ExceptionTools.closeWithWarnings(trackConsumer);
        }
    }

    private MatroskaStreamingFile loadMatroskaFile() {
        try {
            MatroskaStreamingFile file = new MatroskaStreamingFile(this.inputStream);
            file.readFile();
            this.accurateDuration.set((int)file.getDuration());
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MatroskaTrackConsumer loadAudioTrack(MatroskaStreamingFile file, AudioProcessingContext context) {
        MatroskaTrackConsumer trackConsumer = null;
        boolean success = false;
        try {
            trackConsumer = this.selectAudioTrack(file.getTrackList(), context);
            if (trackConsumer == null) {
                throw new IllegalStateException("No supported audio tracks in the file.");
            }
            log.debug("Starting to play track with codec {}", (Object)trackConsumer.getTrack().codecId);
            trackConsumer.initialise();
            success = true;
        }
        finally {
            if (!success && trackConsumer != null) {
                ExceptionTools.closeWithWarnings(trackConsumer);
            }
        }
        return trackConsumer;
    }

    private MatroskaTrackConsumer selectAudioTrack(MatroskaFileTrack[] tracks, AudioProcessingContext context) {
        MatroskaTrackConsumer trackConsumer = null;
        for (MatroskaFileTrack track : tracks) {
            if (track.type != MatroskaFileTrack.Type.AUDIO) continue;
            if ("A_OPUS".equals(track.codecId)) {
                trackConsumer = new MatroskaOpusTrackConsumer(context, track);
                break;
            }
            if ("A_VORBIS".equals(track.codecId)) {
                trackConsumer = new MatroskaVorbisTrackConsumer(context, track);
                continue;
            }
            if (!"A_AAC".equals(track.codecId)) continue;
            trackConsumer = new MatroskaAacTrackConsumer(context, track);
        }
        return trackConsumer;
    }
}

