/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.filter.converter;

import com.sedmelluq.discord.lavaplayer.filter.FloatPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.converter.ConverterAudioFilter;
import java.nio.ShortBuffer;

public class ToFloatAudioFilter
extends ConverterAudioFilter {
    private final FloatPcmAudioFilter downstream;
    private final int channelCount;
    private final float[][] buffers;

    public ToFloatAudioFilter(FloatPcmAudioFilter downstream, int channelCount) {
        this.downstream = downstream;
        this.channelCount = channelCount;
        this.buffers = new float[channelCount][];
        for (int i = 0; i < channelCount; ++i) {
            this.buffers[i] = new float[4096];
        }
    }

    @Override
    public void process(float[][] input, int offset, int length) throws InterruptedException {
        this.downstream.process(input, offset, length);
    }

    @Override
    public void process(short[] input, int offset, int length) throws InterruptedException {
        int end = offset + length;
        while (end - offset >= this.channelCount) {
            int chunkLength = Math.min((end - offset) / this.channelCount, 4096);
            for (int chunkPosition = 0; chunkPosition < chunkLength; ++chunkPosition) {
                for (int channel = 0; channel < this.channelCount; ++channel) {
                    this.buffers[channel][chunkPosition] = ToFloatAudioFilter.shortToFloat(input[offset++]);
                }
            }
            this.downstream.process(this.buffers, 0, chunkLength);
        }
    }

    @Override
    public void process(ShortBuffer buffer) throws InterruptedException {
        int chunkLength;
        while (buffer.hasRemaining() && (chunkLength = Math.min(buffer.remaining() / this.channelCount, 4096)) != 0) {
            for (int chunkPosition = 0; chunkPosition < chunkLength; ++chunkPosition) {
                for (int channel = 0; channel < this.buffers.length; ++channel) {
                    this.buffers[channel][chunkPosition] = ToFloatAudioFilter.shortToFloat(buffer.get());
                }
            }
            this.downstream.process(this.buffers, 0, chunkLength);
        }
    }

    @Override
    public void process(short[][] input, int offset, int length) throws InterruptedException {
        int end = offset + length;
        while (offset < end) {
            int chunkLength = Math.min(end - offset, 4096);
            for (int channel = 0; channel < this.buffers.length; ++channel) {
                for (int chunkPosition = 0; chunkPosition < chunkLength; ++chunkPosition) {
                    this.buffers[channel][chunkPosition] = ToFloatAudioFilter.shortToFloat(input[channel][offset + chunkPosition]);
                }
            }
            offset += chunkLength;
            this.downstream.process(this.buffers, 0, chunkLength);
        }
    }

    private static float shortToFloat(short value) {
        return (float)value / 32768.0f;
    }
}

