/*
 * Decompiled with CFR 0.152.
 */
package dev.lavalink.youtube.clients;

import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.lavalink.youtube.YoutubeAudioSourceManager;
import dev.lavalink.youtube.clients.Android;
import dev.lavalink.youtube.clients.ClientConfig;
import dev.lavalink.youtube.clients.ClientOptions;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidMusic
extends Android {
    public static String CLIENT_VERSION = "7.11.50";
    public static ClientConfig BASE_CONFIG = new ClientConfig().withApiKey(Android.BASE_CONFIG.getApiKey()).withClientName("ANDROID_MUSIC").withClientField("clientVersion", CLIENT_VERSION).withUserAgent(String.format("com.google.android.apps.youtube.music/%s (Linux; U; Android %s) gzip", CLIENT_VERSION, ANDROID_VERSION.getOsVersion()));

    public AndroidMusic() {
        this(ClientOptions.DEFAULT);
    }

    public AndroidMusic(@NotNull ClientOptions options) {
        super(options, false);
    }

    @Override
    @NotNull
    protected ClientConfig getBaseClientConfig(@NotNull HttpInterface httpInterface) {
        return BASE_CONFIG.copy();
    }

    @Override
    @NotNull
    protected JsonBrowser extractMixPlaylistData(@NotNull JsonBrowser json) {
        return json.get("contents").get("singleColumnMusicWatchNextResultsRenderer").get("tabbedRenderer").get("watchNextTabbedResultsRenderer").get("tabs").values().stream().filter(tab -> "Up next".equalsIgnoreCase(tab.get("tabRenderer").get("title").text())).findFirst().orElse(json).get("tabRenderer").get("content").get("musicQueueRenderer").get("content").get("playlistPanelRenderer");
    }

    @Override
    @NotNull
    protected List<AudioTrack> extractSearchResults(@NotNull YoutubeAudioSourceManager source, @NotNull JsonBrowser json) {
        return json.get("contents").get("tabbedSearchResultsRenderer").get("tabs").values().stream().flatMap(item -> item.get("tabRenderer").get("content").get("sectionListRenderer").get("contents").values().stream()).map(item -> this.extractAudioTrack(item.get("musicCardShelfRenderer"), source)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    @Nullable
    protected AudioTrack extractAudioTrack(@NotNull JsonBrowser json, @NotNull YoutubeAudioSourceManager source) {
        if (json.isNull() || !json.get("unplayableText").isNull()) {
            return null;
        }
        AudioTrack track = super.extractAudioTrack(json, source);
        if (track != null) {
            return track;
        }
        String videoId = json.get("onTap").get("watchEndpoint").get("videoId").text();
        if (videoId == null) {
            return null;
        }
        JsonBrowser titleJson = json.get("title");
        JsonBrowser secondaryJson = json.get("menu").get("menuRenderer").get("title").get("musicMenuTitleRenderer").get("secondaryText").get("runs");
        String title = (String)DataFormatTools.defaultOnNull((Object)titleJson.get("runs").index(0).get("text").text(), (Object)titleJson.get("simpleText").text());
        String author = secondaryJson.index(0).get("text").text();
        JsonBrowser durationJson = secondaryJson.index(2);
        String durationText = (String)DataFormatTools.defaultOnNull((Object)durationJson.get("text").text(), (Object)durationJson.get("runs").index(0).get("text").text());
        long duration = DataFormatTools.durationTextToMillis((String)durationText);
        return this.buildAudioTrack(source, json, title, author, duration, videoId, false);
    }

    @Override
    public boolean canHandleRequest(@NotNull String identifier) {
        return (!identifier.contains("list=") || identifier.contains("list=RD")) && super.canHandleRequest(identifier);
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return BASE_CONFIG.getName();
    }

    @Override
    public AudioItem loadPlaylist(@NotNull YoutubeAudioSourceManager source, @NotNull HttpInterface httpInterface, @NotNull String playlistId, @Nullable String selectedVideoId) {
        throw new FriendlyException("This client cannot load playlists", FriendlyException.Severity.COMMON, (Throwable)new RuntimeException("ANDROID_MUSIC cannot be used to load playlists"));
    }
}

