/*
 * Decompiled with CFR 0.152.
 */
package dev.lavalink.youtube.clients.skeleton;

import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import dev.lavalink.youtube.CannotBeLoaded;
import dev.lavalink.youtube.YoutubeAudioSourceManager;
import dev.lavalink.youtube.cipher.SignatureCipherManager;
import dev.lavalink.youtube.clients.skeleton.NonMusicClient;
import dev.lavalink.youtube.track.format.StreamFormat;
import dev.lavalink.youtube.track.format.TrackFormats;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.http.entity.ContentType;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StreamingNonMusicClient
extends NonMusicClient {
    private static final Logger log = LoggerFactory.getLogger(StreamingNonMusicClient.class);
    protected static String DEFAULT_SIGNATURE_KEY = "signature";

    @Override
    public TrackFormats loadFormats(@NotNull YoutubeAudioSourceManager source, @NotNull HttpInterface httpInterface, @NotNull String videoId) throws CannotBeLoaded, IOException {
        JsonBrowser json = this.loadTrackInfoFromInnertube(source, httpInterface, videoId, null);
        JsonBrowser playabilityStatus = json.get("playabilityStatus");
        JsonBrowser videoDetails = json.get("videoDetails");
        SignatureCipherManager.CachedPlayerScript playerScript = source.getCipherManager().getCachedPlayerScript(httpInterface);
        boolean isLive = videoDetails.get("isLive").asBoolean(false);
        if ("OK".equals(playabilityStatus.get("status").text()) && playabilityStatus.get("reason").safeText().contains("This live event has ended")) {
            isLive = true;
        }
        JsonBrowser streamingData = json.get("streamingData");
        JsonBrowser mergedFormats = streamingData.get("formats");
        JsonBrowser adaptiveFormats = streamingData.get("adaptiveFormats");
        ArrayList<StreamFormat> formats = new ArrayList<StreamFormat>();
        boolean anyFailures = false;
        for (JsonBrowser merged : mergedFormats.values()) {
            anyFailures = anyFailures || !this.extractFormat(merged, formats, isLive);
        }
        for (JsonBrowser adaptive : adaptiveFormats.values()) {
            anyFailures = anyFailures || !this.extractFormat(adaptive, formats, isLive);
        }
        if (formats.isEmpty() && anyFailures) {
            log.warn("Loading formats either failed to load or were skipped due to missing fields, json: {}", (Object)streamingData.format());
        }
        return new TrackFormats(formats, playerScript.url);
    }

    protected boolean extractFormat(JsonBrowser formatJson, List<StreamFormat> formats, boolean isLive) {
        if (formatJson.isNull() || !formatJson.isMap()) {
            return false;
        }
        String url = formatJson.get("url").text();
        String cipher = formatJson.get("signatureCipher").text();
        Map cipherInfo = cipher != null ? DataFormatTools.decodeUrlEncodedItems((String)cipher, (boolean)true) : Collections.emptyMap();
        Map urlMap = DataFormatTools.isNullOrEmpty((String)url) ? DataFormatTools.decodeUrlEncodedItems((String)((String)cipherInfo.get("url")), (boolean)false) : DataFormatTools.decodeUrlEncodedItems((String)url, (boolean)false);
        try {
            long contentLength = formatJson.get("contentLength").asLong(Long.MAX_VALUE);
            if (contentLength == Long.MAX_VALUE && !isLive) {
                log.debug("Track is not a live stream, but no contentLength in format {}, skipping", (Object)formatJson.format());
                return true;
            }
            formats.add(new StreamFormat(ContentType.parse((String)formatJson.get("mimeType").text()), (int)formatJson.get("itag").asLong(-1L), formatJson.get("bitrate").asLong(-1L), contentLength, formatJson.get("audioChannels").asLong(2L), cipherInfo.getOrDefault("url", url), (String)urlMap.get("n"), (String)cipherInfo.get("s"), cipherInfo.getOrDefault("sp", DEFAULT_SIGNATURE_KEY), formatJson.get("audioTrack").get("audioIsDefault").asBoolean(true), formatJson.get("isDrc").asBoolean(false)));
            return true;
        }
        catch (RuntimeException e) {
            log.debug("Failed to parse format {}, skipping", (Object)formatJson, (Object)e);
            return false;
        }
    }
}

