/*
 * Decompiled with CFR 0.152.
 */
package dev.lavalink.youtube.clients.skeleton;

import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import dev.lavalink.youtube.CannotBeLoaded;
import dev.lavalink.youtube.YoutubeAudioSourceManager;
import dev.lavalink.youtube.clients.ClientOptions;
import dev.lavalink.youtube.track.format.TrackFormats;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Client {
    public static final String WATCH_URL = "https://www.youtube.com/watch?v=";
    public static final String API_BASE_URL = "https://youtubei.googleapis.com/youtubei/v1";
    public static final String PLAYER_URL = "https://youtubei.googleapis.com/youtubei/v1/player?prettyPrint=false";
    public static final String SEARCH_URL = "https://youtubei.googleapis.com/youtubei/v1/search?prettyPrint=false";
    public static final String NEXT_URL = "https://youtubei.googleapis.com/youtubei/v1/next?prettyPrint=false";
    public static final String BROWSE_URL = "https://youtubei.googleapis.com/youtubei/v1/browse?prettyPrint=false";
    public static final String MUSIC_API_BASE_URL = "https://music.youtube.com/youtubei/v1";
    public static final String MUSIC_SEARCH_URL = "https://music.youtube.com/youtubei/v1/search?prettyPrint=false";
    public static final String SEARCH_PARAMS = "EgIQAfABAQ==";
    public static final String MUSIC_SEARCH_PARAMS = "Eg-KAQwIARAAGAAgACgAMABqChADEAQQCRAFEAo=";

    @NotNull
    default public PlayabilityStatus getPlayabilityStatus(@NotNull JsonBrowser playabilityStatus, boolean throwOnNotOk) throws CannotBeLoaded {
        String status = playabilityStatus.get("status").text();
        if (playabilityStatus.isNull() || status == null) {
            throw new RuntimeException("No playability status block.");
        }
        switch (status) {
            case "OK": {
                return PlayabilityStatus.OK;
            }
            case "ERROR": {
                String reason = playabilityStatus.get("reason").text();
                throw new FriendlyException(reason, FriendlyException.Severity.COMMON, null);
            }
            case "UNPLAYABLE": {
                String unplayableReason = this.getUnplayableReason(playabilityStatus);
                if (unplayableReason == null) {
                    throw new FriendlyException("This video is unplayable.", FriendlyException.Severity.SUSPICIOUS, null);
                }
                if (unplayableReason.contains("Playback on other websites has been disabled by the video owner") && !throwOnNotOk) {
                    return PlayabilityStatus.NON_EMBEDDABLE;
                }
                throw new FriendlyException(unplayableReason, FriendlyException.Severity.COMMON, null);
            }
            case "LOGIN_REQUIRED": {
                String loginReason = playabilityStatus.get("reason").safeText();
                if (loginReason.contains("This video is private")) {
                    throw new CannotBeLoaded((Throwable)new FriendlyException("This is a private video.", FriendlyException.Severity.COMMON, null));
                }
                if (loginReason.contains("This video may be inappropriate for some users")) {
                    throw new FriendlyException("This video requires age verification.", FriendlyException.Severity.SUSPICIOUS, null);
                }
                throw new FriendlyException("This video requires login.", FriendlyException.Severity.COMMON, null);
            }
            case "CONTENT_CHECK_REQUIRED": {
                throw new FriendlyException(this.getUnplayableReason(playabilityStatus), FriendlyException.Severity.COMMON, null);
            }
            case "LIVE_STREAM_OFFLINE": {
                if (!playabilityStatus.get("errorScreen").get("ypcTrailerRenderer").isNull()) {
                    throw new FriendlyException("This trailer cannot be loaded.", FriendlyException.Severity.COMMON, null);
                }
                throw new FriendlyException(this.getUnplayableReason(playabilityStatus), FriendlyException.Severity.COMMON, null);
            }
        }
        throw new FriendlyException("This video cannot be viewed anonymously.", FriendlyException.Severity.COMMON, null);
    }

    @Nullable
    default public String getUnplayableReason(@NotNull JsonBrowser statusBlock) {
        JsonBrowser playerErrorMessage = statusBlock.get("errorScreen").get("playerErrorMessageRenderer");
        if (!playerErrorMessage.get("subreason").isNull()) {
            JsonBrowser subreason = playerErrorMessage.get("subreason");
            if (!subreason.get("simpleText").isNull()) {
                return subreason.get("simpleText").text();
            }
            if (!subreason.get("runs").isNull() && subreason.get("runs").isList()) {
                return subreason.get("runs").values().stream().map(item -> item.get("text").text()).collect(Collectors.joining("\n"));
            }
        }
        return statusBlock.get("reason").text();
    }

    @Nullable
    default public AudioTrack findSelectedTrack(@NotNull List<AudioTrack> tracks, @Nullable String selectedVideoId) {
        if (selectedVideoId != null) {
            return tracks.stream().filter(track -> selectedVideoId.equals(track.getIdentifier())).findFirst().orElse(null);
        }
        return null;
    }

    @NotNull
    default public URI transformPlaybackUri(@NotNull URI originalUri, @NotNull URI resolvedPlaybackUri) {
        return resolvedPlaybackUri;
    }

    @NotNull
    default public AudioTrack buildAudioTrack(@NotNull YoutubeAudioSourceManager source, @NotNull JsonBrowser json, @NotNull String title, @NotNull String author, long duration, @NotNull String videoId, boolean isStream) {
        AudioTrackInfo info = new AudioTrackInfo(title, author, duration, videoId, isStream, WATCH_URL + videoId);
        return source.buildAudioTrack(info);
    }

    @NotNull
    public String getIdentifier();

    @NotNull
    public String getPlayerParams();

    @NotNull
    default public ClientOptions getOptions() {
        return ClientOptions.DEFAULT;
    }

    public boolean canHandleRequest(@NotNull String var1);

    default public boolean supportsFormatLoading() {
        return this.getOptions().getPlayback();
    }

    default public boolean isEmbedded() {
        return false;
    }

    public void setPlaylistPageCount(int var1);

    @Nullable
    public TrackFormats loadFormats(@NotNull YoutubeAudioSourceManager var1, @NotNull HttpInterface var2, @NotNull String var3) throws CannotBeLoaded, IOException;

    @Nullable
    public AudioItem loadVideo(@NotNull YoutubeAudioSourceManager var1, @NotNull HttpInterface var2, @NotNull String var3) throws CannotBeLoaded, IOException;

    @Nullable
    public AudioItem loadSearch(@NotNull YoutubeAudioSourceManager var1, @NotNull HttpInterface var2, @NotNull String var3) throws CannotBeLoaded, IOException;

    @Nullable
    public AudioItem loadSearchMusic(@NotNull YoutubeAudioSourceManager var1, @NotNull HttpInterface var2, @NotNull String var3) throws CannotBeLoaded, IOException;

    @Nullable
    public AudioItem loadMix(@NotNull YoutubeAudioSourceManager var1, @NotNull HttpInterface var2, @NotNull String var3, @Nullable String var4) throws CannotBeLoaded, IOException;

    @Nullable
    public AudioItem loadPlaylist(@NotNull YoutubeAudioSourceManager var1, @NotNull HttpInterface var2, @NotNull String var3, @Nullable String var4) throws CannotBeLoaded, IOException;

    public static enum PlayabilityStatus {
        OK,
        NON_EMBEDDABLE,
        REQUIRES_LOGIN,
        PREMIERE_TRAILER;

    }
}

