/*
 * Decompiled with CFR 0.152.
 */
package dev.lavalink.youtube;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.http.HttpContextFilter;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import dev.lavalink.youtube.CannotBeLoaded;
import dev.lavalink.youtube.ClientInformation;
import dev.lavalink.youtube.UrlTools;
import dev.lavalink.youtube.YoutubeSourceOptions;
import dev.lavalink.youtube.cipher.SignatureCipherManager;
import dev.lavalink.youtube.clients.AndroidTestsuite;
import dev.lavalink.youtube.clients.Music;
import dev.lavalink.youtube.clients.TvHtml5Embedded;
import dev.lavalink.youtube.clients.Web;
import dev.lavalink.youtube.clients.skeleton.Client;
import dev.lavalink.youtube.http.YoutubeAccessTokenTracker;
import dev.lavalink.youtube.http.YoutubeHttpContextFilter;
import dev.lavalink.youtube.http.YoutubeOauth2Handler;
import dev.lavalink.youtube.track.YoutubeAudioTrack;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YoutubeAudioSourceManager
implements AudioSourceManager {
    private static final Logger log = LoggerFactory.getLogger(YoutubeAudioSourceManager.class);
    public static final String SEARCH_PREFIX = "ytsearch:";
    public static final String MUSIC_SEARCH_PREFIX = "ytmsearch:";
    private static final String PROTOCOL_REGEX = "(?:http://|https://|)";
    private static final String DOMAIN_REGEX = "(?:www\\.|m\\.|music\\.|)youtube\\.com";
    private static final String SHORT_DOMAIN_REGEX = "(?:www\\.|)youtu\\.be";
    private static final String VIDEO_ID_REGEX = "(?<v>[a-zA-Z0-9_-]{11})";
    private static final String PLAYLIST_ID_REGEX = "(?<list>(PL|UU)[a-zA-Z0-9_-]+)";
    private static final Pattern directVideoIdPattern = Pattern.compile("^(?<v>[a-zA-Z0-9_-]{11})$");
    private static final Pattern directPlaylistIdPattern = Pattern.compile("^(?<list>(PL|UU)[a-zA-Z0-9_-]+)$");
    private static final Pattern mainDomainPattern = Pattern.compile("^(?:http://|https://|)(?:www\\.|m\\.|music\\.|)youtube\\.com/.*");
    private static final Pattern shortHandPattern = Pattern.compile("^(?:http://|https://|)(?:(?:www\\.|m\\.|music\\.|)youtube\\.com/(?:live|embed|shorts)|(?:www\\.|)youtu\\.be)/(?<videoId>.*)");
    protected final HttpInterfaceManager httpInterfaceManager = HttpClientTools.createCookielessThreadLocalManager();
    protected final boolean allowSearch;
    protected final boolean allowDirectVideoIds;
    protected final boolean allowDirectPlaylistIds;
    protected final Client[] clients;
    protected YoutubeHttpContextFilter contextFilter;
    protected YoutubeOauth2Handler oauth2Handler;
    protected SignatureCipherManager cipherManager;

    public YoutubeAudioSourceManager() {
        this(true);
    }

    public YoutubeAudioSourceManager(boolean allowSearch) {
        this(allowSearch, true, true);
    }

    public YoutubeAudioSourceManager(boolean allowSearch, boolean allowDirectVideoIds, boolean allowDirectPlaylistIds) {
        this(allowSearch, allowDirectVideoIds, allowDirectPlaylistIds, new Music(), new Web(), new AndroidTestsuite(), new TvHtml5Embedded());
    }

    public YoutubeAudioSourceManager(Client ... clients) {
        this(true, true, true, clients);
    }

    public YoutubeAudioSourceManager(boolean allowSearch, Client ... clients) {
        this(allowSearch, true, true, clients);
    }

    public YoutubeAudioSourceManager(boolean allowSearch, boolean allowDirectVideoIds, boolean allowDirectPlaylistIds, Client ... clients) {
        this(new YoutubeSourceOptions().setAllowSearch(allowSearch).setAllowDirectVideoIds(allowDirectVideoIds).setAllowDirectPlaylistIds(allowDirectPlaylistIds), clients);
    }

    public YoutubeAudioSourceManager(YoutubeSourceOptions options, Client ... clients) {
        this.allowSearch = options.isAllowSearch();
        this.allowDirectVideoIds = options.isAllowDirectVideoIds();
        this.allowDirectPlaylistIds = options.isAllowDirectPlaylistIds();
        this.clients = clients;
        this.cipherManager = new SignatureCipherManager();
        this.oauth2Handler = new YoutubeOauth2Handler(this.httpInterfaceManager);
        this.contextFilter = new YoutubeHttpContextFilter();
        this.contextFilter.setTokenTracker(new YoutubeAccessTokenTracker(this.httpInterfaceManager));
        this.contextFilter.setOauth2Handler(this.oauth2Handler);
        this.httpInterfaceManager.setHttpContextFilter((HttpContextFilter)this.contextFilter);
    }

    public String getSourceName() {
        return "youtube";
    }

    public void setPlaylistPageCount(int count) {
        for (Client client : this.clients) {
            client.setPlaylistPageCount(count);
        }
    }

    public void useOauth2(@Nullable String refreshToken, boolean skipInitialization) {
        this.oauth2Handler.setRefreshToken(refreshToken, skipInitialization);
    }

    @Nullable
    public String getOauth2RefreshToken() {
        return this.oauth2Handler.getRefreshToken();
    }

    @Nullable
    public AudioItem loadItem(@NotNull AudioPlayerManager manager, @NotNull AudioReference reference) {
        try {
            return this.loadItemOnce(reference);
        }
        catch (FriendlyException exception) {
            if (HttpClientTools.isRetriableNetworkException((Throwable)exception.getCause())) {
                return this.loadItemOnce(reference);
            }
            throw exception;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    protected AudioItem loadItemOnce(@NotNull AudioReference reference) {
        Throwable lastException = null;
        try (HttpInterface httpInterface = this.httpInterfaceManager.getInterface();){
            Router router = this.getRouter(httpInterface, reference.identifier);
            if (router == null) {
                AudioItem audioItem = null;
                return audioItem;
            }
            if (router == Router.none) {
                AudioReference audioReference = AudioReference.NO_TRACK;
                return audioReference;
            }
            for (Client client : this.clients) {
                if (!client.canHandleRequest(reference.identifier)) continue;
                log.debug("Attempting to load {} with client \"{}\"", (Object)reference.identifier, (Object)client.getIdentifier());
                try {
                    AudioItem item = router.route(client);
                    if (item == null) continue;
                    AudioItem audioItem = item;
                    return audioItem;
                }
                catch (CannotBeLoaded cbl) {
                    throw ExceptionTools.wrapUnfriendlyExceptions((String)"This video cannot be loaded.", (FriendlyException.Severity)FriendlyException.Severity.SUSPICIOUS, (Throwable)cbl.getCause());
                }
                catch (Throwable t) {
                    log.debug("Client \"{}\" threw a non-fatal exception, storing and proceeding...", (Object)client.getIdentifier(), (Object)t);
                    t.addSuppressed(ClientInformation.create(client));
                    lastException = t;
                }
            }
        }
        catch (IOException e) {
            throw ExceptionTools.toRuntimeException((Exception)e);
        }
        if (lastException == null) return null;
        throw ExceptionTools.wrapUnfriendlyExceptions((String)"This video cannot be loaded.", (FriendlyException.Severity)FriendlyException.Severity.SUSPICIOUS, lastException);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    protected Router getRouter(@NotNull HttpInterface httpInterface, @NotNull String identifier) {
        if (identifier.startsWith(SEARCH_PREFIX)) {
            if (!this.allowSearch) return null;
            String trimmed = identifier.substring(SEARCH_PREFIX.length()).trim();
            if (!trimmed.isEmpty()) return client -> client.loadSearch(this, httpInterface, identifier.substring(SEARCH_PREFIX.length()).trim());
            return Router.none;
        }
        if (identifier.startsWith(MUSIC_SEARCH_PREFIX)) {
            if (!this.allowSearch) return null;
            String trimmed = identifier.substring(MUSIC_SEARCH_PREFIX.length()).trim();
            if (!trimmed.isEmpty()) return client -> client.loadSearchMusic(this, httpInterface, identifier.substring(MUSIC_SEARCH_PREFIX.length()).trim());
            return Router.none;
        }
        Matcher mainDomainMatcher = mainDomainPattern.matcher(identifier);
        if (mainDomainMatcher.matches()) {
            String videoIds;
            UrlTools.UrlInfo urlInfo = UrlTools.getUrlInfo(identifier, false);
            if ("/watch".equals(urlInfo.path)) {
                String videoId = urlInfo.parameters.get("v");
                if (videoId != null) {
                    return this.routeFromVideoId(httpInterface, videoId, urlInfo);
                }
            } else if ("/playlist".equals(urlInfo.path)) {
                String playlistId = urlInfo.parameters.get("list");
                if (playlistId != null) {
                    return client -> client.loadPlaylist(this, httpInterface, playlistId, null);
                }
            } else if ("/watch_videos".equals(urlInfo.path) && (videoIds = urlInfo.parameters.get("video_ids")) != null) {
                try (CloseableHttpResponse response = httpInterface.execute((HttpUriRequest)new HttpGet("https://www.youtube.com/watch_videos?video_ids=" + videoIds));){
                    HttpClientTools.assertSuccessWithContent((HttpResponse)response, (String)"playlist response");
                    List redirects = httpInterface.getContext().getRedirectLocations();
                    if (redirects == null) throw new FriendlyException("Unable to process youtube watch_videos link", FriendlyException.Severity.SUSPICIOUS, (Throwable)new IllegalStateException("Expected youtube to redirect watch_videos link to a watch?v={id}&list={list_id} link, but it did not redirect at all"));
                    if (redirects.isEmpty()) throw new FriendlyException("Unable to process youtube watch_videos link", FriendlyException.Severity.SUSPICIOUS, (Throwable)new IllegalStateException("Expected youtube to redirect watch_videos link to a watch?v={id}&list={list_id} link, but it did not redirect at all"));
                    Router router = this.getRouter(httpInterface, ((URI)redirects.get(0)).toString());
                    return router;
                }
                catch (Exception e) {
                    throw ExceptionTools.wrapUnfriendlyExceptions((Throwable)e);
                }
            }
        }
        Matcher directVideoIdMatcher = directVideoIdPattern.matcher(identifier);
        if (this.allowDirectVideoIds && directVideoIdMatcher.matches()) {
            return this.routeFromVideoId(httpInterface, identifier, null);
        }
        Matcher playlistIdMatcher = directPlaylistIdPattern.matcher(identifier);
        if (this.allowDirectPlaylistIds && playlistIdMatcher.matches()) {
            return client -> client.loadPlaylist(this, httpInterface, identifier, null);
        }
        Matcher shortHandMatcher = shortHandPattern.matcher(identifier);
        if (!shortHandMatcher.matches()) return null;
        return this.routeFromVideoId(httpInterface, shortHandMatcher.group("videoId"), null);
    }

    @Nullable
    protected Router routeFromVideoId(@NotNull HttpInterface httpInterface, @NotNull String videoId, @Nullable UrlTools.UrlInfo urlInfo) {
        String trimmedId;
        String string = trimmedId = videoId.length() > 11 ? videoId.substring(0, 11) : videoId;
        if (!directVideoIdPattern.matcher(trimmedId).matches()) {
            return Router.none;
        }
        if (urlInfo != null && urlInfo.parameters.containsKey("list")) {
            String playlistId = urlInfo.parameters.get("list");
            if (playlistId.startsWith("RD")) {
                return client -> client.loadMix(this, httpInterface, playlistId, trimmedId);
            }
            if (!(playlistId.startsWith("LL") || playlistId.startsWith("WL") || playlistId.startsWith("LM"))) {
                return client -> client.loadPlaylist(this, httpInterface, playlistId, trimmedId);
            }
        }
        return client -> client.loadVideo(this, httpInterface, trimmedId);
    }

    @NotNull
    public YoutubeAudioTrack buildAudioTrack(AudioTrackInfo trackInfo) {
        return new YoutubeAudioTrack(trackInfo, this);
    }

    @NotNull
    public SignatureCipherManager getCipherManager() {
        return this.cipherManager;
    }

    @Nullable
    public <T extends Client> T getClient(@NotNull Class<T> cls) {
        for (Client client : this.clients) {
            if (!cls.isAssignableFrom(client.getClass())) continue;
            return (T)((Client)cls.cast(client));
        }
        return null;
    }

    @NotNull
    public Client[] getClients() {
        return this.clients;
    }

    @NotNull
    public YoutubeHttpContextFilter getContextFilter() {
        return this.contextFilter;
    }

    @NotNull
    public YoutubeOauth2Handler getOauth2Handler() {
        return this.oauth2Handler;
    }

    @NotNull
    public HttpInterfaceManager getHttpInterfaceManager() {
        return this.httpInterfaceManager;
    }

    @NotNull
    public HttpInterface getInterface() {
        return this.httpInterfaceManager.getInterface();
    }

    public boolean isTrackEncodable(AudioTrack track) {
        return true;
    }

    public void encodeTrack(AudioTrack track, DataOutput output) {
    }

    @NotNull
    public AudioTrack decodeTrack(@NotNull AudioTrackInfo trackInfo, @NotNull DataInput input) {
        return new YoutubeAudioTrack(trackInfo, this);
    }

    public void shutdown() {
        ExceptionTools.closeWithWarnings((AutoCloseable)this.httpInterfaceManager);
    }

    @FunctionalInterface
    protected static interface Router {
        public static final Router none = unused -> AudioReference.NO_TRACK;

        @Nullable
        public AudioItem route(@NotNull Client var1) throws CannotBeLoaded, IOException;
    }
}

