/*
 * Decompiled with CFR 0.152.
 */
package dev.lavalink.youtube.http;

import com.grack.nanojson.JsonObject;
import com.grack.nanojson.JsonParser;
import com.grack.nanojson.JsonParserException;
import com.grack.nanojson.JsonStringWriter;
import com.grack.nanojson.JsonWriter;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YoutubeOauth2Handler {
    private static final Logger log = LoggerFactory.getLogger(YoutubeOauth2Handler.class);
    private static int fetchErrorLogCount = 0;
    private static final String CLIENT_ID = "861556708454-d6dlm3lh05idd8npek18k6be8ba3oc68.apps.googleusercontent.com";
    private static final String CLIENT_SECRET = "SboVhoG9s0rNafixCSGGKXAT";
    private static final String SCOPES = "http://gdata.youtube.com https://www.googleapis.com/auth/youtube";
    private static final String OAUTH_FETCH_CONTEXT_ATTRIBUTE = "yt-oauth";
    private final HttpInterfaceManager httpInterfaceManager;
    private boolean enabled;
    private String refreshToken;
    private String tokenType;
    private String accessToken;
    private long tokenExpires;

    public YoutubeOauth2Handler(HttpInterfaceManager httpInterfaceManager) {
        this.httpInterfaceManager = httpInterfaceManager;
    }

    public void setRefreshToken(@Nullable String refreshToken, boolean skipInitialization) {
        this.refreshToken = refreshToken;
        this.tokenExpires = System.currentTimeMillis();
        this.accessToken = null;
        if (!DataFormatTools.isNullOrEmpty((String)refreshToken)) {
            this.refreshAccessToken(true);
            this.enabled = true;
            return;
        }
        if (!skipInitialization) {
            this.initializeAccessToken();
        }
    }

    public boolean shouldRefreshAccessToken() {
        return this.enabled && !DataFormatTools.isNullOrEmpty((String)this.refreshToken) && (DataFormatTools.isNullOrEmpty((String)this.accessToken) || System.currentTimeMillis() >= this.tokenExpires);
    }

    @Nullable
    public String getRefreshToken() {
        return this.refreshToken;
    }

    public boolean isOauthFetchContext(HttpClientContext context) {
        return context.getAttribute(OAUTH_FETCH_CONTEXT_ATTRIBUTE) == Boolean.TRUE;
    }

    private void initializeAccessToken() {
        JsonObject response = this.fetchDeviceCode();
        log.debug("fetch device code response: {}", (Object)JsonWriter.string((Object)response));
        String verificationUrl = response.getString("verification_url");
        String userCode = response.getString("user_code");
        String deviceCode = response.getString("device_code");
        long interval = response.getLong("interval") * 1000L;
        log.info("==================================================");
        log.info("!!! DO NOT AUTHORISE WITH YOUR MAIN ACCOUNT, USE A BURNER !!!");
        log.info("OAUTH INTEGRATION: To give youtube-source access to your account, go to {} and enter code {}", (Object)verificationUrl, (Object)userCode);
        log.info("!!! DO NOT AUTHORISE WITH YOUR MAIN ACCOUNT, USE A BURNER !!!");
        log.info("==================================================");
        new Thread(() -> this.pollForToken(deviceCode, interval == 0L ? 5000L : interval), "youtube-source-token-poller").start();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private JsonObject fetchDeviceCode() {
        String requestJson = ((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)JsonWriter.string().object()).value("client_id", CLIENT_ID)).value("scope", SCOPES)).value("device_id", UUID.randomUUID().toString().replace("-", ""))).value("device_model", "ytlr::")).end()).done();
        HttpPost request = new HttpPost("https://www.youtube.com/o/oauth2/device/code");
        StringEntity body = new StringEntity(requestJson, ContentType.APPLICATION_JSON);
        request.setEntity((HttpEntity)body);
        try (HttpInterface httpInterface = this.getHttpInterface();){
            JsonObject jsonObject;
            block14: {
                CloseableHttpResponse response = httpInterface.execute((HttpUriRequest)request);
                try {
                    HttpClientTools.assertSuccessWithContent((HttpResponse)response, (String)"device code fetch");
                    jsonObject = (JsonObject)JsonParser.object().from(response.getEntity().getContent());
                    if (response == null) break block14;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return jsonObject;
        }
        catch (JsonParserException | IOException e) {
            throw ExceptionTools.toRuntimeException((Exception)e);
        }
    }

    /*
     * Exception decompiling
     */
    private void pollForToken(String deviceCode, long interval) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshAccessToken(boolean force) {
        log.debug("Refreshing access token (force: {})", (Object)force);
        if (DataFormatTools.isNullOrEmpty((String)this.refreshToken)) {
            throw new IllegalStateException("Cannot fetch access token without a refresh token!");
        }
        if (!this.shouldRefreshAccessToken() && !force) {
            log.debug("Access token does not need to be refreshed yet.");
            return;
        }
        YoutubeOauth2Handler youtubeOauth2Handler = this;
        synchronized (youtubeOauth2Handler) {
            if (DataFormatTools.isNullOrEmpty((String)this.refreshToken)) {
                throw new IllegalStateException("Cannot fetch access token without a refresh token!");
            }
            if (!this.shouldRefreshAccessToken() && !force) {
                log.debug("Access token does not need to be refreshed yet.");
                return;
            }
            String requestJson = ((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)JsonWriter.string().object()).value("client_id", CLIENT_ID)).value("client_secret", CLIENT_SECRET)).value("refresh_token", this.refreshToken)).value("grant_type", "refresh_token")).end()).done();
            HttpPost request = new HttpPost("https://www.youtube.com/o/oauth2/token");
            StringEntity entity = new StringEntity(requestJson, ContentType.APPLICATION_JSON);
            request.setEntity((HttpEntity)entity);
            try (HttpInterface httpInterface = this.getHttpInterface();
                 CloseableHttpResponse response = httpInterface.execute((HttpUriRequest)request);){
                HttpClientTools.assertSuccessWithContent((HttpResponse)response, (String)"oauth2 token fetch");
                JsonObject parsed = (JsonObject)JsonParser.object().from(response.getEntity().getContent());
                if (parsed.has("error") && !parsed.isNull("error")) {
                    throw new RuntimeException("Refreshing access token returned error " + parsed.getString("error"));
                }
                this.updateTokens(parsed);
                log.info("YouTube access token refreshed successfully");
            }
            catch (JsonParserException | IOException e) {
                throw ExceptionTools.toRuntimeException((Exception)e);
            }
        }
    }

    private void updateTokens(JsonObject json) {
        long tokenLifespan = json.getLong("expires_in");
        this.tokenType = json.getString("token_type");
        this.accessToken = json.getString("access_token");
        this.refreshToken = json.getString("refresh_token", this.refreshToken);
        this.tokenExpires = System.currentTimeMillis() + tokenLifespan * 1000L - 60000L;
        log.debug("OAuth access token is {} and refresh token is {}. Access token expires in {} seconds.", new Object[]{this.accessToken, this.refreshToken, tokenLifespan});
    }

    public void applyToken(HttpUriRequest request) {
        if (!this.enabled || DataFormatTools.isNullOrEmpty((String)this.refreshToken)) {
            return;
        }
        if (!"https://youtubei.googleapis.com/youtubei/v1/player?prettyPrint=false".equals(request.getURI().toString())) {
            return;
        }
        if (this.shouldRefreshAccessToken()) {
            log.debug("Access token has expired, refreshing...");
            try {
                this.refreshAccessToken(false);
            }
            catch (Throwable t) {
                if (++fetchErrorLogCount <= 3) {
                    log.error("Refreshing YouTube access token failed", t);
                } else {
                    log.debug("Refreshing YouTube access token failed", t);
                }
                this.tokenExpires = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(15L);
                return;
            }
            fetchErrorLogCount = 0;
        }
        if (this.accessToken != null && this.tokenType != null && System.currentTimeMillis() < this.tokenExpires) {
            log.debug("Using oauth authorization header with value \"{} {}\"", (Object)this.tokenType, (Object)this.accessToken);
            request.setHeader("Authorization", String.format("%s %s", this.tokenType, this.accessToken));
        }
    }

    private HttpInterface getHttpInterface() {
        HttpInterface httpInterface = this.httpInterfaceManager.getInterface();
        httpInterface.getContext().setAttribute(OAUTH_FETCH_CONTEXT_ATTRIBUTE, (Object)true);
        return httpInterface;
    }
}

