/*
 * Decompiled with CFR 0.152.
 */
package dev.lavalink.youtube.clients.skeleton;

import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.ThumbnailTools;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import dev.lavalink.youtube.YoutubeAudioSourceManager;
import dev.lavalink.youtube.clients.skeleton.MusicClient;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ThumbnailMusicClient
extends MusicClient {
    private static final Logger log = LoggerFactory.getLogger(ThumbnailMusicClient.class);

    @NotNull
    protected List<AudioTrack> extractSearchResultTracks(@NotNull YoutubeAudioSourceManager source, @NotNull JsonBrowser json) {
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        for (JsonBrowser track : json.values()) {
            JsonBrowser lastElement;
            JsonBrowser thumbnail = track.get("musicResponsiveListItemRenderer").get("thumbnail").get("musicThumbnailRenderer");
            JsonBrowser columns = track.get("musicResponsiveListItemRenderer").get("flexColumns");
            if (columns.isNull()) continue;
            JsonBrowser metadata = columns.index(0).get("musicResponsiveListItemFlexColumnRenderer").get("text").get("runs").index(0);
            String title = metadata.get("text").text();
            String videoId = metadata.get("navigationEndpoint").get("watchEndpoint").get("videoId").text();
            if (videoId == null) continue;
            List runs = columns.index(1).get("musicResponsiveListItemFlexColumnRenderer").get("text").get("runs").values();
            String author = ((JsonBrowser)runs.get(0)).get("text").text();
            if (author == null) {
                log.debug("Author field is null, client: {}, json: {}", (Object)this.getIdentifier(), (Object)json.format());
                author = "Unknown artist";
            }
            if (!(lastElement = (JsonBrowser)runs.get(runs.size() - 1)).get("navigationEndpoint").isNull()) continue;
            long duration = DataFormatTools.durationTextToMillis((String)lastElement.get("text").text());
            String thumbnailUrl = ThumbnailTools.getYouTubeMusicThumbnail((JsonBrowser)thumbnail, (String)videoId);
            AudioTrackInfo info = new AudioTrackInfo(title, author, duration, videoId, false, "https://www.youtube.com/watch?v=" + videoId, thumbnailUrl, null);
            tracks.add((AudioTrack)source.buildAudioTrack(info));
        }
        return tracks;
    }
}

