/*
 * Decompiled with CFR 0.152.
 */
package dev.lavalink.youtube.plugin;

import com.grack.nanojson.JsonArray;
import com.grack.nanojson.JsonObject;
import com.grack.nanojson.JsonParser;
import com.grack.nanojson.JsonParserException;
import dev.lavalink.youtube.YoutubeSource;
import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ModuleDescriptor;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginInfo {
    private static final Logger log = LoggerFactory.getLogger(PluginInfo.class);

    public static void checkForNewRelease() throws IOException, JsonParserException {
        String versionS = YoutubeSource.VERSION;
        if ("Unknown".equals(versionS)) {
            return;
        }
        ModuleDescriptor.Version currentVersion = ModuleDescriptor.Version.parse(versionS);
        URL url = new URL("https://api.github.com/repos/lavalink-devs/youtube-source/releases");
        try (InputStream body = url.openStream();){
            JsonArray json = JsonParser.array().from(body);
            ModuleDescriptor.Version latestVersion = null;
            JsonObject latestRelease = null;
            for (int i = 0; i < json.size(); ++i) {
                JsonObject release = json.getObject(i);
                if (!release.has("tag_name") || release.isNull("tag_name") || release.getBoolean("draft", false)) continue;
                ModuleDescriptor.Version version = ModuleDescriptor.Version.parse(release.getString("tag_name"));
                if (latestVersion != null && version.compareTo(latestVersion) <= 0) continue;
                latestVersion = version;
                latestRelease = release;
            }
            if (latestVersion != null && latestVersion.compareTo(currentVersion) > 0) {
                log.info("********************************************\nYOUTUBE-SOURCE VERSION {} AVAILABLE\n{}\nUpdate to ensure the YouTube source remains operational!\n********************************************", (Object)latestVersion, (Object)latestRelease.getString("html_url"));
            }
        }
    }
}

