/*
 * Decompiled with CFR 0.152.
 */
package dev.lavalink.youtube.cipher;

import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import dev.lavalink.youtube.YoutubeSource;
import dev.lavalink.youtube.cipher.CipherOperation;
import dev.lavalink.youtube.cipher.CipherOperationType;
import dev.lavalink.youtube.cipher.SignatureCipher;
import dev.lavalink.youtube.track.format.StreamFormat;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.mozilla.javascript.engine.RhinoScriptEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureCipherManager {
    private static final Logger log = LoggerFactory.getLogger(SignatureCipherManager.class);
    private static final String VARIABLE_PART = "[a-zA-Z_\\$][a-zA-Z_0-9]*";
    private static final String VARIABLE_PART_DEFINE = "\\\"?[a-zA-Z_\\$][a-zA-Z_0-9]*\\\"?";
    private static final String BEFORE_ACCESS = "(?:\\[\\\"|\\.)";
    private static final String AFTER_ACCESS = "(?:\\\"\\]|)";
    private static final String VARIABLE_PART_ACCESS = "(?:\\[\\\"|\\.)[a-zA-Z_\\$][a-zA-Z_0-9]*(?:\\\"\\]|)";
    private static final String REVERSE_PART = ":function\\(\\w\\)\\{(?:return )?\\w\\.reverse\\(\\)\\}";
    private static final String SLICE_PART = ":function\\(\\w,\\w\\)\\{return \\w\\.slice\\(\\w\\)\\}";
    private static final String SPLICE_PART = ":function\\(\\w,\\w\\)\\{\\w\\.splice\\(0,\\w\\)\\}";
    private static final String SWAP_PART = ":function\\(\\w,\\w\\)\\{var \\w=\\w\\[0\\];\\w\\[0\\]=\\w\\[\\w%\\w\\.length\\];\\w\\[\\w(?:%\\w.length|)\\]=\\w(?:;return \\w)?\\}";
    private static final Pattern functionPattern = Pattern.compile("function(?: [a-zA-Z_\\$][a-zA-Z_0-9]*)?\\(([a-zA-Z])\\)\\{\\1=\\1\\.split\\(\"\"\\);\\s*((?:(?:\\1=)?[a-zA-Z_\\$][a-zA-Z_0-9]*(?:\\[\\\"|\\.)[a-zA-Z_\\$][a-zA-Z_0-9]*(?:\\\"\\]|)\\(\\1,\\d+\\);)+)return \\1\\.join\\(\"\"\\)\\}");
    private static final Pattern actionsPattern = Pattern.compile("var ([a-zA-Z_\\$][a-zA-Z_0-9]*)=\\{((?:(?:\\\"?[a-zA-Z_\\$][a-zA-Z_0-9]*\\\"?:function\\(\\w\\)\\{(?:return )?\\w\\.reverse\\(\\)\\}|\\\"?[a-zA-Z_\\$][a-zA-Z_0-9]*\\\"?:function\\(\\w,\\w\\)\\{return \\w\\.slice\\(\\w\\)\\}|\\\"?[a-zA-Z_\\$][a-zA-Z_0-9]*\\\"?:function\\(\\w,\\w\\)\\{\\w\\.splice\\(0,\\w\\)\\}|\\\"?[a-zA-Z_\\$][a-zA-Z_0-9]*\\\"?:function\\(\\w,\\w\\)\\{var \\w=\\w\\[0\\];\\w\\[0\\]=\\w\\[\\w%\\w\\.length\\];\\w\\[\\w(?:%\\w.length|)\\]=\\w(?:;return \\w)?\\}),?\\n?)+)\\};");
    private static final String PATTERN_PREFIX = "(?:^|,)\\\"?([a-zA-Z_\\$][a-zA-Z_0-9]*)\\\"?";
    private static final Pattern reversePattern = Pattern.compile("(?:^|,)\\\"?([a-zA-Z_\\$][a-zA-Z_0-9]*)\\\"?:function\\(\\w\\)\\{(?:return )?\\w\\.reverse\\(\\)\\}", 8);
    private static final Pattern slicePattern = Pattern.compile("(?:^|,)\\\"?([a-zA-Z_\\$][a-zA-Z_0-9]*)\\\"?:function\\(\\w,\\w\\)\\{return \\w\\.slice\\(\\w\\)\\}", 8);
    private static final Pattern splicePattern = Pattern.compile("(?:^|,)\\\"?([a-zA-Z_\\$][a-zA-Z_0-9]*)\\\"?:function\\(\\w,\\w\\)\\{\\w\\.splice\\(0,\\w\\)\\}", 8);
    private static final Pattern swapPattern = Pattern.compile("(?:^|,)\\\"?([a-zA-Z_\\$][a-zA-Z_0-9]*)\\\"?:function\\(\\w,\\w\\)\\{var \\w=\\w\\[0\\];\\w\\[0\\]=\\w\\[\\w%\\w\\.length\\];\\w\\[\\w(?:%\\w.length|)\\]=\\w(?:;return \\w)?\\}", 8);
    private static final Pattern timestampPattern = Pattern.compile("(signatureTimestamp|sts):(\\d+)");
    private static final Pattern nFunctionPattern = Pattern.compile("function\\(\\s*(\\w+)\\s*\\)\\s*\\{var\\s*(\\w+)=(?:\\1\\.split\\(.*?\\)|String\\.prototype\\.split\\.call\\(\\1,.*?\\)),\\s*(\\w+)=(\\[.*?]);\\s*\\3\\[\\d+](.*?try)(\\{.*?})catch\\(\\s*(\\w+)\\s*\\)\\s*\\{\\s*return\"[\\w-]+([A-z0-9-]+)\"\\s*\\+\\s*\\1\\s*}\\s*return\\s*(\\2\\.join\\(\"\"\\)|Array\\.prototype\\.join\\.call\\(\\2,.*?\\))};", 32);
    private final ConcurrentMap<String, SignatureCipher> cipherCache = new ConcurrentHashMap<String, SignatureCipher>();
    private final Set<String> dumpedScriptUrls = new HashSet<String>();
    private final ScriptEngine scriptEngine = new RhinoScriptEngineFactory().getScriptEngine();
    private final Object cipherLoadLock = new Object();
    protected volatile CachedPlayerScript cachedPlayerScript;

    @NotNull
    public URI resolveFormatUrl(@NotNull HttpInterface httpInterface, @NotNull String playerScript, @NotNull StreamFormat format) throws IOException {
        String signature = format.getSignature();
        String nParameter = format.getNParameter();
        URI initialUrl = format.getUrl();
        URIBuilder uri = new URIBuilder(initialUrl);
        SignatureCipher cipher = this.getCipherScript(httpInterface, playerScript);
        if (!DataFormatTools.isNullOrEmpty((String)signature)) {
            uri.setParameter(format.getSignatureKey(), cipher.apply(signature));
        }
        if (!DataFormatTools.isNullOrEmpty((String)nParameter)) {
            try {
                String transformed = cipher.transform(nParameter, this.scriptEngine);
                String logMessage = null;
                if (transformed == null) {
                    logMessage = "Transformed n parameter is null, n function possibly faulty";
                } else if (nParameter.equals(transformed)) {
                    logMessage = "Transformed n parameter is the same as input, n function possibly short-circuited";
                } else if (transformed.startsWith("enhanced_except_") || transformed.endsWith("_w8_" + nParameter)) {
                    logMessage = "N function did not complete due to exception";
                }
                if (logMessage != null) {
                    log.warn("{} (in: {}, out: {}, player script: {}, source version: {})", new Object[]{logMessage, nParameter, transformed, playerScript, YoutubeSource.VERSION});
                }
                uri.setParameter("n", transformed);
            }
            catch (NoSuchMethodException | ScriptException e) {
                this.dumpProblematicScript(((SignatureCipher)this.cipherCache.get((Object)playerScript)).rawScript, playerScript, "Can't transform n parameter " + nParameter + " with " + cipher.nFunction + " n function");
            }
        }
        try {
            return uri.build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private CachedPlayerScript getPlayerScript(@NotNull HttpInterface httpInterface) {
        Object object = this.cipherLoadLock;
        synchronized (object) {
            CachedPlayerScript cachedPlayerScript;
            block12: {
                CloseableHttpResponse response = httpInterface.execute((HttpUriRequest)new HttpGet("https://www.youtube.com/embed/"));
                try {
                    HttpClientTools.assertSuccessWithContent((HttpResponse)response, (String)"fetch player script (embed)");
                    String responseText = EntityUtils.toString((HttpEntity)response.getEntity());
                    String scriptUrl = DataFormatTools.extractBetween((String)responseText, (String)"\"jsUrl\":\"", (String)"\"");
                    if (scriptUrl == null) {
                        throw ExceptionTools.throwWithDebugInfo((Logger)log, null, (String)"no jsUrl found", (String)"html", (String)responseText);
                    }
                    cachedPlayerScript = this.cachedPlayerScript = new CachedPlayerScript(scriptUrl);
                    if (response == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw ExceptionTools.toRuntimeException((Exception)e);
                    }
                }
                response.close();
            }
            return cachedPlayerScript;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedPlayerScript getCachedPlayerScript(@NotNull HttpInterface httpInterface) {
        if (this.cachedPlayerScript == null || System.currentTimeMillis() >= this.cachedPlayerScript.expireTimestampMs) {
            Object object = this.cipherLoadLock;
            synchronized (object) {
                if (this.cachedPlayerScript == null || System.currentTimeMillis() >= this.cachedPlayerScript.expireTimestampMs) {
                    return this.getPlayerScript(httpInterface);
                }
            }
        }
        return this.cachedPlayerScript;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignatureCipher getCipherScript(@NotNull HttpInterface httpInterface, @NotNull String cipherScriptUrl) throws IOException {
        SignatureCipher cipherKey = (SignatureCipher)this.cipherCache.get(cipherScriptUrl);
        if (cipherKey == null) {
            Object object = this.cipherLoadLock;
            synchronized (object) {
                log.debug("Parsing player script {}", (Object)cipherScriptUrl);
                try (CloseableHttpResponse response = httpInterface.execute((HttpUriRequest)new HttpGet(SignatureCipherManager.parseTokenScriptUrl(cipherScriptUrl)));){
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (!HttpClientTools.isSuccessWithContent((int)statusCode)) {
                        throw new IOException("Received non-success response code " + statusCode + " from script url " + cipherScriptUrl + " ( " + SignatureCipherManager.parseTokenScriptUrl(cipherScriptUrl) + " )");
                    }
                    cipherKey = this.extractFromScript(EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8), cipherScriptUrl);
                    this.cipherCache.put(cipherScriptUrl, cipherKey);
                }
            }
        }
        return cipherKey;
    }

    private List<String> getQuotedFunctions(String ... functionNames) {
        return Stream.of(functionNames).filter(Objects::nonNull).map(Pattern::quote).collect(Collectors.toList());
    }

    private void dumpProblematicScript(@NotNull String script, @NotNull String sourceUrl, @NotNull String issue) {
        if (!this.dumpedScriptUrls.add(sourceUrl)) {
            return;
        }
        try {
            Path path = Files.createTempFile("lavaplayer-yt-player-script", ".js", new FileAttribute[0]);
            Files.write(path, script.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            log.error("Problematic YouTube player script {} detected (issue detected with script: {}). Dumped to {} (Source version: {})", new Object[]{sourceUrl, issue, path.toAbsolutePath(), YoutubeSource.VERSION});
        }
        catch (Exception e) {
            log.error("Failed to dump problematic YouTube player script {} (issue detected with script: {})", (Object)sourceUrl, (Object)issue);
        }
    }

    private SignatureCipher extractFromScript(@NotNull String script, @NotNull String sourceUrl) {
        Matcher actions = actionsPattern.matcher(script);
        Matcher nFunctionMatcher = nFunctionPattern.matcher(script);
        Matcher scriptTimestamp = timestampPattern.matcher(script);
        if (!actions.find()) {
            this.dumpProblematicScript(script, sourceUrl, "no actions match");
            throw new IllegalStateException("Must find action functions from script: " + sourceUrl);
        }
        String actionBody = actions.group(2);
        String reverseKey = SignatureCipherManager.extractDollarEscapedFirstGroup(reversePattern, actionBody);
        String slicePart = SignatureCipherManager.extractDollarEscapedFirstGroup(slicePattern, actionBody);
        String splicePart = SignatureCipherManager.extractDollarEscapedFirstGroup(splicePattern, actionBody);
        String swapKey = SignatureCipherManager.extractDollarEscapedFirstGroup(swapPattern, actionBody);
        Pattern extractor = Pattern.compile("(?:\\w=)?" + Pattern.quote(actions.group(1)) + BEFORE_ACCESS + "(" + String.join((CharSequence)"|", this.getQuotedFunctions(reverseKey, slicePart, splicePart, swapKey)) + ")" + AFTER_ACCESS + "\\(\\w,(\\d+)\\)");
        Matcher functions = functionPattern.matcher(script);
        if (!functions.find()) {
            this.dumpProblematicScript(script, sourceUrl, "no decipher function match");
            throw new IllegalStateException("Must find decipher function from script.");
        }
        Matcher matcher = extractor.matcher(functions.group(2));
        if (!scriptTimestamp.find()) {
            this.dumpProblematicScript(script, sourceUrl, "no timestamp match");
            throw new IllegalStateException("Must find timestamp from script: " + sourceUrl);
        }
        if (!nFunctionMatcher.find()) {
            this.dumpProblematicScript(script, sourceUrl, "no n function match");
            throw new IllegalStateException("Must find n function from script: " + sourceUrl);
        }
        String nFunction = nFunctionMatcher.group(0);
        String nfParameterName = DataFormatTools.extractBetween((String)nFunction, (String)"(", (String)")");
        nFunction = nFunction.replaceAll("if\\s*\\(\\s*typeof\\s*\\w+\\s*===?.*?\\)\\s*return\\s+" + nfParameterName + "\\s*;?", "");
        SignatureCipher cipherKey = new SignatureCipher(nFunction, scriptTimestamp.group(2), script);
        while (matcher.find()) {
            String type = matcher.group(1);
            if (type.equals(swapKey)) {
                cipherKey.addOperation(new CipherOperation(CipherOperationType.SWAP, Integer.parseInt(matcher.group(2))));
                continue;
            }
            if (type.equals(reverseKey)) {
                cipherKey.addOperation(new CipherOperation(CipherOperationType.REVERSE, 0));
                continue;
            }
            if (type.equals(slicePart)) {
                cipherKey.addOperation(new CipherOperation(CipherOperationType.SLICE, Integer.parseInt(matcher.group(2))));
                continue;
            }
            if (type.equals(splicePart)) {
                cipherKey.addOperation(new CipherOperation(CipherOperationType.SPLICE, Integer.parseInt(matcher.group(2))));
                continue;
            }
            this.dumpProblematicScript(script, sourceUrl, "unknown cipher operation found");
        }
        if (cipherKey.isEmpty()) {
            log.error("No operations detected from cipher extracted from {}.", (Object)sourceUrl);
            this.dumpProblematicScript(script, sourceUrl, "no cipher operations");
        }
        return cipherKey;
    }

    private static String extractDollarEscapedFirstGroup(@NotNull Pattern pattern, @NotNull String text) {
        Matcher matcher = pattern.matcher(text);
        return matcher.find() ? matcher.group(1).replace("$", "\\$") : null;
    }

    private static URI parseTokenScriptUrl(@NotNull String urlString) {
        try {
            if (urlString.startsWith("//")) {
                return new URI("https:" + urlString);
            }
            if (urlString.startsWith("/")) {
                return new URI("https://www.youtube.com" + urlString);
            }
            return new URI(urlString);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static class CachedPlayerScript {
        public final String url;
        public final long expireTimestampMs;

        protected CachedPlayerScript(@NotNull String url) {
            this.url = url;
            this.expireTimestampMs = System.currentTimeMillis() + TimeUnit.DAYS.toMillis(1L);
        }
    }
}

