/*
 * Decompiled with CFR 0.152.
 */
package dev.lavalink.youtube.plugin;

import dev.lavalink.youtube.clients.ClientOptions;
import dev.lavalink.youtube.clients.skeleton.Client;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ClientProvider {
    public static final Logger log = LoggerFactory.getLogger(ClientProvider.class);

    public Client[] getClients(String[] var1, OptionsProvider var2);

    default public Client[] getClients(ClientReference[] clientValues, String[] clients, OptionsProvider optionsProvider) {
        ArrayList<Client> resolved = new ArrayList<Client>();
        for (String clientName : clients) {
            Client client = ClientProvider.getClientByName(clientValues, clientName, optionsProvider);
            if (client == null) {
                log.warn("Failed to resolve {} into a Client", (Object)clientName);
                continue;
            }
            resolved.add(client);
        }
        return resolved.toArray(new Client[0]);
    }

    public static Client getClientByName(ClientReference[] enumValues, String name, OptionsProvider provider) {
        return Arrays.stream(enumValues).filter(it -> it.getName().equals(name)).findFirst().map(ref -> {
            ClientOptions options = provider.getOptionsForClient(name);
            log.debug("Initialising client {} with options {}", (Object)ref.getName(), (Object)options);
            return ref.getClient(options);
        }).orElse(null);
    }

    public static interface ClientReference {
        public String getName();

        public Client getClient(ClientOptions var1);
    }

    public static interface OptionsProvider {
        public ClientOptions getOptionsForClient(String var1);
    }
}

