/*
 * Decompiled with CFR 0.152.
 */
package dev.lavalink.youtube.http;

import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import dev.lavalink.youtube.clients.Android;
import dev.lavalink.youtube.clients.ClientConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.StringEntity;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YoutubeAccessTokenTracker {
    private static final Logger log = LoggerFactory.getLogger(YoutubeAccessTokenTracker.class);
    private static final String TOKEN_FETCH_CONTEXT_ATTRIBUTE = "yt-raw";
    private static final long VISITOR_ID_REFRESH_INTERVAL = TimeUnit.MINUTES.toMillis(10L);
    private final Object tokenLock = new Object();
    private final HttpInterfaceManager httpInterfaceManager;
    private String visitorId;
    private long lastVisitorIdUpdate;

    public YoutubeAccessTokenTracker(@NotNull HttpInterfaceManager httpInterfaceManager) {
        this.httpInterfaceManager = httpInterfaceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVisitorId() {
        long now = System.currentTimeMillis();
        if (this.visitorId == null || now - this.lastVisitorIdUpdate < VISITOR_ID_REFRESH_INTERVAL) {
            Object object = this.tokenLock;
            synchronized (object) {
                if (now - this.lastVisitorIdUpdate < VISITOR_ID_REFRESH_INTERVAL) {
                    log.debug("YouTube visitor id was recently updated, not updating again right away.");
                    return this.visitorId;
                }
                this.lastVisitorIdUpdate = now;
                try {
                    this.visitorId = this.fetchVisitorId();
                    log.info("Updating YouTube visitor id succeeded, new one is {}, next update will be after {} seconds.", (Object)this.visitorId, (Object)TimeUnit.MILLISECONDS.toSeconds(VISITOR_ID_REFRESH_INTERVAL));
                }
                catch (Exception e) {
                    log.error("YouTube visitor id update failed.", (Throwable)e);
                }
            }
        }
        return this.visitorId;
    }

    public boolean isTokenFetchContext(@NotNull HttpClientContext context) {
        return context.removeAttribute(TOKEN_FETCH_CONTEXT_ATTRIBUTE) == Boolean.TRUE;
    }

    private String fetchVisitorId() throws IOException {
        try (HttpInterface httpInterface = this.httpInterfaceManager.getInterface();){
            String string;
            block12: {
                httpInterface.getContext().setAttribute(TOKEN_FETCH_CONTEXT_ATTRIBUTE, (Object)true);
                ClientConfig client = Android.BASE_CONFIG.setAttributes(httpInterface);
                HttpPost visitorIdPost = new HttpPost("https://youtubei.googleapis.com/youtubei/v1/visitor_id");
                visitorIdPost.setEntity((HttpEntity)new StringEntity(client.toJsonString(), "UTF-8"));
                CloseableHttpResponse response = httpInterface.execute((HttpUriRequest)visitorIdPost);
                try {
                    HttpClientTools.assertSuccessWithContent((HttpResponse)response, (String)"youtube visitor id");
                    JsonBrowser json = JsonBrowser.parse((InputStream)response.getEntity().getContent());
                    string = json.get("responseContext").get("visitorData").text();
                    if (response == null) break block12;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
    }
}

